/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IPersistableElement;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelElementToPersistableElementAdapter;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class WebflowConfig
extends AbstractModelElement
implements IWebflowConfig,
IAdaptable {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private Set<String> beansConfigs = new HashSet<String>();
    private IFile resource;
    private String name;
    private final IWebflowProject project;

    @Override
    public IWebflowProject getProject() {
        return this.project;
    }

    public WebflowConfig(IWebflowProject project) {
        this.project = project;
    }

    @Override
    public Set<IModelElement> getBeansConfigs() {
        IBeansModel model = BeansCorePlugin.getModel();
        HashSet<IModelElement> configs = new HashSet<IModelElement>();
        try {
            this.r.lock();
            if (this.beansConfigs != null) {
                for (String configName : this.beansConfigs) {
                    IModelElement config = model.getElement(configName);
                    if (config == null) continue;
                    configs.add(config);
                }
            }
        }
        finally {
            this.r.unlock();
        }
        return configs;
    }

    @Override
    public IFile getResource() {
        return this.resource;
    }

    @Override
    public void setBeansConfigs(Set<IModelElement> beansConfigs) {
        try {
            this.w.lock();
            this.beansConfigs = new HashSet<String>();
            if (beansConfigs != null) {
                for (IModelElement config : beansConfigs) {
                    if (BeansModelUtils.getProject((IModelElement)config) == null || !BeansModelUtils.getProject((IModelElement)config).getProject().equals((Object)this.project.getProject())) continue;
                    this.beansConfigs.add(config.getElementID());
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void setResource(IFile file) {
        this.resource = file;
        if (this.name == null && this.resource != null) {
            int i = this.resource.getName().lastIndexOf(46);
            this.name = i > 0 ? this.resource.getName().substring(0, i) : this.resource.getName();
        }
    }

    @Override
    public void setBeansConfigsElementIds(Set<String> beansConfigs) {
        try {
            this.w.lock();
            this.beansConfigs = beansConfigs;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void addBeansConfigElementId(String id) {
        try {
            this.w.lock();
            this.beansConfigs.add(id);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 3;
    }

    public IModelElement[] getElementChildren() {
        ArrayList children = new ArrayList();
        try {
            this.r.lock();
            IModelElement[] iModelElementArray = children.toArray(new IModelElement[children.size()]);
            return iModelElementArray;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPersistableElement.class) {
            return new WebflowModelElementToPersistableElementAdapter(this);
        }
        if (adapter == IResource.class) {
            return this.getResource();
        }
        return null;
    }

    @Override
    public IModelElement getElementParent() {
        return this.project;
    }

    @Override
    public IResource getElementResource() {
        return this.resource;
    }

    @Override
    public boolean isElementArchived() {
        return false;
    }
}

