/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalAdapter;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalProvider;
import org.springframework.ide.eclipse.config.core.schemas.OsgiSchemaConstants;
import org.springframework.ide.eclipse.config.ui.wizards.AbstractConfigWizard;
import org.springframework.ide.eclipse.config.ui.wizards.AbstractConfigWizardPage;
import org.springframework.ide.eclipse.config.ui.wizards.InterfaceTableContentProvider;
import org.springframework.ide.eclipse.config.ui.wizards.Messages;
import org.springframework.ide.eclipse.wizard.core.WizardBeanReferenceContentProposalProvider;
import org.w3c.dom.Document;

public class OsgiServiceWizardPage
extends AbstractConfigWizardPage {
    private Text idText;
    private Text refText;
    private CheckboxTableViewer interfaceTable;

    protected OsgiServiceWizardPage(AbstractConfigWizard wizard) {
        super(wizard, "OsgiServiceWizardPage");
        this.setTitle(Messages.getString("OsgiServiceWizardPage.PAGE_TITLE"));
    }

    @Override
    protected void createAttributes(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label idLabel = new Label(container, 0);
        idLabel.setText(OsgiSchemaConstants.ATTR_ID);
        this.idText = new Text(container, 2052);
        this.idText.setLayoutData((Object)new GridData(768));
        Label refLabel = new Label(container, 0);
        refLabel.setText(OsgiSchemaConstants.ATTR_REF);
        this.refText = new Text(container, 2052);
        this.refText.setLayoutData((Object)new GridData(768));
        Label interfaceLabel = new Label(container, 0);
        interfaceLabel.setText(OsgiSchemaConstants.ATTR_INTERFACE);
        this.interfaceTable = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
        this.interfaceTable.setContentProvider((IContentProvider)new InterfaceTableContentProvider(this.getResourceFile(), this.getDomDocument()));
        this.interfaceTable.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
        this.interfaceTable.setInput((Object)this.refText);
        GC gc = new GC((Drawable)interfaceLabel);
        FontMetrics fm = gc.getFontMetrics();
        int height = 5 * fm.getHeight();
        gc.dispose();
        GridData data = new GridData(1808);
        data.heightHint = this.interfaceTable.getTable().computeSize((int)-1, (int)height).y;
        this.interfaceTable.getTable().setLayoutData((Object)data);
        this.refText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OsgiServiceWizardPage.this.interfaceTable.refresh();
            }
        });
        this.setControl((Control)container);
    }

    public String getId() {
        return this.idText.getText();
    }

    public List<Object> getInterfaces() {
        return Arrays.asList(this.interfaceTable.getCheckedElements());
    }

    public String getRef() {
        return this.refText.getText();
    }

    @Override
    protected void hookContentProposalAdapters() {
        new XmlBackedContentProposalAdapter((Control)this.refText, (IControlContentAdapter)new TextContentAdapter(), (XmlBackedContentProposalProvider)new WizardBeanReferenceContentProposalProvider(this.getInput(), OsgiSchemaConstants.ATTR_REF, this.getResourceFile(), (Document)this.getDomDocument(), true));
    }
}

