/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.part.FileEditorInput;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphImages;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInput;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigGraphPage;
import org.springframework.ide.eclipse.config.ui.navigator.Messages;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class StsShowBeansGraphAction
extends AbstractNavigatorAction {
    private IResourceModelElement element;
    private IModelElement context;

    public StsShowBeansGraphAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText(Messages.getString("StsShowBeansGraphAction.TEXT"));
        this.setToolTipText(Messages.getString("StsShowBeansGraphAction.TOOLTIP"));
        this.setImageDescriptor(BeansGraphImages.DESC_OBJS_BEANS_GPRAH);
    }

    public boolean isEnabled(IStructuredSelection selection) {
        ITreeSelection tSelection;
        if (selection instanceof ITreeSelection && (tSelection = (ITreeSelection)selection).size() == 1) {
            Object tElement = tSelection.getFirstElement();
            IResourceModelElement rElement = null;
            if (tElement instanceof IResourceModelElement) {
                if (tElement instanceof IBeansConfig || tElement instanceof IBeansConfigSet || tElement instanceof IBeansComponent || tElement instanceof IBean) {
                    rElement = (IResourceModelElement)tElement;
                }
            } else if (tElement instanceof IFile) {
                rElement = BeansCorePlugin.getModel().getConfig((IFile)tElement);
            } else if (tElement instanceof ZipEntryStorage) {
                rElement = BeansModelUtils.getConfig((ZipEntryStorage)((ZipEntryStorage)tElement));
            }
            if (rElement != null) {
                this.element = rElement;
                this.context = BeansUIUtils.getContext((ITreeSelection)tSelection);
                return true;
            }
        }
        return false;
    }

    public void run() {
        if (this.element.getElementResource() instanceof IFile && BeansUIUtils.isBeansConfigContentType((IFile)((IFile)this.element.getElementResource()))) {
            SpringConfigEditor cEditor;
            SpringConfigGraphPage graph;
            IFile file = (IFile)this.element.getElementResource();
            FileEditorInput input = new FileEditorInput(file);
            IEditorPart part = SpringUIUtils.openInEditor((IEditorInput)input, (String)"com.springsource.sts.config.ui.editors.SpringConfigEditor");
            if (part instanceof SpringConfigEditor && (graph = (cEditor = (SpringConfigEditor)part).getBeansGraphPage()) != null) {
                cEditor.setActiveEditor((IEditorPart)graph);
            }
        } else {
            GraphEditorInput input = this.element instanceof IBeansConfig || this.element instanceof IBeansConfigSet ? new GraphEditorInput(this.element.getElementID()) : new GraphEditorInput(this.element.getElementID(), this.context.getElementID());
            SpringUIUtils.openInEditor((IEditorInput)input, (String)"org.springframework.ide.eclipse.beans.ui.graph.editor");
        }
    }
}

