/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.extensions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.config.core.extensions.CommonActionsExtensionPointConstants;
import org.springframework.ide.eclipse.config.core.extensions.FormPagesExtensionPointConstants;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;

public class ConfigUiExtensionPointReader {
    private static Set<IConfigurationElement> pageDefinitions = new HashSet<IConfigurationElement>();
    private static Set<IConfigurationElement> wizardDefinitions = new HashSet<IConfigurationElement>();
    private static Set<IConfigurationElement> adapterDefinitions = new HashSet<IConfigurationElement>();
    private static boolean read;

    public static Set<IConfigurationElement> getAdapterDefinitions() {
        if (!read) {
            ConfigUiExtensionPointReader.readExtensionPoints();
        }
        return adapterDefinitions;
    }

    public static Set<IConfigurationElement> getPageDefinitions() {
        if (!read) {
            ConfigUiExtensionPointReader.readExtensionPoints();
        }
        return pageDefinitions;
    }

    public static Set<IConfigurationElement> getWizardDefinitions() {
        if (!read) {
            ConfigUiExtensionPointReader.readExtensionPoints();
        }
        return wizardDefinitions;
    }

    private static void readAdapterDefinitions() {
        IExtensionPoint adaptersExtPoint = Platform.getExtensionRegistry().getExtensionPoint(PageAdaptersExtensionPointConstants.POINT_ID);
        if (adaptersExtPoint != null) {
            IExtension[] iExtensionArray = adaptersExtPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String id = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_ID);
                    String uri = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI);
                    String parent = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_PARENT_URI);
                    if (id != null && id.trim().length() > 0 && uri != null && uri.trim().length() > 0 && parent != null && parent.trim().length() > 0) {
                        adapterDefinitions.add(config);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static void readExtensionPoints() {
        ConfigUiExtensionPointReader.readPageDefinitions();
        ConfigUiExtensionPointReader.readAdapterDefinitions();
        ConfigUiExtensionPointReader.readWizardDefinitions();
        read = true;
    }

    private static void readPageDefinitions() {
        IExtensionPoint pagesExtPoint = Platform.getExtensionRegistry().getExtensionPoint(FormPagesExtensionPointConstants.POINT_ID);
        if (pagesExtPoint != null) {
            IExtension[] iExtensionArray = pagesExtPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String id = config.getAttribute(FormPagesExtensionPointConstants.ATTR_ID);
                    String name = config.getAttribute(FormPagesExtensionPointConstants.ATTR_NAME);
                    String clazz = config.getAttribute(FormPagesExtensionPointConstants.ATTR_CLASS);
                    String prefix = config.getAttribute(FormPagesExtensionPointConstants.ATTR_NAMESPACE_PREFIX);
                    String uri = config.getAttribute(FormPagesExtensionPointConstants.ATTR_NAMESPACE_URI);
                    if (id != null && id.trim().length() > 0 && name != null && name.trim().length() > 0 && clazz != null && clazz.trim().length() > 0 && prefix != null && prefix.trim().length() > 0 && uri != null && uri.trim().length() > 0) {
                        pageDefinitions.add(config);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static void readWizardDefinitions() {
        IExtensionPoint templatesExtPoint = Platform.getExtensionRegistry().getExtensionPoint(CommonActionsExtensionPointConstants.POINT_ID);
        if (templatesExtPoint != null) {
            IExtension[] iExtensionArray = templatesExtPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String id = config.getAttribute(CommonActionsExtensionPointConstants.ATTR_ID);
                    String clazz = config.getAttribute(CommonActionsExtensionPointConstants.ATTR_CLASS);
                    String desc = config.getAttribute(CommonActionsExtensionPointConstants.ATTR_DESCRIPTION);
                    String uri = config.getAttribute(CommonActionsExtensionPointConstants.ATTR_NAMESPACE_URI);
                    if (id != null && id.trim().length() > 0 && clazz != null && clazz.trim().length() > 0 && desc != null && desc.trim().length() > 0 && uri != null && uri.trim().length() > 0) {
                        wizardDefinitions.add(config);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

