/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.externaltype.indexing;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalType;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeDiscovery;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeEntry;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeSource;
import org.springsource.ide.eclipse.commons.completions.externaltype.indexing.ExternalTypeIndexer;
import org.springsource.ide.eclipse.commons.completions.util.Requestor;

public class SimpleExternalTypeIndexer
extends ExternalTypeIndexer {
    private TreeMap<ExternalType, ExternalTypeSource> allKnownTypes = new TreeMap();

    private synchronized void add(ExternalType et, ExternalTypeSource source) {
        this.allKnownTypes.put(et, source);
    }

    @Override
    public synchronized void getAll(Requestor<ExternalType> requestor) {
        requestor.receive(this.allKnownTypes.keySet());
    }

    @Override
    public synchronized void getByPrefix(String prefix, Requestor<ExternalType> requestor) {
        ExternalType prefixKey = new ExternalType(prefix, "");
        NavigableMap<ExternalType, ExternalTypeSource> tailMap = this.allKnownTypes.tailMap(prefixKey, true);
        for (ExternalType type : tailMap.keySet()) {
            if (type.getName().startsWith(prefix)) {
                boolean wantsMore = requestor.receive(type);
                if (wantsMore) continue;
                return;
            }
            return;
        }
    }

    @Override
    public void addFrom(ExternalTypeDiscovery source) {
        source.getTypes(new Requestor<ExternalTypeEntry>(){

            @Override
            public boolean receive(ExternalTypeEntry element) {
                SimpleExternalTypeIndexer.this.add(element.getType(), element.getSource());
                return true;
            }
        });
    }

    @Override
    public synchronized ExternalTypeSource getSource(ExternalType type) {
        ExternalTypeSource source = this.allKnownTypes.get(type);
        if (source != null) {
            return source;
        }
        return ExternalTypeSource.UNKNOWN;
    }
}

