/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Messages;
import org.tigris.subversion.subclipse.ui.conflicts.EditPropertyConflictsWizardPropertyPage;
import org.tigris.subversion.subclipse.ui.conflicts.EditPropertyConflictsWizardSummaryPage;
import org.tigris.subversion.subclipse.ui.conflicts.PropertyConflict;
import org.tigris.subversion.subclipse.ui.operations.ResolveOperation;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class EditPropertyConflictsWizard
extends Wizard {
    private ISVNLocalResource svnResource;
    private String conflictSummary;
    private PropertyConflict[] propertyConflicts;
    private ISVNProperty[] remoteProperties;
    private EditPropertyConflictsWizardSummaryPage summaryPage;
    private IWorkbenchPart targetPart;

    public EditPropertyConflictsWizard(ISVNLocalResource svnResource, String conflictSummary, PropertyConflict[] propertyConflicts, ISVNProperty[] remoteProperties, IWorkbenchPart targetPart) {
        this.svnResource = svnResource;
        this.conflictSummary = conflictSummary;
        this.propertyConflicts = propertyConflicts;
        this.remoteProperties = remoteProperties;
        this.targetPart = targetPart;
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(Messages.EditPropertyConflictsWizard_0);
        this.summaryPage = new EditPropertyConflictsWizardSummaryPage();
        this.addPage((IWizardPage)this.summaryPage);
        int i = 0;
        while (i < this.propertyConflicts.length) {
            EditPropertyConflictsWizardPropertyPage propertyPage = new EditPropertyConflictsWizardPropertyPage(this.propertyConflicts[i]);
            this.addPage((IWizardPage)propertyPage);
            ++i;
        }
    }

    public boolean performFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] instanceof EditPropertyConflictsWizardPropertyPage) {
                EditPropertyConflictsWizardPropertyPage propertyPage = (EditPropertyConflictsWizardPropertyPage)pages[i];
                try {
                    boolean deleteProperty = false;
                    if (propertyPage.incomingSelected() && propertyPage.getRemoteProperty() == null && propertyPage.getPropertyValue().trim().length() == 0) {
                        deleteProperty = true;
                    }
                    if (deleteProperty) {
                        this.svnResource.deleteSvnProperty(propertyPage.getPropertyName(), false);
                    } else {
                        this.svnResource.setSvnProperty(propertyPage.getPropertyName(), propertyPage.getPropertyValue(), false);
                    }
                }
                catch (SVNException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)e.getMessage());
                    return false;
                }
            }
            ++i;
        }
        if (this.summaryPage.markResolvedButton.getSelection()) {
            IResource resource = this.svnResource.getResource();
            IResource[] selectedResources = new IResource[]{resource};
            try {
                new ResolveOperation(this.targetPart, selectedResources, 6).run();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public ISVNLocalResource getSvnResource() {
        return this.svnResource;
    }

    public String getConflictSummary() {
        return this.conflictSummary;
    }

    public PropertyConflict[] getPropertyConflicts() {
        return this.propertyConflicts;
    }

    public ISVNProperty[] getRemoteProperties() {
        return this.remoteProperties;
    }
}

