/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.DOMObserver;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;
import org.eclipse.wst.xml.ui.internal.registry.AdapterFactoryProviderForXML;
import org.springframework.ide.eclipse.beans.ui.editor.BeansModelHandler;
import org.springframework.ide.eclipse.beans.ui.editor.outline.BeansJFaceNodeAdapterFactory;
import org.springframework.util.Assert;

public class BeansAdapterFactoryProvider
extends AdapterFactoryProviderForXML {
    protected void addContentBasedFactories(IStructuredModel structuredModel) {
        CMDocumentManager documentManager;
        ModelQuery modelQuery;
        FactoryRegistry factoryRegistry = structuredModel.getFactoryRegistry();
        Assert.notNull((Object)factoryRegistry, (String)"No factory registered");
        Object factory = factoryRegistry.getFactoryFor(IJFaceNodeAdapter.class);
        if (factory == null) {
            factory = new BeansJFaceNodeAdapterFactory();
            factoryRegistry.addFactory(factory);
        }
        if (structuredModel != null && (modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)structuredModel)) != null && (documentManager = modelQuery.getCMDocumentManager()) != null) {
            IPreferenceStore store = XMLUIPlugin.getDefault().getPreferenceStore();
            boolean useInferredGrammar = store != null ? store.getBoolean(XMLUIPreferenceNames.USE_INFERRED_GRAMMAR) : true;
            documentManager.setPropertyEnabled("asyncLoad", true);
            documentManager.setPropertyEnabled("autoLoad", false);
            documentManager.setPropertyEnabled("useCachedResovledURI", true);
            DOMObserver domObserver = new DOMObserver(structuredModel);
            domObserver.setGrammarInferenceEnabled(useInferredGrammar);
            domObserver.init();
        }
    }

    public boolean isFor(IDocumentTypeHandler contentTypeDescription) {
        return contentTypeDescription instanceof BeansModelHandler;
    }
}

