/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.IConversionConstants;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.LegacyWorkspaceConverter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion.LegacyProjectListener;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion.LegacyProjectsJob;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion.PerspectiveMigrator;

public class LegacySTSChecker
implements IStartup,
IConversionConstants {
    public static boolean NON_BLOCKING = false;
    private static final IPreferenceStore PREFERENCE_STORE = FrameworkCoreActivator.getDefault().getPreferenceStore();

    public void earlyStartup() {
        PREFERENCE_STORE.setDefault("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.autocheck", true);
        if (this.shouldPerformProjectCheck()) {
            LegacyProjectsJob job = new LegacyProjectsJob(false);
            job.schedule();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)LegacyProjectListener.LISTENER, 1);
        }
        if (this.shouldPerformWorkspaceMigration()) {
            new UIJob("Convert legacy STS 2.x preferences"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus status = new LegacyWorkspaceConverter().convert(monitor);
                    IStatus status2 = new PerspectiveMigrator().migratePerspective("com.springsource.sts.grails.perspective", "org.grails.ide.eclipse.perspective", monitor);
                    MultiStatus statuses = new MultiStatus("org.springsource.ide.eclipse.commons.frameworks.ui", 0, new IStatus[]{status, status2}, "Legacy workspace migration", null);
                    return statuses;
                }
            }.schedule();
        }
    }

    private boolean shouldPerformProjectCheck() {
        return FrameworkCoreActivator.getDefault().getPreferenceStore().getBoolean("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.autocheck");
    }

    private boolean shouldPerformWorkspaceMigration() {
        return !PREFERENCE_STORE.getBoolean("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.done");
    }
}

