/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.web.bind.annotation.InitBinder;

public class AddInitBinderCompletionProposal
extends AnnotationCompletionProposal {
    private final MethodDeclaration methodDecl;

    public AddInitBinderCompletionProposal(MethodDeclaration methodDecl, ICompilationUnit cu) {
        super("Add @InitBinder", cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.methodDecl = methodDecl;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.methodDecl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        String importName = InitBinder.class.getCanonicalName();
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), importName)) {
            this.createImportRewrite(astRoot).addImport(importName);
        }
        AST ast = astRewrite.getAST();
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        SimpleName name = ast.newSimpleName("InitBinder");
        annotation.setTypeName((Name)name);
        astRewrite.getListRewrite((ASTNode)this.methodDecl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, null);
        return astRewrite;
    }
}

