/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.structure;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.IndentUtil;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlDocument;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlNavigable;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPath;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPathSegment;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.utils.CollectionUtil;

public class YamlStructureParser {
    public static final Pattern SIMPLE_KEY_LINE = Pattern.compile("^(\\w(\\w|-)*):.*");
    public static final Pattern SEQ_LINE = Pattern.compile("^(\\-( |$)).*");
    public static final Pattern DOCUMENT_SEPERATOR = Pattern.compile("^(---|\\.\\.\\.)(\\s)*(\\#.*)?");
    private YamlLineReader input;

    public YamlStructureParser(YamlDocument doc) {
        this.input = new YamlLineReader(doc);
    }

    private static void indent(Writer out, int indent) throws Exception {
        int i = 0;
        while (i < indent) {
            out.write("  ");
            ++i;
        }
    }

    public SRootNode parse() throws Exception {
        YamlLine line;
        SDocNode doc;
        SRootNode root = new SRootNode(this.input.getDocument());
        SChildBearingNode parent = doc = new SDocNode(root, 0, 0);
        while ((line = this.input.read()) != null) {
            int indent = line.getIndent();
            if (indent == -1) {
                this.createRawNode(parent, line);
                continue;
            }
            parent = this.dropTo(parent, indent);
            parent = this.parseLine(parent, line, true);
        }
        return root;
    }

    protected SChildBearingNode parseLine(SChildBearingNode parent, YamlLine line, boolean createRawNode) throws Exception {
        if (line.matches(DOCUMENT_SEPERATOR)) {
            parent = this.createDocNode(parent.getRoot(), line);
        } else if (line.matches(SIMPLE_KEY_LINE)) {
            int currentIndent = line.getIndent();
            while (currentIndent == parent.getIndent() && parent.getNodeType() != SNodeType.DOC) {
                parent = parent.getParent();
            }
            parent = this.createKeyNode(parent, line);
        } else if (line.matches(SEQ_LINE)) {
            int currentIndent = line.getIndent();
            while (currentIndent == parent.getIndent() && parent.getNodeType() == SNodeType.SEQ) {
                parent = parent.getParent();
            }
            parent = this.createSeqNode(parent, line);
            parent = this.parseLine(parent, line.moveIndentMark(2), false);
        } else if (createRawNode) {
            this.createRawNode(parent, line);
        }
        return parent;
    }

    private SChildBearingNode createDocNode(SRootNode parent, YamlLine line) {
        int start = line.getStart();
        int end = line.getEnd();
        return new SDocNode(parent, start, end);
    }

    private SChildBearingNode createSeqNode(SChildBearingNode parent, YamlLine line) throws Exception {
        int indent = line.getIndent();
        int start = line.getStart() + line.getIndent();
        int end = line.getEnd();
        return new SSeqNode(parent, line.getDocument(), indent, start, end);
    }

    private SChildBearingNode createKeyNode(SChildBearingNode parent, YamlLine line) throws Exception {
        int indent = line.getIndent();
        int start = line.getStart() + line.getIndent();
        int end = line.getEnd();
        return new SKeyNode(parent, line.getDocument(), indent, start, end);
    }

    private SRawNode createRawNode(SChildBearingNode parent, YamlLine line) {
        int indent = line.getIndent();
        int start = IndentUtil.addToOffset(line.getStart(), indent);
        int end = line.getEnd();
        return new SRawNode(parent, line.getDocument(), indent, start, end);
    }

    private SChildBearingNode dropTo(SChildBearingNode node, int indent) {
        while (indent < node.getIndent()) {
            node = node.getParent();
        }
        return node;
    }

    public static abstract class SChildBearingNode
    extends SNode {
        private List<SNode> children = null;
        private Map<String, SKeyNode> keyMap = null;

        public SChildBearingNode(SChildBearingNode parent, YamlDocument doc, int indent, int start, int end) {
            super(parent, doc, indent, start, end);
        }

        public List<SNode> getChildren() {
            if (this.children != null) {
                return Collections.unmodifiableList(this.children);
            }
            return Collections.emptyList();
        }

        public void addChild(SNode c) {
            if (this.children == null) {
                this.children = new ArrayList<SNode>();
            }
            this.children.add(c);
        }

        public SNode getLastChild() {
            List<SNode> cs = this.getChildren();
            if (!cs.isEmpty()) {
                return cs.get(cs.size() - 1);
            }
            return null;
        }

        @Override
        public int getTreeEnd() {
            if (this.getChildren().isEmpty()) {
                return this.getNodeEnd();
            }
            return this.getLastChild().getTreeEnd();
        }

        @Override
        protected final void dump(Writer out, int indent) throws Exception {
            YamlStructureParser.indent(out, indent);
            out.write(this.getNodeType().toString());
            out.write(40);
            int nodeIndent = this.getIndent();
            out.write("" + nodeIndent);
            out.write("): ");
            out.write(this.getText());
            out.write(10);
            for (SNode child : this.getChildren()) {
                child.dump(out, indent + 1);
            }
        }

        @Override
        public SNode find(int offset) {
            if (!this.treeContains(offset)) {
                return null;
            }
            for (SNode c : this.getChildren()) {
                SNode fromChild = c.find(offset);
                if (fromChild == null) continue;
                return fromChild;
            }
            return this;
        }

        @Override
        public SNode traverse(YamlPathSegment s) throws Exception {
            switch (s.getType()) {
                case VAL_AT_KEY: {
                    return this.getChildWithKey(s.toPropString());
                }
                case VAL_AT_INDEX: {
                    return this.getSeqChildWithIndex(s.toIndex());
                }
            }
            return null;
        }

        private SSeqNode getSeqChildWithIndex(int index) {
            SNode child;
            List<SNode> children;
            if (index >= 0 && index < (children = this.getChildren()).size() && (child = children.get(index)) instanceof SSeqNode) {
                return (SSeqNode)child;
            }
            return null;
        }

        public SKeyNode getChildWithKey(String key) throws Exception {
            if (CollectionUtil.hasElements(this.children)) {
                return this.keyMap().get(key);
            }
            return null;
        }

        private Map<String, SKeyNode> keyMap() throws Exception {
            if (this.keyMap == null) {
                HashMap<String, SKeyNode> index = new HashMap<String, SKeyNode>();
                for (SNode node : this.getChildren()) {
                    if (node.getNodeType() != SNodeType.KEY) continue;
                    SKeyNode keyNode = (SKeyNode)node;
                    String key = ((SKeyNode)node).getKey();
                    SKeyNode existing = index.get(key);
                    if (existing != null) continue;
                    index.put(key, keyNode);
                }
                this.keyMap = index;
            }
            return this.keyMap;
        }

        public SNode getFirstRealChild() {
            for (SNode c : this.getChildren()) {
                if (c.getIndent() < 0) continue;
                return c;
            }
            return null;
        }
    }

    public static class SDocNode
    extends SChildBearingNode {
        private int index;

        public SDocNode(SRootNode parent, int start, int end) {
            super(parent, parent.doc, 0, start, end);
            this.index = parent.getChildren().size() - 1;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public SNodeType getNodeType() {
            return SNodeType.DOC;
        }

        public boolean exists(YamlPath path) throws Exception {
            return path.traverse(this) != null;
        }
    }

    public class SKeyNode
    extends SChildBearingNode {
        private int colonOffset;

        public SKeyNode(SChildBearingNode parent, YamlDocument doc, int indent, int start, int end) throws Exception {
            super(parent, doc, indent, start, end);
            int relativeColonOffset = doc.textBetween(start, end).indexOf(58);
            Assert.isLegal((relativeColonOffset >= 0 ? 1 : 0) != 0);
            this.colonOffset = relativeColonOffset + start;
        }

        @Override
        public SNodeType getNodeType() {
            return SNodeType.KEY;
        }

        public String getKey() throws Exception {
            return this.doc.textBetween(this.getStart(), this.getColonOffset());
        }

        public int getColonOffset() {
            return this.colonOffset;
        }

        public boolean isInKey(int offset) throws Exception {
            return this.getStart() <= offset && offset <= this.getColonOffset();
        }

        public boolean isInValue(int offset) {
            return offset > this.getColonOffset() && offset <= this.getTreeEnd();
        }
    }

    public abstract class SLeafNode
    extends SNode {
        public SLeafNode(SChildBearingNode parent, YamlDocument doc, int indent, int start, int end) {
            super(parent, doc, indent, start, end);
        }

        @Override
        public int getTreeEnd() {
            return this.getNodeEnd();
        }

        @Override
        protected final void dump(Writer out, int indent) throws Exception {
            YamlStructureParser.indent(out, indent);
            out.write(this.getNodeType().toString());
            out.write(40);
            int nodeIndent = this.getIndent();
            out.write("" + nodeIndent);
            out.write("): ");
            out.write(this.getText());
            out.write(10);
        }

        @Override
        public SNode find(int offset) {
            if (this.treeContains(offset)) {
                return this;
            }
            return null;
        }
    }

    public static abstract class SNode
    implements YamlNavigable<SNode> {
        private SChildBearingNode parent;
        private int indent;
        private int start;
        private int end;
        protected final YamlDocument doc;

        public SNode(SChildBearingNode parent, YamlDocument doc, int indent, int start, int end) {
            Assert.isLegal((this instanceof SRootNode || parent != null ? 1 : 0) != 0);
            this.parent = parent;
            this.doc = doc;
            this.indent = indent;
            this.start = start;
            this.end = end;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        public SChildBearingNode getParent() {
            return this.parent;
        }

        public int getStart() {
            return this.start;
        }

        public int getNodeEnd() {
            return this.end;
        }

        public abstract int getTreeEnd();

        public final int getIndent() {
            return this.indent;
        }

        public final String toString() {
            StringWriter out = new StringWriter();
            try {
                this.dump(out, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return out.toString();
        }

        public abstract SNodeType getNodeType();

        public abstract SNode find(int var1);

        public boolean nodeContains(int offset) {
            return this.getStart() + Math.max(0, this.getIndent()) <= offset && offset <= this.getNodeEnd();
        }

        public boolean treeContains(int offset) {
            return this.getStart() <= offset && offset <= this.getTreeEnd();
        }

        public String getText() throws Exception {
            return this.doc.textBetween(this.start, this.end);
        }

        @Override
        public SNode traverse(YamlPathSegment s) throws Exception {
            return null;
        }

        protected abstract void dump(Writer var1, int var2) throws Exception;

        public YamlPath getPath() throws Exception {
            ArrayList<YamlPathSegment> segments = new ArrayList<YamlPathSegment>();
            SNode.buildPath(this, segments);
            return new YamlPath(segments);
        }

        private static void buildPath(SNode node, ArrayList<YamlPathSegment> segments) throws Exception {
            if (node != null) {
                SNode.buildPath(node.getParent(), segments);
                SNodeType nodeType = node.getNodeType();
                if (nodeType == SNodeType.KEY) {
                    String key = ((SKeyNode)node).getKey();
                    segments.add(YamlPathSegment.valueAt(key));
                } else if (nodeType == SNodeType.SEQ) {
                    int index = ((SSeqNode)node).getIndex();
                    segments.add(YamlPathSegment.valueAt(index));
                } else if (nodeType == SNodeType.DOC) {
                    int index = ((SDocNode)node).getIndex();
                    segments.add(YamlPathSegment.valueAt(index));
                }
            }
        }

        public SRootNode getRoot() {
            if (this.parent == null) {
                return (SRootNode)this;
            }
            return this.parent.getRoot();
        }
    }

    public static enum SNodeType {
        ROOT,
        DOC,
        KEY,
        SEQ,
        RAW;

    }

    public class SRawNode
    extends SLeafNode {
        public SRawNode(SChildBearingNode parent, YamlDocument doc, int indent, int start, int end) {
            super(parent, doc, indent, start, end);
        }

        @Override
        public SNodeType getNodeType() {
            return SNodeType.RAW;
        }
    }

    public static class SRootNode
    extends SChildBearingNode {
        public SRootNode(YamlDocument doc) {
            super(null, doc, 0, 0, 0);
        }

        @Override
        public SNodeType getNodeType() {
            return SNodeType.ROOT;
        }

        @Override
        public void addChild(SNode c) {
            Assert.isLegal((c.getNodeType() == SNodeType.DOC ? 1 : 0) != 0, (String)("" + (Object)((Object)c.getNodeType())));
            super.addChild(c);
        }

        @Override
        public SNode traverse(YamlPathSegment s) throws Exception {
            Integer index = s.toIndex();
            if (index != null) {
                List<SNode> cs = this.getChildren();
                if (index >= 0 && index < cs.size()) {
                    return cs.get(index);
                }
            }
            return null;
        }
    }

    public class SSeqNode
    extends SChildBearingNode {
        private int index;

        public SSeqNode(SChildBearingNode parent, YamlDocument doc, int indent, int start, int end) throws Exception {
            super(parent, doc, indent, start, end);
            this.index = parent.getChildren().size() - 1;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public SNodeType getNodeType() {
            return SNodeType.SEQ;
        }

        public boolean isInValue(int offset) {
            return offset >= this.getStart() + 2 && offset <= this.getTreeEnd();
        }
    }

    public static class YamlLine {
        private YamlDocument doc;
        private int start;
        private int indent;
        private int end;

        public static YamlLine atLineNumber(YamlDocument doc, int line) throws Exception {
            if (line < doc.getDocument().getNumberOfLines()) {
                IRegion l = doc.getLineInformation(line);
                int start = l.getOffset();
                int end = start + l.getLength();
                return new YamlLine(doc, start, doc.getLineIndentation(line), end);
            }
            return null;
        }

        private YamlLine(YamlDocument doc, int start, int indent, int end) {
            this.doc = doc;
            this.start = start;
            this.indent = indent;
            this.end = end;
        }

        public int getIndent() {
            return this.indent;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public boolean matches(Pattern pat) throws Exception {
            return pat.matcher(this.getTextWithoutIndent()).matches();
        }

        public String getTextWithoutIndent() throws Exception {
            return this.doc.textBetween(this.getStart() + this.getIndent(), this.getEnd());
        }

        public String getText() throws Exception {
            return this.doc.textBetween(this.getStart(), this.getEnd());
        }

        public String toString() {
            try {
                return "YamlLine(" + this.getLineNumber() + ": " + this.getText() + ")";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private int getLineNumber() throws Exception {
            return this.doc.getLineOfOffset(this.start);
        }

        public YamlLine moveIndentMark(int moveBy) throws Exception {
            return new YamlLine(this.doc, this.start, Math.min(this.indent + moveBy, this.getLineLength()), this.end);
        }

        private int getLineLength() throws Exception {
            return this.getEnd() - this.getStart();
        }

        public YamlDocument getDocument() {
            return this.doc;
        }
    }

    public class YamlLineReader {
        private final YamlDocument doc;
        private int nextLine = 0;

        public YamlLineReader(YamlDocument doc) {
            this.doc = doc;
        }

        public YamlLine read() throws Exception {
            if (this.nextLine < this.doc.getDocument().getNumberOfLines()) {
                return YamlLine.atLineNumber(this.doc, this.nextLine++);
            }
            return null;
        }

        public YamlDocument getDocument() {
            return this.doc;
        }
    }
}

