/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.importing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.CodeSet;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportConfiguration;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportStrategy;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.gradle.core.GradleProject;
import org.springsource.ide.eclipse.gradle.core.samples.SampleProject;
import org.springsource.ide.eclipse.gradle.core.util.ErrorHandler;
import org.springsource.ide.eclipse.gradle.core.util.NatureUtils;
import org.springsource.ide.eclipse.gradle.core.wizards.GradleImportOperation;

public class GradleStrategy
extends ImportStrategy {
    public GradleStrategy() throws ClassNotFoundException {
        Class.forName("org.springsource.ide.eclipse.gradle.core.wizards.NewGradleProjectOperation");
    }

    private static SampleProject asSample(final String projectName, final CodeSet codeset) {
        return new SampleProject(){

            public String getName() {
                return projectName;
            }

            public void createAt(File location) throws CoreException {
                if (location.exists()) {
                    FileUtils.deleteQuietly((File)location);
                }
                try {
                    codeset.createAt(location);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.coreException((Throwable)e);
                }
            }
        };
    }

    @Override
    public IRunnableWithProgress createOperation(ImportConfiguration conf) {
        return new GradleCodeSetImport2(conf);
    }

    private static class GradleCodeSetImport2
    implements IRunnableWithProgress {
        private final String location;
        private final String projectName;
        private final CodeSet codeset;

        public GradleCodeSetImport2(ImportConfiguration conf) {
            this.location = conf.getLocation();
            this.projectName = conf.getProjectName();
            this.codeset = conf.getCodeSet();
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Import " + this.projectName, 3);
            try {
                try {
                    SampleProject sample = GradleStrategy.asSample(this.projectName, this.codeset);
                    File rootFolder = new File(this.location);
                    sample.createAt(rootFolder);
                    monitor.worked(1);
                    GradleImportOperation importOp = GradleImportOperation.importAll((File)rootFolder);
                    importOp.setEnableDependencyManagement(false);
                    ErrorHandler eh = ErrorHandler.forImportWizard();
                    importOp.perform(eh, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.addPringNature(importOp.getProjects(), eh, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    eh.rethrowAsCore();
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }

        private void addPringNature(GradleProject[] projects, ErrorHandler eh, IProgressMonitor mon) {
            mon.beginTask("Add spring natures", projects.length);
            try {
                GradleProject[] gradleProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    GradleProject gp = gradleProjectArray[n2];
                    IProject p = gp.getProject();
                    if (p != null) {
                        try {
                            NatureUtils.ensure((IProject)p, (IProgressMonitor)new SubProgressMonitor(mon, 1), (String[])new String[]{"org.springframework.ide.eclipse.core.springnature"});
                        }
                        catch (CoreException e) {
                            eh.handleError((Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                mon.done();
            }
        }
    }
}

