/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.wizard.Messages;
import org.springframework.ide.eclipse.wizard.ui.BeanWizardDialog;

public class CreateNewBeanDefAction
extends Action
implements IObjectActionDelegate {
    private IFile selectedFile;

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            if (!BeansCoreUtils.isBeansConfig((IResource)this.selectedFile)) {
                IBeansProject springProject = BeansCorePlugin.getModel().getProject(this.selectedFile.getProject());
                if (springProject != null && springProject instanceof BeansProject) {
                    boolean convert = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString("CreateNewBeanDefAction.QUESTION_DIALOG_TITLE"), (String)Messages.getString("CreateNewBeanDefAction.QUESTION_DIALOG_MESSAGE"));
                    if (convert) {
                        ((BeansProject)springProject).addConfig(this.selectedFile, IBeansConfig.Type.MANUAL);
                    }
                } else {
                    MessageDialog.openError((Shell)shell, (String)Messages.getString("CreateNewBeanDefAction.ERROR_DIALOG_TITLE"), (String)Messages.getString("CreateNewBeanDefAction.ERROR_DIALOG_MESSAGE"));
                }
            }
            if (BeansCoreUtils.isBeansConfig((IResource)this.selectedFile)) {
                BeanWizardDialog dialog = BeanWizardDialog.createBeanWizardDialog(shell, this.selectedFile, true);
                dialog.create();
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection treeSelection;
        Object[] objects;
        if (selection instanceof TreeSelection && (objects = (treeSelection = (TreeSelection)selection).toArray()) != null && objects.length == 1 && objects[0] instanceof IFile) {
            this.selectedFile = (IFile)objects[0];
            return;
        }
        this.selectedFile = null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

