/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.locate;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModel;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.locate.IBeansConfigLocator;
import org.springframework.ide.eclipse.core.PersistablePreferenceObjectSupport;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeansConfigLocatorDefinition
extends PersistablePreferenceObjectSupport {
    private static final Long DEFAULT_ORDER = 10L;
    private static final String LOCATOR_PREFIX = "locator.enable.";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabledByDefault";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ORDER_ATTRIBUTE = "order";
    private String description;
    private String id;
    private String name;
    private String namespaceUri;
    private Long order;
    private IBeansConfigLocator beansConfigLocator;

    public BeansConfigLocatorDefinition(IConfigurationElement element) throws CoreException {
        this.init(element);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    protected String getPreferenceId() {
        return LOCATOR_PREFIX + this.namespaceUri + "." + this.id;
    }

    public IBeansConfigLocator getBeansConfigLocator() {
        return this.beansConfigLocator;
    }

    public Long getOrder() {
        return this.order;
    }

    private void init(IConfigurationElement element) throws CoreException {
        Object builder = element.createExecutableExtension(CLASS_ATTRIBUTE);
        if (builder instanceof IBeansConfigLocator) {
            this.beansConfigLocator = (IBeansConfigLocator)builder;
        }
        this.namespaceUri = element.getDeclaringExtension().getNamespaceIdentifier();
        this.id = element.getAttribute(ID_ATTRIBUTE);
        this.name = element.getAttribute(NAME_ATTRIBUTE);
        this.description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
        String orderString = element.getAttribute(ORDER_ATTRIBUTE);
        this.order = StringUtils.hasText((String)orderString) ? Long.valueOf(orderString) : DEFAULT_ORDER;
        String enabledByDefault = element.getAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE);
        if (enabledByDefault != null) {
            this.setEnabledByDefault(Boolean.valueOf(enabledByDefault));
        } else {
            this.setEnabledByDefault(true);
        }
    }

    protected void onEnablementChanged(boolean isEnabled, IProject project) {
        BeansProject beansProject = (BeansProject)BeansCorePlugin.getModel().getProject(project);
        if (beansProject != null) {
            if (!isEnabled) {
                beansProject.removeAutoDetectedConfigs(String.valueOf(this.getNamespaceUri()) + "." + this.getId());
            } else {
                beansProject.reset();
            }
            ((BeansModel)beansProject.getElementParent()).notifyListeners(beansProject, ModelChangeEvent.Type.CHANGED);
        }
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.beansConfigLocator.getClass().getName() + ")";
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return project != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansConfigLocatorDefinition)) {
            return false;
        }
        BeansConfigLocatorDefinition that = (BeansConfigLocatorDefinition)((Object)other);
        if (!ObjectUtils.nullSafeEquals((Object)this.id, (Object)that.id)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.namespaceUri, (Object)that.namespaceUri);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.namespaceUri);
        return 12 * (hashCode += ObjectUtils.nullSafeHashCode((Object)this.id));
    }
}

