/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.locate;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.locate.AbstractPathMatchingBeansConfigLocator;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public abstract class AbstractJavaProjectPathMatchingBeansConfigLocator
extends AbstractPathMatchingBeansConfigLocator {
    @Override
    public boolean supports(IProject project) {
        return JdtUtils.isJavaProject((IResource)project);
    }

    @Override
    protected boolean canLocateInProject(IProject project) {
        return this.supports(project);
    }

    @Override
    protected Set<IPath> getRootDirectories(IProject project) {
        LinkedHashSet<IPath> rootDirectories = new LinkedHashSet<IPath>();
        IJavaProject javaProject = JdtUtils.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        rootDirectories.add(entry.getPath());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
        return rootDirectories;
    }
}

