/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;

public class Annotations
implements ISVNAnnotations {
    private List annotations = new ArrayList();

    protected Annotation getAnnotation(int i) {
        if (i >= this.annotations.size()) {
            return null;
        }
        return (Annotation)this.annotations.get(i);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public long getRevision(int lineNumber) {
        Annotation annotation = this.getAnnotation(lineNumber);
        if (annotation == null) {
            return -1L;
        }
        return annotation.getRevision();
    }

    public String getAuthor(int lineNumber) {
        Annotation annotation = this.getAnnotation(lineNumber);
        if (annotation == null) {
            return null;
        }
        return annotation.getAuthor();
    }

    public Date getChanged(int lineNumber) {
        Annotation annotation = this.getAnnotation(lineNumber);
        if (annotation == null) {
            return null;
        }
        return annotation.getChanged();
    }

    public String getLine(int lineNumber) {
        Annotation annotation = this.getAnnotation(lineNumber);
        if (annotation == null) {
            return null;
        }
        return annotation.getLine();
    }

    public InputStream getInputStream() {
        return new AnnotateInputStream(this);
    }

    public int numberOfLines() {
        return this.annotations.size();
    }

    public static class Annotation {
        private long revision;
        private String author;
        private Date changed;
        private String line;

        public Annotation(long revision, String author, Date changed, String line) {
            if (revision == -1L) {
                this.revision = 0L;
                this.author = "No change";
                this.changed = new Date();
            } else {
                this.revision = revision;
                this.author = author;
                this.changed = changed;
            }
            this.line = line;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getChanged() {
            return this.changed;
        }

        public String getLine() {
            return this.line;
        }

        public void setLine(String line) {
            this.line = line;
        }

        public long getRevision() {
            return this.revision;
        }

        public String toString() {
            return String.valueOf(this.getRevision()) + ":" + this.getAuthor() + ":" + this.getLine();
        }
    }

    protected static class AnnotateInputStream
    extends InputStream {
        private ISVNAnnotations annotations;
        private int currentLineNumber;
        private int currentPos;
        private String currentLine;
        private int available;

        public AnnotateInputStream(ISVNAnnotations annotations) {
            this.annotations = annotations;
            this.initialize();
        }

        private void initialize() {
            this.currentLine = this.annotations.getLine(0);
            this.currentLineNumber = 0;
            this.currentPos = 0;
            this.available = 0;
            int annotationsSize = this.annotations.numberOfLines();
            int i = 0;
            while (i < annotationsSize) {
                this.available += this.annotations.getLine(i).length();
                if (i != annotationsSize - 1) {
                    ++this.available;
                }
                ++i;
            }
        }

        private void getNextLine() {
            ++this.currentLineNumber;
            this.currentPos = 0;
            this.currentLine = this.annotations.getLine(this.currentLineNumber);
        }

        public int read() throws IOException {
            if (this.currentLineNumber >= this.annotations.numberOfLines()) {
                return -1;
            }
            if (this.currentPos > this.currentLine.length()) {
                this.getNextLine();
                if (this.currentLineNumber >= this.annotations.numberOfLines()) {
                    return -1;
                }
            }
            int character = this.currentPos == this.currentLine.length() ? 10 : (int)this.currentLine.charAt(this.currentPos);
            ++this.currentPos;
            --this.available;
            return character;
        }

        public int available() throws IOException {
            return this.available;
        }

        public synchronized void reset() throws IOException {
            this.initialize();
        }
    }
}

