/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanEditorFactory
extends AbstractEditorFactory {
    public static final BooleanEditorFactory instance = new BooleanEditorFactory();

    private BooleanEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return new BooleanProperty(name, description, otherData == null ? Boolean.FALSE : this.valueFrom(otherData[1]), 0.0f);
    }

    private static BooleanProperty booleanPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (BooleanProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (BooleanProperty)desc;
    }

    @Override
    protected Boolean valueFrom(Control valueControl) {
        return ((Button)valueControl).getSelection() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final Button butt = new Button(parent, 32);
        butt.setText("");
        final BooleanProperty bp = BooleanEditorFactory.booleanPropertyFrom(desc);
        boolean set = (Boolean)this.valueFor(source, desc);
        butt.setSelection(set);
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = butt.getSelection();
                if (selected == (Boolean)BooleanEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)bp)) {
                    return;
                }
                source.setProperty((PropertyDescriptor)bp, (Object)selected);
                listener.changed(source, desc, (Object)selected);
                BooleanEditorFactory.this.adjustRendering(source, desc, (Control)butt);
            }
        };
        butt.addSelectionListener((SelectionListener)sa);
        return butt;
    }
}

