/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaProjectClassLoader
extends URLClassLoader {
    private static final Logger log = Logger.getLogger(JavaProjectClassLoader.class);
    private Set<IJavaProject> javaProjects = new HashSet<IJavaProject>();
    private IWorkspaceRoot workspaceRoot;

    public JavaProjectClassLoader(ClassLoader parent, IProject project) {
        super(new URL[0], parent);
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                throw new IllegalArgumentException("The project " + project + " is not a java project");
            }
        }
        catch (CoreException e) {
            throw new IllegalArgumentException("The project " + project + " is not a java project", e);
        }
        this.workspaceRoot = project.getProject().getWorkspace().getRoot();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.addURLs(javaProject, false);
        this.javaProjects = null;
        this.workspaceRoot = null;
    }

    private static IProject projectFor(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        return javaProject.getProject().getWorkspace().getRoot().getProject(classpathEntry.getPath().toString());
    }

    private void addURLs(IJavaProject javaProject, boolean exportsOnly) {
        if (this.javaProjects.contains(javaProject)) {
            return;
        }
        this.javaProjects.add(javaProject);
        try {
            IClasspathEntry[] classpathEntries;
            this.addURL(javaProject.getOutputLocation());
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.isExported() || !exportsOnly) {
                    switch (classpathEntry.getEntryKind()) {
                        case 2: {
                            IProject project = JavaProjectClassLoader.projectFor(javaProject, classpathEntry);
                            IJavaProject javaProj = JavaCore.create((IProject)project);
                            if (javaProj == null) break;
                            this.addURLs(javaProj, true);
                            break;
                        }
                        case 1: {
                            this.addURL(classpathEntry);
                            break;
                        }
                        case 3: {
                            IPath outputLocation = classpathEntry.getOutputLocation();
                            if (outputLocation == null) break;
                            this.addURL(outputLocation);
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            log.debug((Object)("MalformedURLException occurred: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void addURL(IClasspathEntry classpathEntry) {
        this.addURL(classpathEntry.getPath());
    }

    private void addURL(IPath path) {
        try {
            if (this.workspaceRoot.exists(path)) {
                path = this.workspaceRoot.getLocation().append(path);
            }
            URL url = path.toFile().getAbsoluteFile().toURI().toURL();
            this.addURL(url);
        }
        catch (MalformedURLException e) {
            log.debug((Object)("MalformedURLException occurred: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

