/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractProjectCommand
extends AbstractDefaultCommand {
    private IProject project;
    private static final long serialVersionUID = 1L;

    protected AbstractProjectCommand(String theName, String theDescription) {
        super(theName, theDescription);
    }

    @Override
    public void reset() {
        this.setProject(null);
        this.setTerminated(false);
    }

    public void setProject(IProject theProject) {
        this.project = theProject;
        this.setReadyToExecute(this.project != null);
    }

    protected IProject project() {
        return this.project;
    }

    protected void visitProjectResourcesWith(IResourceVisitor visitor) throws CoreException {
        this.project.accept(visitor);
    }

    @Override
    public boolean isReadyToExecute() {
        return this.project != null;
    }

    protected IFolder getProjectFolder(String folderId) {
        return this.project.getFolder(folderId);
    }

    protected IProjectProperties projectProperties() throws PropertiesException {
        return PMDPlugin.getDefault().loadProjectProperties(this.project);
    }
}

