/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import name.herlin.command.AbstractProcessableCommand;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.lang.Language;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractDefaultCommand
extends AbstractProcessableCommand {
    private static final long serialVersionUID = 1L;
    private boolean readOnly;
    private boolean outputProperties;
    private boolean readyToExecute;
    private final String description;
    private final String name;
    private IProgressMonitor monitor;
    private int stepCount;
    private boolean userInitiated;

    public static void logInfo(String message) {
        PMDPlugin.getDefault().logInformation(message);
    }

    public static void logError(String message, Throwable error) {
        PMDPlugin.getDefault().logError(message, error);
    }

    protected AbstractDefaultCommand(String theName, String theDescription) {
        this.name = theName;
        this.description = theDescription;
    }

    public static boolean isJavaFile(IFile file) {
        if (file == null) {
            return false;
        }
        return "JAVA".equalsIgnoreCase(file.getFileExtension());
    }

    public static boolean isLanguageFile(IFile file, Language language) {
        if (file == null) {
            return false;
        }
        return language.hasExtension(file.getFileExtension());
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setOutputProperties(boolean outputProperties) {
        this.outputProperties = outputProperties;
    }

    @Override
    public boolean hasOutputProperties() {
        return this.outputProperties;
    }

    @Override
    public boolean isReadyToExecute() {
        return this.readyToExecute;
    }

    public void setReadyToExecute(boolean readyToExecute) {
        this.readyToExecute = readyToExecute;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    public boolean isUserInitiated() {
        return this.userInitiated;
    }

    public void setUserInitiated(boolean userInitiated) {
        this.userInitiated = userInitiated;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public abstract void execute() throws CommandException;

    @Override
    public abstract void reset();

    protected void beginTask(String name, int totalWork) {
        if (this.monitor != null) {
            this.monitor.beginTask(name, totalWork);
        }
    }

    protected void done() {
        if (this.monitor != null) {
            this.monitor.done();
        }
        this.setTerminated(true);
    }

    protected boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    protected void setTaskName(String name) {
        if (this.monitor != null) {
            this.monitor.setTaskName(name);
        }
    }

    protected void subTask(String name) {
        if (this.monitor != null) {
            this.monitor.subTask(name);
        }
    }

    protected void worked(int work) {
        if (this.monitor != null) {
            this.monitor.worked(work);
        }
    }
}

