/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapeDescriptor;
import net.sourceforge.pmd.eclipse.ui.nls.StringTable;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.util.FontBuilder;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class UISettings {
    private static String[] priorityLabels;
    private static Map<Object, ShapeDescriptor> shapesByPriority;
    private static Map<Integer, RulePriority> prioritiesByIntValue;
    private static Map<RulePriority, String> labelsByPriority;
    private static final int MAX_MARKER_DIMENSION = 9;
    private static IPreferencesManager preferencesManager;
    private static final Map<RulePriority, PriorityDescriptor> uiDescriptorsByPriority;
    public static final FontBuilder CodeFontBuilder;

    static {
        labelsByPriority = new HashMap<RulePriority, String>();
        preferencesManager = PMDPlugin.getDefault().getPreferencesManager();
        uiDescriptorsByPriority = new HashMap<RulePriority, PriorityDescriptor>(5);
        CodeFontBuilder = new FontBuilder("Courier", 11, 0);
    }

    public static void reloadPriorities() {
        uiDescriptorsByPriority.clear();
        UISettings.uiDescriptorsByPriority();
    }

    private static Map<RulePriority, PriorityDescriptor> uiDescriptorsByPriority() {
        if (uiDescriptorsByPriority.isEmpty()) {
            IPreferences preferences = preferencesManager.loadPreferences();
            RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
            int n = rulePriorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                RulePriority rp = rulePriorityArray[n2];
                uiDescriptorsByPriority.put(rp, preferences.getPriorityDescriptor(rp));
                ++n2;
            }
        }
        return uiDescriptorsByPriority;
    }

    public static Shape[] allShapes() {
        return new Shape[]{Shape.circle, Shape.star, Shape.domeLeft, Shape.domeRight, Shape.diamond, Shape.square, Shape.roundedRect, Shape.minus, Shape.pipe, Shape.plus, Shape.triangleUp, Shape.triangleDown, Shape.triangleRight, Shape.triangleLeft, Shape.triangleNorthEast, Shape.triangleSouthEast, Shape.triangleSouthWest, Shape.triangleNorthWest};
    }

    public static RulePriority[] currentPriorities(boolean sortAscending) {
        RulePriority[] priorities = RulePriority.values();
        Arrays.sort(priorities, new Comparator<RulePriority>(){

            @Override
            public int compare(RulePriority rpA, RulePriority rbB) {
                return rpA.getPriority() - rbB.getPriority();
            }
        });
        return priorities;
    }

    public static Map<Shape, ShapeDescriptor> shapeSet(RGB color, int size) {
        HashMap<Shape, ShapeDescriptor> shapes = new HashMap<Shape, ShapeDescriptor>();
        for (Shape shape : EnumSet.allOf(Shape.class)) {
            shapes.put(shape, new ShapeDescriptor(shape, color, size));
        }
        return shapes;
    }

    public static String markerFilenameFor(RulePriority priority) {
        String fileDir = PMDPlugin.getPluginFolder().getAbsolutePath();
        return String.valueOf(fileDir) + "/" + UISettings.relativeMarkerFilenameFor(priority);
    }

    public static String relativeMarkerFilenameFor(RulePriority priority) {
        return "icons/markerP" + priority.getPriority() + ".png";
    }

    private static ImageDescriptor getImageDescriptor(String fileName) {
        URL installURL = PMDPlugin.getDefault().getBundle().getEntry("/");
        try {
            URL url = new URL(installURL, fileName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    public static ImageDescriptor markerDescriptorFor(RulePriority priority) {
        String path = UISettings.relativeMarkerFilenameFor(priority);
        return UISettings.getImageDescriptor(path);
    }

    public static Map<Integer, ImageDescriptor> markerImgDescriptorsByPriority() {
        RulePriority[] priorities = UISettings.currentPriorities(true);
        HashMap<Integer, ImageDescriptor> overlaysByPriority = new HashMap<Integer, ImageDescriptor>(priorities.length);
        RulePriority[] rulePriorityArray = priorities;
        int n = priorities.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            overlaysByPriority.put(priority.getPriority(), UISettings.markerDescriptorFor(priority));
            ++n2;
        }
        return overlaysByPriority;
    }

    public static void createRuleMarkerIcons(Display display) {
        ImageLoader loader = new ImageLoader();
        PriorityDescriptorCache pdc = PriorityDescriptorCache.instance;
        RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            Image image = pdc.descriptorFor(priority).getImage(display, 9);
            loader.data = new ImageData[]{image.getImageData()};
            String fullPath = UISettings.markerFilenameFor(priority);
            loader.save(fullPath, 5);
            image.dispose();
            ++n2;
        }
    }

    private static String pLabelFor(RulePriority priority, boolean useCustom) {
        if (!useCustom) {
            return priority.getName();
        }
        String custom = UISettings.descriptorFor((RulePriority)priority).label;
        return StringUtil.isEmpty((String)custom) ? UISettings.preferencesManager.defaultDescriptorFor((RulePriority)priority).label : custom;
    }

    public static void useCustomPriorityLabels(boolean flag) {
        labelsByPriority.clear();
        RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            labelsByPriority.put(priority, UISettings.pLabelFor(priority, flag));
            ++n2;
        }
    }

    public static String descriptionFor(RulePriority priority) {
        return UISettings.descriptorFor((RulePriority)priority).description;
    }

    public static PriorityDescriptor descriptorFor(RulePriority priority) {
        return UISettings.uiDescriptorsByPriority().get(priority);
    }

    public static String labelFor(RulePriority priority) {
        if (labelsByPriority.isEmpty()) {
            UISettings.useCustomPriorityLabels(preferencesManager.loadPreferences().useCustomPriorityNames());
        }
        return labelsByPriority.get(priority);
    }

    public static Map<Object, ShapeDescriptor> shapesByPriority() {
        if (shapesByPriority != null) {
            return shapesByPriority;
        }
        HashMap<Object, ShapeDescriptor> shapesByPriority = new HashMap<Object, ShapeDescriptor>(UISettings.uiDescriptorsByPriority().size());
        for (Map.Entry<RulePriority, PriorityDescriptor> entry : UISettings.uiDescriptorsByPriority().entrySet()) {
            shapesByPriority.put(entry.getKey(), entry.getValue().shape);
        }
        return shapesByPriority;
    }

    public static RulePriority priorityFor(int value) {
        if (prioritiesByIntValue == null) {
            prioritiesByIntValue = new HashMap<Integer, RulePriority>(UISettings.uiDescriptorsByPriority().size());
            for (Map.Entry<RulePriority, PriorityDescriptor> entry : UISettings.uiDescriptorsByPriority().entrySet()) {
                prioritiesByIntValue.put(entry.getKey().getPriority(), entry.getKey());
            }
        }
        return prioritiesByIntValue.get(value);
    }

    public static String[] getPriorityLabels() {
        if (priorityLabels == null) {
            StringTable stringTable = PMDPlugin.getDefault().getStringTable();
            priorityLabels = new String[]{stringTable.getString("priority.error_high"), stringTable.getString("priority.error"), stringTable.getString("priority.warning_high"), stringTable.getString("priority.warning"), stringTable.getString("priority.information")};
        }
        return priorityLabels;
    }

    public static List<Integer> getPriorityIntValues() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            values.add(priority.getPriority());
            ++n2;
        }
        return values;
    }
}

