/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.core.monitoring;

import com.atlassian.connector.eclipse.monitor.core.InteractionEvent;
import com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin;
import java.util.Date;

public final class Monitoring {
    private final String pluginId;
    private boolean available;

    public Monitoring(String pluginId) {
        this.pluginId = pluginId;
        try {
            Class.forName("com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin");
            this.available = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.available = false;
        }
    }

    public void logAction(String actionId, String details) {
        if (!this.available) {
            return;
        }
        MonitorCorePlugin plugin = MonitorCorePlugin.getDefault();
        if (plugin != null && plugin.getInteractionLogger() != null) {
            plugin.getInteractionLogger().interactionObserved(new InteractionEvent(InteractionEvent.Kind.ACTION, this.pluginId, actionId, details, new Date()));
        }
    }

    public void logJob(String jobId, String details) {
        if (!this.available) {
            return;
        }
        MonitorCorePlugin plugin = MonitorCorePlugin.getDefault();
        if (plugin != null && plugin.getInteractionLogger() != null) {
            plugin.getInteractionLogger().interactionObserved(new InteractionEvent(InteractionEvent.Kind.JOB, this.pluginId, jobId, details, new Date()));
        }
    }
}

