/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.Set;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigSetDialog;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfig;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfigSet;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class ConfigSetsTab {
    private static final String PREFIX = "ConfigurationPropertyPage.tabConfigSets.";
    private static final String DESCRIPTION = "ConfigurationPropertyPage.tabConfigSets.description";
    private static final String NEW_BUTTON = "ConfigurationPropertyPage.tabConfigSets.newButton";
    private static final String EDIT_BUTTON = "ConfigurationPropertyPage.tabConfigSets.editButton";
    private static final String REMOVE_BUTTON = "ConfigurationPropertyPage.tabConfigSets.removeButton";
    private static final String UP_BUTTON = "ConfigurationPropertyPage.tabConfigSets.upButton";
    private static final String DOWN_BUTTON = "ConfigurationPropertyPage.tabConfigSets.downButton";
    private static final int TABLE_WIDTH = 250;
    private PropertiesModel model;
    private PropertiesProject project;
    private Tree configSetsTree;
    private TreeViewer configSetsViewer;
    private IModelElement selectedElement;
    private Button newButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ConfigSetsTab.this.handleButtonPressed((Button)e.widget);
        }
    };
    private IModelChangeListener modelChangeListener = new IModelChangeListener(){

        public void elementChanged(ModelChangeEvent event) {
            if (ConfigSetsTab.this.configSetsViewer != null && !ConfigSetsTab.this.configSetsViewer.getControl().isDisposed()) {
                ConfigSetsTab.this.configSetsViewer.refresh();
            }
        }
    };
    private boolean hasUserMadeChanges;

    public ConfigSetsTab(PropertiesModel model, PropertiesProject project, IModelElement selectedModelElement) {
        this.model = model;
        this.project = project;
        this.calculateSelectedElement(selectedModelElement);
    }

    private void calculateSelectedElement(IModelElement modelElement) {
        if (modelElement != null && this.project != null) {
            this.selectedElement = this.project.getConfigSet(modelElement.getElementName());
        }
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label description = new Label(composite, 64);
        description.setText(BeansUIPlugin.getResourceString(DESCRIPTION));
        description.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite(composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.configSetsTree = new Tree(tableAndButtons, 2816);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.heightHint = 250;
        this.configSetsTree.setLayoutData((Object)data);
        this.configSetsTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigSetsTab.this.handleTreeSelectionChanged();
            }
        });
        this.configSetsViewer = new TreeViewer(this.configSetsTree);
        this.configSetsViewer.setContentProvider((IContentProvider)new ConfigSetContentProvider(this.project));
        this.configSetsViewer.setLabelProvider((IBaseLabelProvider)new PropertiesModelLabelProvider());
        this.configSetsViewer.setSorter((ViewerSorter)new ConfigSetsSorter());
        this.configSetsViewer.setInput((Object)this.project.getProject());
        this.configSetsViewer.expandToLevel((Object)this.project, 1);
        this.configSetsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigSetsTab.this.handleDoubleClick(event);
            }
        });
        if (this.selectedElement != null) {
            this.configSetsViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement), true);
        }
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.newButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(NEW_BUTTON), (SelectionListener)this.buttonListener);
        this.editButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(EDIT_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)false);
        this.removeButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(REMOVE_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)false);
        this.upButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(UP_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)false);
        this.downButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(DOWN_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)false);
        this.model.addChangeListener(this.modelChangeListener);
        this.handleTreeSelectionChanged();
        return composite;
    }

    public void dispose() {
        this.model.removeChangeListener(this.modelChangeListener);
    }

    private void handleButtonPressed(Button button) {
        if (button == this.newButton) {
            this.handleNewButtonPressed();
        } else if (button == this.editButton) {
            this.handleEditButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.upButton) {
            this.handleUpButtonPressed();
        } else if (button == this.downButton) {
            this.handleDownButtonPressed();
        }
        this.handleTreeSelectionChanged();
        this.configSetsTree.setFocus();
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof PropertiesProject) {
                if (this.configSetsViewer.getExpandedState(elem)) {
                    this.configSetsViewer.collapseToLevel(elem, -1);
                } else {
                    this.configSetsViewer.expandToLevel(elem, 1);
                }
            } else if (elem instanceof PropertiesConfigSet) {
                this.handleEditButtonPressed();
            }
        }
    }

    private void handleDownButtonPressed() {
        if (this.selectedElement != null && this.selectedElement instanceof PropertiesConfig) {
            PropertiesConfig config = (PropertiesConfig)this.selectedElement;
            PropertiesConfigSet configSet = (PropertiesConfigSet)config.getElementParent();
            configSet.moveConfigDown((IBeansConfig)config);
            this.configSetsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private void handleEditButtonPressed() {
        ConfigSetDialog dialog;
        if (this.selectedElement != null && this.selectedElement instanceof PropertiesConfigSet && (dialog = new ConfigSetDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), this.project, this.selectedElement.getElementName(), ((PropertiesConfigSet)this.selectedElement).getType())).open() == 0) {
            this.configSetsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private void handleNewButtonPressed() {
        ConfigSetDialog dialog = new ConfigSetDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), this.project, null, IBeansConfigSet.Type.MANUAL);
        if (dialog.open() == 0) {
            this.configSetsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private void handleRemoveButtonPressed() {
        if (this.selectedElement != null && this.selectedElement instanceof PropertiesConfigSet) {
            this.project.removeConfigSet(this.selectedElement.getElementName());
            this.configSetsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private void handleTreeSelectionChanged() {
        boolean moveButtonsEnabled = false;
        boolean editButtonsEnabled = false;
        IStructuredSelection selection = (IStructuredSelection)this.configSetsViewer.getSelection();
        Object selected = selection.getFirstElement();
        if (selected != null) {
            if (selected instanceof PropertiesConfigSet) {
                this.selectedElement = (PropertiesConfigSet)((Object)selected);
                editButtonsEnabled = ((PropertiesConfigSet)this.selectedElement).getType() == IBeansConfigSet.Type.MANUAL;
            } else if (selected instanceof PropertiesConfig) {
                PropertiesConfig config = (PropertiesConfig)((Object)selected);
                PropertiesConfigSet configSet = (PropertiesConfigSet)config.getElementParent();
                if (configSet != null && configSet.getConfigs().size() > 1) {
                    this.selectedElement = config;
                    moveButtonsEnabled = true;
                }
            } else {
                this.selectedElement = null;
            }
        } else {
            this.selectedElement = null;
        }
        this.editButton.setEnabled(editButtonsEnabled);
        this.removeButton.setEnabled(editButtonsEnabled);
        this.upButton.setEnabled(moveButtonsEnabled);
        this.downButton.setEnabled(moveButtonsEnabled);
    }

    private void handleUpButtonPressed() {
        if (this.selectedElement != null && this.selectedElement instanceof PropertiesConfig) {
            PropertiesConfig config = (PropertiesConfig)this.selectedElement;
            PropertiesConfigSet configSet = (PropertiesConfigSet)config.getElementParent();
            configSet.moveConfigUp((IBeansConfig)config);
            this.configSetsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    public boolean hasUserMadeChanges() {
        return this.hasUserMadeChanges;
    }

    private static class ConfigSetContentProvider
    implements ITreeContentProvider {
        private PropertiesProject project;

        public ConfigSetContentProvider(PropertiesProject project) {
            this.project = project;
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PropertiesProject) {
                Set configSets = ((PropertiesProject)((Object)parentElement)).getConfigSets();
                return configSets.toArray();
            }
            if (parentElement instanceof PropertiesConfigSet) {
                Set<IBeansConfig> configs = ((PropertiesConfigSet)((Object)parentElement)).getConfigs();
                return configs.toArray();
            }
            return IModelElement.NO_CHILDREN;
        }

        public Object[] getElements(Object obj) {
            return this.getChildren((Object)this.project);
        }

        public Object getParent(Object element) {
            if (element instanceof PropertiesConfigSet) {
                return ((PropertiesConfigSet)((Object)element)).getElementParent();
            }
            if (element instanceof PropertiesConfig) {
                return ((PropertiesConfig)((Object)element)).getElementParent().getElementParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ConfigSetsSorter
    extends ViewerSorter {
        private ConfigSetsSorter() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            if (elements.length > 0 && !(elements[0] instanceof IBeansConfig)) {
                super.sort(viewer, elements);
            }
        }
    }
}

