/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImages;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabels;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfigSet;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class RemoveFromConfigSetAction
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator locator;

    protected IContributionItem[] getContributionItems() {
        Object element;
        ISelectionService service;
        ISelection selection;
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        if (this.locator != null && (selection = (service = (ISelectionService)this.locator.getService(ISelectionService.class)).getSelection()) instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof IBeansConfigSet) {
            IBeansConfigSet configSet = (IBeansConfigSet)element;
            Set configs = configSet.getConfigs();
            for (IBeansConfig config : configs) {
                ActionContributionItem contribution = new ActionContributionItem((IAction)new RemoveFromConfigSetDynamicAction(configSet, config));
                items.add(contribution);
            }
        }
        return items.toArray(new IContributionItem[0]);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.locator = serviceLocator;
    }

    private class RemoveFromConfigSetDynamicAction
    extends Action {
        private IBeansConfigSet configSet;
        private IBeansConfig config;

        private RemoveFromConfigSetDynamicAction(IBeansConfigSet configSet, IBeansConfig config) {
            this.configSet = configSet;
            this.config = config;
            this.setText(BeansModelLabels.getElementLabel((IModelElement)config, 0));
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)BeansModelImages.getImage((IModelElement)config)));
        }

        public void run() {
            IBeansProject beansProject = BeansModelUtils.getProject((IModelElement)this.config);
            if (beansProject != null) {
                PropertiesProject modelProject = new PropertiesProject(new PropertiesModel(), beansProject);
                PropertiesConfigSet propSet = (PropertiesConfigSet)modelProject.getConfigSet(this.configSet.getElementName());
                propSet.removeConfig(this.config.getElementName());
                modelProject.saveDescription();
                BeansModelLabelDecorator.update();
            }
        }
    }
}

