/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.beans.core.metadata.BeansMetadataPlugin;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanMetadataHolder;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanPropertyDataHolder;

public class BeanMetadataPersistence {
    private static final String STATE_FILE_NAME = ".state";
    private static final String METADATA_FOLDER_NAME = "/metadata/";
    private static final String BEANPROPERTIES_FOLDER_NAME = "/properties/";

    public static void storeMetadata(Map<String, BeanMetadataHolder> metaData) {
        File file = BeansMetadataPlugin.getDefault().getStateLocation().append("/metadata/.state").toFile();
        BeanMetadataPersistence.store(metaData, file);
    }

    public static void storeProperties(Map<String, BeanPropertyDataHolder> properties) {
        File file = BeansMetadataPlugin.getDefault().getStateLocation().append("/properties/.state").toFile();
        BeanMetadataPersistence.store(properties, file);
    }

    private static void store(Object obj, File file) {
        block15: {
            ObjectOutputStream out = null;
            try {
                try {
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    }
                    out = new ObjectOutputStream(new FileOutputStream(file));
                    out.writeObject(obj);
                }
                catch (IOException e) {
                    BeansMetadataPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.core.metadata", "Exception saving meta data model for class " + obj.getClass(), (Throwable)e));
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Map<String, BeanMetadataHolder> loadMetadata() {
        File f = BeansMetadataPlugin.getDefault().getStateLocation().append("/metadata/.state").toFile();
        Map metaData = BeanMetadataPersistence.load(f, Map.class);
        if (metaData != null && metaData.size() > 0) {
            return metaData;
        }
        return new ConcurrentHashMap<String, BeanMetadataHolder>();
    }

    public static Map<String, BeanPropertyDataHolder> loadProperties() {
        File f = BeansMetadataPlugin.getDefault().getStateLocation().append("/properties/.state").toFile();
        Map metaData = BeanMetadataPersistence.load(f, Map.class);
        if (metaData != null && metaData.size() > 0) {
            return metaData;
        }
        return new ConcurrentHashMap<String, BeanPropertyDataHolder>();
    }

    /*
     * Loose catch block
     */
    public static <T> T load(File file, Class<T> clazz) {
        block17: {
            ObjectInputStream in;
            block16: {
                in = null;
                if (!file.exists()) break block16;
                in = new ObjectInputStream(new FileInputStream(file));
                Object object = in.readObject();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                return (T)object;
                catch (Exception e) {
                    try {
                        BeansMetadataPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.core.metadata", "Exception restoring meta data model for class " + clazz, (Throwable)e));
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

