/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.ui.JiraUiUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.StartWorkEditorToolbarAction;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.JiraAttributeEditorFactory;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.JiraCommentPartCopy;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.JiraTaskEditorAttachmentsPart;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.JiraTaskEditorSummaryPart;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.Messages;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.WorkLogPart;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttributePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraTaskEditorPage
extends AbstractTaskEditorPage {
    private StartWorkEditorToolbarAction startWorkAction;
    private boolean disposed = false;
    private final ITaskDataManagerListener updateStartWorkActionListener = new ITaskDataManagerListener(){

        public void taskDataUpdated(TaskDataManagerEvent event) {
            this.update(event);
        }

        public void editsDiscarded(TaskDataManagerEvent event) {
            this.update(event);
        }

        private void update(final TaskDataManagerEvent event) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (event.getTask() != null && JiraTaskEditorPage.this.getModel() != null && event.getTask().equals(JiraTaskEditorPage.this.getModel().getTask()) && JiraTaskEditorPage.this.startWorkAction != null) {
                        JiraTaskEditorPage.this.startWorkAction.update(JiraTaskEditorPage.this.getModel().getTaskData(), event.getTask());
                    }
                }
            });
        }
    };
    private boolean isWorkLogSubmit = false;

    public JiraTaskEditorPage(TaskEditor editor) {
        super(editor, "jira");
        this.setNeedsPrivateSection(false);
        this.setNeedsSubmitButton(true);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set parts = super.createPartDescriptors();
        if (this.removePart(parts, "org.eclipse.mylyn.tasks.ui.editors.parts.attachments")) {
            parts.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attachments"){

                public AbstractTaskEditorPart createPart() {
                    JiraTaskEditorAttachmentsPart jiraTaskEditorAttachmentsPart = new JiraTaskEditorAttachmentsPart();
                    jiraTaskEditorAttachmentsPart.setUseDescriptionColumn(false);
                    return jiraTaskEditorAttachmentsPart;
                }
            }.setPath("attachments"));
        }
        for (TaskEditorPartDescriptor part : parts) {
            if (!part.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.summary")) continue;
            parts.remove(part);
            parts.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.summary"){

                public AbstractTaskEditorPart createPart() {
                    return new JiraTaskEditorSummaryPart();
                }
            }.setPath(part.getPath()));
            break;
        }
        for (TaskEditorPartDescriptor part : parts) {
            if (!part.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.comments")) continue;
            parts.remove(part);
            parts.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.comments"){

                public AbstractTaskEditorPart createPart() {
                    return new JiraCommentPartCopy();
                }
            }.setPath(part.getPath()));
            break;
        }
        this.removePart(parts, "org.eclipse.mylyn.tasks.ui.editors.parts.planning");
        this.removePart(parts, "org.eclipse.mylyn.tasks.ui.editors.parts.attributes");
        parts.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attributes"){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorAttributePart(){

                    protected boolean shouldExpandOnCreate() {
                        return true;
                    }
                };
            }
        }.setPath("attributes"));
        this.removePart(parts, "org.eclipse.mylyn.tasks.ui.editors.parts.descriptions");
        parts.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions"){

            public AbstractTaskEditorPart createPart() {
                TaskEditorDescriptionPart part = new TaskEditorDescriptionPart();
                part.setExpandVertically(true);
                part.setSectionStyle(320);
                return part;
            }
        }.setPath("attributes"));
        if (this.getModel().getTaskData().getRoot().getAttribute("attribute.jira.worklog-not-supported") == null) {
            parts.add(new TaskEditorPartDescriptor("com.atlassian.connnector.eclipse.jira.worklog"){

                public AbstractTaskEditorPart createPart() {
                    return new WorkLogPart();
                }
            }.setPath("comments"));
        }
        return parts;
    }

    private boolean removePart(Set<TaskEditorPartDescriptor> parts, String partId) {
        for (TaskEditorPartDescriptor part : parts) {
            if (!part.getId().equals(partId)) continue;
            parts.remove(part);
            return true;
        }
        return false;
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return new JiraAttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite());
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        super.fillToolBar(toolBarManager);
        if (this.getModel() != null && this.getModel().getTaskData() != null && !this.getModel().getTaskData().isNew()) {
            this.startWorkAction = new StartWorkEditorToolbarAction(this);
            toolBarManager.appendToGroup("repository", (IAction)this.startWorkAction);
        }
    }

    public void dispose() {
        this.disposed = true;
        TasksUiPlugin.getTaskDataManager().removeListener(this.updateStartWorkActionListener);
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        TasksUiPlugin.getTaskDataManager().addListener(this.updateStartWorkActionListener);
    }

    public void doSubmit() {
        TaskAttribute submitFlagAttribute;
        TaskAttribute attribute = this.getModel().getTaskData().getRoot().getMappedAttribute("attribute.jira.worklog.new");
        if (attribute != null && (submitFlagAttribute = attribute.getAttribute("attribute.jira.worklog.new.submit.flag")) != null && submitFlagAttribute.getValue().equals(String.valueOf(true))) {
            this.isWorkLogSubmit = true;
        }
        super.doSubmit();
    }

    protected void handleTaskSubmitted(SubmitJobEvent event) {
        IStatus status;
        if (this.isWorkLogSubmit) {
            this.isWorkLogSubmit = false;
            status = event.getJob().getStatus();
            if (status == null || status.getSeverity() == 0) {
                JiraUiUtil.setLoggedActivityTime(this.getModel().getTask());
            }
        }
        if ((status = event.getJob().getStatus()) != null && status.getSeverity() != 8 && status.getCode() == 5 && status.getMessage().contains("com.atlassian.jira.rpc.exception.RemoteException: Error occurred when running workflow action")) {
            this.handleSubmitErrorCopy(event.getJob());
        } else {
            super.handleTaskSubmitted(event);
        }
    }

    private void handleSubmitErrorCopy(SubmitJob job) {
        if (!this.disposed) {
            IStatus status = job.getStatus();
            String message = Messages.JiraTaskEditorPage_Submit_Failed_Please_Refresh;
            String detailedMessage = String.valueOf(message) + "\n\n" + status.getMessage();
            Object newStatus = status instanceof RepositoryStatus ? RepositoryStatus.createStatus((String)((RepositoryStatus)status).getRepositoryUrl(), (int)status.getSeverity(), (String)status.getPlugin(), (String)detailedMessage) : new Status(status.getSeverity(), status.getPlugin(), detailedMessage);
            this.getTaskEditor().setMessage(message, 3, (IHyperlinkListener)new HyperlinkAdapter((IStatus)newStatus){
                private final /* synthetic */ IStatus val$newStatus;
                {
                    this.val$newStatus = iStatus;
                }

                public void linkActivated(HyperlinkEvent e) {
                    TasksUiInternal.displayStatus((String)org.eclipse.mylyn.internal.tasks.ui.editors.Messages.AbstractTaskEditorPage_Submit_failed, (IStatus)this.val$newStatus);
                }
            });
        }
    }
}

