/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.ui.editor.FillWidthLayout;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.actions.CommentActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractReplyToCommentAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.CommentGroupStrategy;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraCommentPartCopy
extends AbstractTaskEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.tasks.ui.editor.menu.comments";
    private static final int INDENT = -6;
    private static final String KEY_EDITOR = "viewer";
    private List<TaskAttribute> commentAttributes;
    private CommentGroupStrategy commentGroupStrategy = new CommentGroupStrategy(){

        protected boolean hasIncomingChanges(ITaskComment taskComment) {
            return JiraCommentPartCopy.this.getModel().hasIncomingChanges(taskComment.getTaskAttribute());
        }
    };
    private List<CommentGroupViewer> commentGroupViewers;
    private boolean expandAllInProgress;
    private boolean hasIncoming;
    protected Section section;
    private SelectionProviderAdapter selectionProvider;
    private CommentViewer currentViewer;
    private Menu commentMenu;
    private CommentActionGroup actionGroup;

    public JiraCommentPartCopy() {
        this.setPartName(Messages.TaskEditorCommentPart_Comments);
    }

    private void collapseAllComments() {
        try {
            this.getTaskEditorPage().setReflow(false);
            List<CommentGroupViewer> viewers = this.getCommentGroupViewers();
            int i = 0;
            while (i < viewers.size()) {
                if (viewers.get(i).isExpanded()) {
                    viewers.get(i).setExpanded(false);
                    viewers.get(i).isRenderedInSubSection();
                }
                ++i;
            }
        }
        finally {
            this.getTaskEditorPage().setReflow(true);
        }
        this.getTaskEditorPage().reflow();
    }

    private TaskComment convertToTaskComment(TaskDataModel taskDataModel, TaskAttribute commentAttribute) {
        TaskComment taskComment = new TaskComment(taskDataModel.getTaskRepository(), taskDataModel.getTask(), commentAttribute);
        taskDataModel.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)taskComment, commentAttribute);
        return taskComment;
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        this.selectionProvider = new SelectionProviderAdapter();
        this.actionGroup = new CommentActionGroup();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RichTextAttributeEditor editor;
                Object element;
                ISelection selection = JiraCommentPartCopy.this.selectionProvider.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ITaskComment) {
                    final ITaskComment comment = (ITaskComment)element;
                    AbstractReplyToCommentAction replyAction = new AbstractReplyToCommentAction(JiraCommentPartCopy.this.getTaskEditorPage(), comment){

                        protected String getReplyText() {
                            return comment.getText();
                        }
                    };
                    manager.add((IAction)replyAction);
                }
                JiraCommentPartCopy.this.actionGroup.fillContextMenu(manager);
                JiraCommentPartCopy.this.actionGroup.setContext(new ActionContext(JiraCommentPartCopy.this.selectionProvider.getSelection()));
                if (JiraCommentPartCopy.this.currentViewer != null && JiraCommentPartCopy.this.currentViewer.getEditor() instanceof RichTextAttributeEditor && (editor = (RichTextAttributeEditor)JiraCommentPartCopy.this.currentViewer.getEditor()).getViewSourceAction().isEnabled()) {
                    manager.add((IContributionItem)new Separator("planning"));
                    manager.add(editor.getViewSourceAction());
                }
            }
        });
        this.getTaskEditorPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, menuManager, (ISelectionProvider)this.selectionProvider, false);
        this.commentMenu = menuManager.createContextMenu((Control)parent);
        this.section = this.createSection(parent, toolkit, this.hasIncoming);
        this.section.setText(String.valueOf(this.section.getText()) + " (" + this.commentAttributes.size() + ")");
        if (this.commentAttributes.isEmpty()) {
            this.section.setEnabled(false);
        } else if (this.hasIncoming) {
            this.expandSection(toolkit, this.section);
        } else {
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (JiraCommentPartCopy.this.section.getClient() == null) {
                        try {
                            JiraCommentPartCopy.this.expandAllInProgress = true;
                            JiraCommentPartCopy.this.getTaskEditorPage().setReflow(false);
                            JiraCommentPartCopy.this.expandSection(toolkit, JiraCommentPartCopy.this.section);
                        }
                        finally {
                            JiraCommentPartCopy.this.expandAllInProgress = false;
                            JiraCommentPartCopy.this.getTaskEditorPage().setReflow(true);
                        }
                        JiraCommentPartCopy.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, this.section);
    }

    public void dispose() {
        super.dispose();
        if (this.actionGroup != null) {
            this.actionGroup.dispose();
        }
    }

    private void expandAllComments() {
        try {
            this.expandAllInProgress = true;
            this.getTaskEditorPage().setReflow(false);
            if (this.section != null) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.section, (boolean)true);
                List<CommentGroupViewer> viewers = this.getCommentGroupViewers();
                int i = viewers.size() - 1;
                while (i >= 0) {
                    if (!viewers.get(i).isFullyExpanded()) {
                        viewers.get(i).setExpanded(true);
                    }
                    --i;
                }
            }
        }
        finally {
            this.expandAllInProgress = false;
            this.getTaskEditorPage().setReflow(true);
        }
        this.getTaskEditorPage().reflow();
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        composite.setLayout((Layout)EditorUtil.createSectionClientLayout());
        List<CommentGroupViewer> viewers = this.getCommentGroupViewers();
        for (CommentGroupViewer viewer : viewers) {
            Control control = viewer.createControl(composite, toolkit);
            if (viewer.isRenderedInSubSection()) {
                GridDataFactory.fillDefaults().grab(true, false).indent(-12, 0).applyTo(control);
                continue;
            }
            GridDataFactory.fillDefaults().grab(true, false).indent(-6, 0).applyTo(control);
        }
    }

    protected void fillToolBar(ToolBarManager barManager) {
        Action collapseAllAction = new Action(""){

            public void run() {
                JiraCommentPartCopy.this.collapseAllComments();
            }
        };
        collapseAllAction.setImageDescriptor(CommonImages.COLLAPSE_ALL_SMALL);
        collapseAllAction.setToolTipText(Messages.TaskEditorCommentPart_Collapse_Comments);
        barManager.add((IAction)collapseAllAction);
        Action expandAllAction = new Action(""){

            public void run() {
                JiraCommentPartCopy.this.expandAllComments();
            }
        };
        expandAllAction.setImageDescriptor(CommonImages.EXPAND_ALL_SMALL);
        expandAllAction.setToolTipText(Messages.TaskEditorCommentPart_Expand_Comments);
        barManager.add((IAction)expandAllAction);
        if (this.commentAttributes.isEmpty()) {
            collapseAllAction.setEnabled(false);
            expandAllAction.setEnabled(false);
        }
    }

    public CommentGroupStrategy getCommentGroupStrategy() {
        return this.commentGroupStrategy;
    }

    public void setCommentGroupStrategy(CommentGroupStrategy commentGroupStrategy) {
        this.commentGroupStrategy = commentGroupStrategy;
    }

    private List<CommentGroupViewer> getCommentGroupViewers() {
        if (this.commentGroupViewers != null) {
            return this.commentGroupViewers;
        }
        ArrayList<TaskComment> comments = new ArrayList<TaskComment>();
        for (TaskAttribute commentAttribute : this.commentAttributes) {
            comments.add(this.convertToTaskComment(this.getModel(), commentAttribute));
        }
        String currentPersonId = this.getModel().getTaskRepository().getUserName();
        List commentGroups = this.getCommentGroupStrategy().groupComments(comments, currentPersonId);
        this.commentGroupViewers = new ArrayList<CommentGroupViewer>(commentGroups.size());
        if (commentGroups.size() > 0) {
            int i = 0;
            while (i < commentGroups.size()) {
                CommentGroupViewer viewer = new CommentGroupViewer((CommentGroupStrategy.CommentGroup)commentGroups.get(i));
                boolean isLastGroup = i == commentGroups.size() - 1;
                viewer.setRenderedInSubSection(!isLastGroup);
                this.commentGroupViewers.add(viewer);
                ++i;
            }
        }
        return this.commentGroupViewers;
    }

    private void initialize() {
        this.commentAttributes = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "comment");
        if (this.commentAttributes.size() > 0) {
            for (TaskAttribute commentAttribute : this.commentAttributes) {
                if (!this.getModel().hasIncomingChanges(commentAttribute)) continue;
                this.hasIncoming = true;
                break;
            }
        }
    }

    public boolean setFormInput(Object input) {
        String text;
        if (input instanceof String && (text = (String)input).startsWith("task.common.comment-") && this.commentAttributes != null) {
            for (TaskAttribute commentAttribute : this.commentAttributes) {
                if (!text.equals(commentAttribute.getId())) continue;
                this.selectReveal(commentAttribute);
            }
        }
        return super.setFormInput(input);
    }

    public CommentViewer selectReveal(TaskAttribute commentAttribute) {
        if (commentAttribute == null) {
            return null;
        }
        this.expandAllComments(false);
        this.expandGroupViewer(commentAttribute);
        List<CommentGroupViewer> groupViewers = this.getCommentGroupViewers();
        for (CommentGroupViewer groupViewer : groupViewers) {
            for (CommentViewer viewer : groupViewer.getCommentViewers()) {
                if (!viewer.getCommentAttribute().equals((Object)commentAttribute)) continue;
                EditorUtil.reveal((ScrolledForm)this.getTaskEditorPage().getManagedForm().getForm(), (String)commentAttribute.getId());
                return viewer;
            }
        }
        return null;
    }

    private void expandGroupViewer(TaskAttribute commentAttribute) {
        try {
            this.expandAllInProgress = true;
            List<CommentGroupViewer> groupViewers = this.getCommentGroupViewers();
            for (CommentGroupViewer groupViewer : groupViewers) {
                for (CommentViewer viewer : groupViewer.getCommentViewers()) {
                    if (!viewer.getCommentAttribute().equals((Object)commentAttribute)) continue;
                    groupViewer.setExpanded(true);
                }
            }
        }
        finally {
            this.expandAllInProgress = false;
            this.getTaskEditorPage().setReflow(true);
        }
        this.getTaskEditorPage().reflow();
    }

    private void expandAllComments(boolean expandViewers) {
        try {
            this.expandAllInProgress = true;
            this.getTaskEditorPage().setReflow(false);
            if (this.section != null) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.section, (boolean)true);
                if (expandViewers) {
                    List<CommentGroupViewer> viewers = this.getCommentGroupViewers();
                    int i = viewers.size() - 1;
                    while (i >= 0) {
                        if (!viewers.get(i).isFullyExpanded()) {
                            viewers.get(i).setExpanded(true);
                        }
                        --i;
                    }
                }
            }
        }
        finally {
            this.expandAllInProgress = false;
            this.getTaskEditorPage().setReflow(true);
        }
        this.getTaskEditorPage().reflow();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommentGroupViewer {
        private final CommentGroupStrategy.CommentGroup commentGroup;
        private ArrayList<CommentViewer> commentViewers;
        private Section groupSection;
        private boolean renderedInSubSection;

        public CommentGroupViewer(CommentGroupStrategy.CommentGroup commentGroup) {
            this.commentGroup = commentGroup;
        }

        private Composite createCommentViewers(Composite parent, FormToolkit toolkit) {
            List<CommentViewer> viewers = this.getCommentViewers();
            Composite composite = toolkit.createComposite(parent);
            GridLayout contentLayout = new GridLayout();
            contentLayout.marginHeight = 0;
            contentLayout.marginWidth = 0;
            composite.setLayout((Layout)contentLayout);
            for (CommentViewer commentViewer : viewers) {
                Control control = commentViewer.createControl(composite, toolkit);
                GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
            }
            return composite;
        }

        private Control createControl(Composite parent, FormToolkit toolkit) {
            if (this.renderedInSubSection) {
                return this.createSection(parent, toolkit);
            }
            if (JiraCommentPartCopy.this.commentAttributes.size() >= 12) {
                final Canvas separator = new Canvas(parent, 0){

                    public Point computeSize(int wHint, int hHint, boolean changed) {
                        return new Point(wHint == -1 ? 1 : wHint, 1);
                    }
                };
                separator.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        e.gc.setForeground(separator.getForeground());
                        e.gc.drawLine(0, 0, separator.getSize().x, 0);
                    }
                });
                separator.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
                GridDataFactory.fillDefaults().grab(true, false).indent(-12, 0).applyTo((Control)separator);
            }
            return this.createCommentViewers(parent, toolkit);
        }

        private Section createSection(Composite parent, final FormToolkit toolkit) {
            int style = 514;
            this.groupSection = toolkit.createSection(parent, style);
            this.groupSection.clientVerticalSpacing = 0;
            if (this.commentGroup.hasIncoming()) {
                this.groupSection.setBackground(JiraCommentPartCopy.this.getTaskEditorPage().getAttributeEditorToolkit().getColorIncoming());
            }
            this.groupSection.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.groupSection.setText(String.valueOf(this.commentGroup.getGroupName()) + Messages.TaskEditorCommentPart_0 + this.commentGroup.getCommentAttributes().size() + Messages.TaskEditorCommentPart_1);
            if (this.groupSection.isExpanded()) {
                Composite composite = this.createCommentViewers((Composite)this.groupSection, toolkit);
                this.groupSection.setClient((Control)composite);
            } else {
                this.groupSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        if (CommentGroupViewer.this.commentGroup.hasIncoming()) {
                            if (e.getState()) {
                                CommentGroupViewer.this.groupSection.setBackground(null);
                            } else {
                                CommentGroupViewer.this.groupSection.setBackground(JiraCommentPartCopy.this.getTaskEditorPage().getAttributeEditorToolkit().getColorIncoming());
                            }
                        }
                        if (CommentGroupViewer.this.groupSection.getClient() == null) {
                            try {
                                JiraCommentPartCopy.this.getTaskEditorPage().setReflow(false);
                                Composite composite = CommentGroupViewer.this.createCommentViewers((Composite)CommentGroupViewer.this.groupSection, toolkit);
                                CommentGroupViewer.this.groupSection.setClient((Control)composite);
                            }
                            finally {
                                JiraCommentPartCopy.this.getTaskEditorPage().setReflow(true);
                            }
                            JiraCommentPartCopy.this.getTaskEditorPage().reflow();
                        }
                    }
                });
            }
            return this.groupSection;
        }

        public List<CommentViewer> getCommentViewers() {
            if (this.commentViewers != null) {
                return this.commentViewers;
            }
            this.commentViewers = new ArrayList(this.commentGroup.getCommentAttributes().size());
            for (TaskAttribute commentAttribute : this.commentGroup.getCommentAttributes()) {
                CommentViewer commentViewer = new CommentViewer(commentAttribute);
                this.commentViewers.add(commentViewer);
            }
            return this.commentViewers;
        }

        public boolean isExpanded() {
            if (this.groupSection != null) {
                return this.groupSection.isExpanded();
            }
            if (this.commentViewers != null) {
                for (CommentViewer commentViewer : this.commentViewers) {
                    if (!commentViewer.isExpanded()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isFullyExpanded() {
            if (this.groupSection != null && !this.groupSection.isExpanded()) {
                return false;
            }
            if (this.commentViewers != null) {
                for (CommentViewer commentViewer : this.commentViewers) {
                    if (commentViewer.isExpanded()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean isRenderedInSubSection() {
            return this.renderedInSubSection;
        }

        public void setExpanded(boolean expanded) {
            if (this.groupSection != null && this.groupSection.isExpanded() != expanded) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.groupSection, (boolean)expanded);
            }
            if (this.commentViewers != null) {
                for (CommentViewer commentViewer : this.commentViewers) {
                    commentViewer.setExpanded(expanded);
                }
            }
        }

        public void setRenderedInSubSection(boolean renderedInSubSection) {
            this.renderedInSubSection = renderedInSubSection;
        }
    }

    private class CommentViewer {
        private Composite buttonComposite;
        private final TaskAttribute commentAttribute;
        private ExpandableComposite commentComposite;
        private final TaskComment taskComment;
        private AbstractAttributeEditor editor;

        public CommentViewer(TaskAttribute commentAttribute) {
            this.commentAttribute = commentAttribute;
            this.taskComment = new TaskComment(JiraCommentPartCopy.this.getModel().getTaskRepository(), JiraCommentPartCopy.this.getModel().getTask(), commentAttribute);
        }

        public Control createControl(Composite composite, final FormToolkit toolkit) {
            boolean hasIncomingChanges = JiraCommentPartCopy.this.getModel().hasIncomingChanges(this.getCommentAttribute());
            JiraCommentPartCopy.this.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)this.taskComment, this.getCommentAttribute());
            int style = 8228;
            if (hasIncomingChanges || JiraCommentPartCopy.this.expandAllInProgress) {
                style |= 0x40;
            }
            this.commentComposite = toolkit.createExpandableComposite(composite, style);
            this.commentComposite.clientVerticalSpacing = 0;
            this.commentComposite.setLayout((Layout)new GridLayout());
            this.commentComposite.setLayoutData((Object)new GridData(768));
            this.commentComposite.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.buttonComposite = this.createTitle(this.commentComposite, toolkit);
            final Composite commentTextComposite = toolkit.createComposite((Composite)this.commentComposite);
            this.commentComposite.setClient((Control)commentTextComposite);
            commentTextComposite.setLayout((Layout)new FillWidthLayout(EditorUtil.getLayoutAdvisor((AbstractTaskEditorPage)JiraCommentPartCopy.this.getTaskEditorPage()), 15, 0, 0, 3));
            this.commentComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    CommentViewer.this.expandComment(toolkit, commentTextComposite, event.getState());
                }
            });
            if (hasIncomingChanges) {
                this.commentComposite.setBackground(JiraCommentPartCopy.this.getTaskEditorPage().getAttributeEditorToolkit().getColorIncoming());
            }
            if (this.commentComposite.isExpanded()) {
                this.expandComment(toolkit, commentTextComposite, true);
            }
            EditorUtil.setMarker((Widget)this.commentComposite, (String)this.getCommentAttribute().getId());
            return this.commentComposite;
        }

        private Composite createTitle(final ExpandableComposite commentComposite, FormToolkit toolkit) {
            Composite titleComposite = toolkit.createComposite((Composite)commentComposite);
            commentComposite.setTextClient((Control)titleComposite);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = true;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginTop = 0;
            EditorUtil.center((RowLayout)rowLayout);
            titleComposite.setLayout((Layout)rowLayout);
            titleComposite.setBackground(null);
            ImageHyperlink expandCommentHyperlink = this.createTitleHyperLink(toolkit, titleComposite, (ITaskComment)this.taskComment);
            expandCommentHyperlink.setFont(commentComposite.getFont());
            expandCommentHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CommonFormUtil.setExpanded((ExpandableComposite)commentComposite, (!commentComposite.isExpanded() ? 1 : 0) != 0);
                }
            });
            this.createCommentTitleExtention(toolkit, titleComposite);
            Composite buttonComposite = toolkit.createComposite(titleComposite);
            RowLayout buttonCompLayout = new RowLayout();
            buttonCompLayout.marginBottom = 0;
            buttonCompLayout.marginTop = 0;
            buttonComposite.setLayout((Layout)buttonCompLayout);
            buttonComposite.setBackground(null);
            buttonComposite.setVisible(commentComposite.isExpanded());
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            ReplyToCommentAction replyAction = new ReplyToCommentAction(this, (ITaskComment)this.taskComment);
            replyAction.setImageDescriptor(TasksUiImages.COMMENT_REPLY_SMALL);
            toolBarManager.add((IAction)replyAction);
            toolBarManager.createControl(buttonComposite);
            return buttonComposite;
        }

        private void createCommentTitleExtention(FormToolkit toolkit, Composite titleComposite) {
            TaskAttribute visibleTo = this.taskComment.getTaskAttribute().getAttribute("task.common.comment.level");
            if (visibleTo != null && visibleTo.getValue() != null) {
                Label l = toolkit.createLabel(titleComposite, Messages.JiraCommetVisible);
                l.setToolTipText(Messages.JiraCommetVisibleTooltip);
                l.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                l.setBackground(null);
                Label ll = toolkit.createLabel(titleComposite, visibleTo.getValue());
                ll.setToolTipText(Messages.JiraCommetVisibleTooltip);
                ll.setBackground(null);
            }
        }

        private ImageHyperlink createTitleHyperLink(FormToolkit toolkit, Composite toolbarComp, ITaskComment taskComment) {
            ImageHyperlink formHyperlink = toolkit.createImageHyperlink(toolbarComp, 0);
            formHyperlink.setBackground(null);
            formHyperlink.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            IRepositoryPerson author = taskComment.getAuthor();
            if (author != null && author.getPersonId().equalsIgnoreCase(JiraCommentPartCopy.this.getTaskEditorPage().getTaskRepository().getUserName())) {
                formHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_NARROW));
            } else {
                formHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_NARROW));
            }
            StringBuilder sb = new StringBuilder();
            if (taskComment.getNumber() >= 0) {
                sb.append(taskComment.getNumber());
                sb.append(": ");
            }
            if (author != null) {
                if (author.getName() != null) {
                    sb.append(author.getName());
                    formHyperlink.setToolTipText(author.getPersonId());
                } else {
                    sb.append(author.getPersonId());
                }
            }
            if (taskComment.getCreationDate() != null) {
                sb.append(", ");
                sb.append(DateFormat.getDateTimeInstance(2, 3).format(taskComment.getCreationDate()));
            }
            formHyperlink.setText(sb.toString());
            formHyperlink.setEnabled(true);
            formHyperlink.setUnderlined(false);
            return formHyperlink;
        }

        private void expandComment(FormToolkit toolkit, Composite composite, boolean expanded) {
            this.buttonComposite.setVisible(expanded);
            if (expanded && composite.getData(JiraCommentPartCopy.KEY_EDITOR) == null) {
                TaskAttribute textAttribute = JiraCommentPartCopy.this.getTaskData().getAttributeMapper().getAssoctiatedAttribute(this.taskComment.getTaskAttribute());
                this.editor = JiraCommentPartCopy.this.createAttributeEditor(textAttribute);
                if (this.editor != null) {
                    this.editor.setDecorationEnabled(false);
                    this.editor.createControl(composite, toolkit);
                    this.editor.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            JiraCommentPartCopy.this.getTaskEditorPage().selectionChanged((Object)CommentViewer.this.taskComment);
                        }
                    });
                    composite.setData(JiraCommentPartCopy.KEY_EDITOR, (Object)this.editor);
                    JiraCommentPartCopy.this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.editor);
                    JiraCommentPartCopy.this.getTaskEditorPage().reflow();
                }
            } else if (!expanded && composite.getData(JiraCommentPartCopy.KEY_EDITOR) != null) {
                AbstractAttributeEditor editor = (AbstractAttributeEditor)composite.getData(JiraCommentPartCopy.KEY_EDITOR);
                editor.getControl().setMenu(null);
                editor.getControl().dispose();
                composite.setData(JiraCommentPartCopy.KEY_EDITOR, null);
                JiraCommentPartCopy.this.getTaskEditorPage().reflow();
            }
            JiraCommentPartCopy.this.getTaskEditorPage().selectionChanged((Object)this.taskComment);
        }

        public boolean isExpanded() {
            return this.commentComposite != null && this.commentComposite.isExpanded();
        }

        public void setExpanded(boolean expanded) {
            if (this.commentComposite != null && this.commentComposite.isExpanded() != expanded) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.commentComposite, (boolean)expanded);
            }
        }

        public AbstractAttributeEditor getEditor() {
            return this.editor;
        }

        public TaskAttribute getCommentAttribute() {
            return this.commentAttribute;
        }

        public Control getControl() {
            return this.commentComposite;
        }
    }

    private class ReplyToCommentAction
    extends AbstractReplyToCommentAction
    implements IMenuCreator {
        private final ITaskComment taskComment;
        private final CommentViewer commentViewer;

        public ReplyToCommentAction(CommentViewer commentViewer, ITaskComment taskComment) {
            super(JiraCommentPartCopy.this.getTaskEditorPage(), taskComment);
            this.commentViewer = commentViewer;
            this.taskComment = taskComment;
            this.setMenuCreator(this);
        }

        protected String getReplyText() {
            return this.taskComment.getText();
        }

        public Menu getMenu(Control parent) {
            JiraCommentPartCopy.this.currentViewer = this.commentViewer;
            JiraCommentPartCopy.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.taskComment));
            return JiraCommentPartCopy.this.commentMenu;
        }

        public void dispose() {
        }

        public Menu getMenu(Menu parent) {
            JiraCommentPartCopy.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.taskComment));
            return JiraCommentPartCopy.this.commentMenu;
        }
    }
}

