/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.DashboardMainPage;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.FeedsReader;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.StubSyndEntryImpl;

public class FeedsLabelProvider
implements IFontProvider,
IColorProvider,
ITableLabelProvider {
    private final IPreferenceStore prefStore;
    private FeedsReader feedReader;
    private Map<SyndEntry, SyndFeed> feedsMap;
    private static final String ICON_BLOG_BLANK = "rss/blank.png";
    private static final String ICON_BLOG_INCOMING = "rss/overlay-incoming.png";
    private final DashboardMainPage.FeedType feedType;
    private final Color feedColor;

    public FeedsLabelProvider(IPreferenceStore prefStore, DashboardMainPage.FeedType feedType, Color feedColor) {
        this.prefStore = prefStore;
        this.feedType = feedType;
        this.feedColor = feedColor;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Image getColumnImage(Object element, int index) {
        if (element instanceof SyndEntry) {
            SyndEntry entry = (SyndEntry)element;
            SyndFeed feed = this.feedsMap.get(entry);
            if (feed == null) {
                return CommonImages.getImage((ImageDescriptor)IdeUiPlugin.getImageDescriptor(ICON_BLOG_BLANK));
            }
            ImageDescriptor feedImageDesc = this.feedReader.getImageDescriptorForFeed(feed);
            if (this.feedType.equals((Object)DashboardMainPage.FeedType.BLOG) && !this.prefStore.getBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.feed.item.state:" + entry.getLink())) {
                return IdeUiPlugin.getImage(ICON_BLOG_INCOMING);
            }
            if (feedImageDesc == null) {
                return IdeUiPlugin.getImage(ICON_BLOG_BLANK);
            }
            return CommonImages.getImage((ImageDescriptor)feedImageDesc);
        }
        return null;
    }

    public String getColumnText(Object element, int index) {
        if (element instanceof StubSyndEntryImpl) {
            return this.removeHtmlEntities(((StubSyndEntryImpl)((Object)element)).getText());
        }
        if (element instanceof SyndEntry) {
            SyndEntry entry = (SyndEntry)element;
            SyndFeed feed = this.feedsMap.get(entry);
            if (feed == null) {
                return null;
            }
            String title = entry.getTitle();
            Date entryDate = new Date(0L);
            entryDate = entry.getUpdatedDate() != null ? entry.getUpdatedDate() : entry.getPublishedDate();
            String dateString = "";
            if (entryDate != null) {
                dateString = DateFormat.getDateInstance(3).format(entryDate);
            }
            String entryAuthor = "";
            if (entry.getAuthor() != null && entry.getAuthor().trim() != "") {
                entryAuthor = " by " + entry.getAuthor();
            }
            if (this.feedType.equals((Object)DashboardMainPage.FeedType.BLOG) && dateString.length() > 0 && entryAuthor.length() > 0) {
                return this.removeHtmlEntities(String.valueOf(title) + " (" + dateString + entryAuthor + ")");
            }
            return this.removeHtmlEntities(title);
        }
        return null;
    }

    public Font getFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (!(element instanceof StubSyndEntryImpl)) {
            return this.feedColor;
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    private String removeHtmlEntities(String s) {
        s = StringEscapeUtils.unescapeHtml((String)s);
        s = s.replace("\n", " ");
        s = s.replace("\t", " ");
        String[] vals = s.split(" ");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (v.trim().length() > 0) {
                sb.append(v).append(" ");
            }
            ++n2;
        }
        return sb.toString();
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setFeedsMap(Map<SyndEntry, SyndFeed> feedsMap, FeedsReader feedReader) {
        this.feedsMap = feedsMap;
        this.feedReader = feedReader;
    }
}

