/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.discovery;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.ui.AbstractInstallJob;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryUi;
import org.eclipse.mylyn.internal.discovery.ui.InstalledItem;
import org.eclipse.mylyn.internal.discovery.ui.UninstallRequest;
import org.eclipse.mylyn.internal.discovery.ui.wizards.DiscoveryViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Version;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.core.ResourceProvider;
import org.springsource.ide.eclipse.commons.internal.configurator.Activator;
import org.springsource.ide.eclipse.commons.internal.configurator.IConfigurator;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;
import org.springsource.ide.eclipse.dashboard.internal.ui.util.IdeUiUtils;
import org.springsource.ide.eclipse.dashboard.ui.AbstractDashboardPage;
import org.springsource.ide.eclipse.dashboard.ui.IEnabledDashboardPart;

public class DashboardExtensionsPage
extends AbstractDashboardPage
implements IRunnableContext,
IEnabledDashboardPart {
    static final String MAGIC_STOP_THE_MADNESS_NO_UNINSTALL_SYSPROP = "no.auto.m2e.uninstall";
    static final boolean DONT_DO_UNINSTALL = Boolean.parseBoolean(System.getProperty("no.auto.m2e.uninstall", Boolean.FALSE.toString()));
    static final String ID_PREFERENCE_PAGE = "com.springsource.sts.ide.ui.preferencePage.AutoConfiguration";
    public static final String RESOURCE_DISCOVERY_DIRECTORY = "discovery.directory";
    public static final Map<String, List<String>> FEATURE_MAPPING;
    public static final Set<String> SVN_FEATURES;
    public static final String OLD_M2E_EXTENSION_ID = "org.maven.ide.eclipse.feature";
    public static final String NEW_M2E_EXTENSION_ID = "org.eclipse.m2e.feature";
    public static final Set<String> M2E_EXTENSION_IDS;
    public static final Set<String> NEW_M2E_FEATURES;
    public static final Set<String> OLD_M2E_FEATURES;
    private ProgressMonitorPart progressMonitorPart;
    private long activeRunningOperations = 0L;
    private Button installButton;
    private DashboardDiscoveryViewer discoveryViewer;
    private Button cancelButton;
    private final DelegatingProgressMonitor monitor = new DelegatingProgressMonitor();
    private Button findUpdatesButton;
    public static final String ID = "extensions";

    static {
        SVN_FEATURES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.eclipse.team.svn", "org.tigris.subversion.subclipse", "com.collabnet.desktop.feature")));
        M2E_EXTENSION_IDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(OLD_M2E_EXTENSION_ID, NEW_M2E_EXTENSION_ID)));
        NEW_M2E_FEATURES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.eclipse.m2e.feature.feature.group", "org.eclipse.m2e.logback.feature.feature.group", "org.sonatype.m2e.mavenarchiver.feature.feature.group", "org.sonatype.m2e.buildhelper.feature.feature.group", "org.maven.ide.eclipse.wtp.feature.feature.group", "org.maven.ide.eclipse.ajdt.feature.feature.group")));
        OLD_M2E_FEATURES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.maven.ide.eclipse.feature.feature.group")));
        FEATURE_MAPPING = new HashMap<String, List<String>>();
        FEATURE_MAPPING.put("com.google.gwt.eclipse.core", Arrays.asList("com.google.gdt.eclipse.suite.e35.feature", "com.google.appengine.eclipse.sdkbundle.e35.feature.1.3.", "com.google.gwt.eclipse.sdkbundle.e35.feature.2.1.0", "com.google.gdt.eclipse.suite.e36.feature", "com.google.appengine.eclipse.sdkbundle.e36.feature.1.3.5", "com.google.gwt.eclipse.sdkbundle.e36.feature.2.1.0"));
        FEATURE_MAPPING.put("org.datanucleus.ide.eclipse", Collections.singletonList("org.datanucleus.ide.eclipse.feature"));
    }

    public DashboardExtensionsPage(FormEditor editor) {
        super(editor, ID, "Extensions");
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.activeRunningOperations == 0L) {
            this.aboutToStart(fork && cancelable);
        }
        ++this.activeRunningOperations;
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.monitor, (Display)this.getManagedForm().getForm().getShell().getDisplay());
        }
        finally {
            --this.activeRunningOperations;
            if (this.activeRunningOperations <= 0L) {
                this.stopped();
            }
        }
    }

    @Override
    public boolean shouldAdd() {
        String url = ResourceProvider.getUrl((String)RESOURCE_DISCOVERY_DIRECTORY);
        return StringUtils.hasText((String)url);
    }

    private void aboutToStart(boolean enableCancelButton) {
        this.cancelButton.setVisible(true);
        this.cancelButton.setEnabled(true);
        this.installButton.setEnabled(false);
        this.findUpdatesButton.setEnabled(false);
        CommonUiUtil.setEnabled((Composite)((Composite)this.discoveryViewer.getControl()), (boolean)false);
    }

    private void adaptRecursively(Control control, FormToolkit toolkit) {
        toolkit.adapt(control, false, false);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.adaptRecursively(child, toolkit);
                ++n2;
            }
        }
    }

    private void initialize(final DashboardDiscoveryViewer viewer) {
        Dictionary environment = viewer.getEnvironment();
        Version version = IdeUiUtils.getVersion();
        environment.put("com.springsource.sts.version", version.toString());
        environment.put("com.springsource.sts.version.major", version.getMajor());
        environment.put("com.springsource.sts.version.minor", version.getMinor());
        environment.put("com.springsource.sts.version.micro", version.getMicro());
        environment.put("com.springsource.sts.nightly", version.getQualifier().contains("-CI-"));
        version = IdeUiUtils.getPlatformVersion();
        environment.put("platform.version", version.toString());
        environment.put("platform.major", version.getMajor());
        environment.put("platform.minor", version.getMinor());
        environment.put("platform.micro", version.getMicro());
        environment.put("platform", String.valueOf(version.getMajor()) + "." + version.getMinor());
        viewer.setEnvironment(environment);
        viewer.setShowInstalledFilterEnabled(true);
        viewer.addFilter(new ViewerFilter(){
            private Boolean svnInstalled;

            public boolean select(Viewer viewer2, Object parentElement, Object element) {
                DiscoveryConnector connector = (DiscoveryConnector)element;
                if (connector.getId().startsWith("com.collabnet") && !Platform.getOS().equals("win32")) {
                    return false;
                }
                if (SVN_FEATURES.contains(connector.getId()) && !this.isInstalled(connector) && this.isSvnInstalled()) {
                    return false;
                }
                return !connector.getId().startsWith("com.atlassian");
            }

            private boolean isInstalled(DiscoveryConnector connector) {
                Set<String> installedFeatures = viewer.getInstalledFeatures();
                return installedFeatures != null && installedFeatures.contains(String.valueOf(connector.getId()) + ".feature.group");
            }

            private boolean isSvnInstalled() {
                if (this.svnInstalled == null) {
                    this.svnInstalled = Boolean.FALSE;
                    Set<String> installedFeatures = viewer.getInstalledFeatures();
                    if (installedFeatures != null) {
                        for (String svn : SVN_FEATURES) {
                            if (!installedFeatures.contains(String.valueOf(svn) + ".feature.group")) continue;
                            this.svnInstalled = Boolean.TRUE;
                            break;
                        }
                    }
                }
                return this.svnInstalled;
            }
        });
    }

    private void stopped() {
        if (this.getManagedForm().getForm() == null || this.getManagedForm().getForm().isDisposed()) {
            return;
        }
        if (!this.monitor.isCanceled()) {
            this.discoveryViewer.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
        this.discoveryViewer.createBodyContents();
        this.progressMonitorPart.done();
        this.cancelButton.setVisible(false);
        this.cancelButton.setEnabled(false);
        this.installButton.setEnabled(this.discoveryViewer.isComplete());
        this.findUpdatesButton.setEnabled(true);
        CommonUiUtil.setEnabled((Composite)((Composite)this.discoveryViewer.getControl()), (boolean)true);
    }

    public boolean isRelatedToM2e(Set<String> featuresToUninstall, String featureId) {
        if (DONT_DO_UNINSTALL) {
            return false;
        }
        return featuresToUninstall.contains(featureId) || featureId.contains("m2e") || featureId.contains("maven");
    }

    protected void createFormContent(final IManagedForm managedForm) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout(5, false));
        this.discoveryViewer = new DashboardDiscoveryViewer((IShellProvider)this.getSite(), this);
        this.initialize(this.discoveryViewer);
        this.discoveryViewer.setDirectoryUrl(ResourceProvider.getUrl((String)RESOURCE_DISCOVERY_DIRECTORY).replace("%VERSION%", IdeUiUtils.getShortVersion()));
        this.discoveryViewer.setShowConnectorDescriptorKindFilter(false);
        this.discoveryViewer.createControl(body);
        FormToolkit toolkit = managedForm.getToolkit();
        this.adaptRecursively(this.discoveryViewer.getControl(), toolkit);
        GridDataFactory.fillDefaults().span(5, 1).grab(true, true).applyTo(this.discoveryViewer.getControl());
        this.findUpdatesButton = toolkit.createButton(body, "&Find Updates", 0);
        this.findUpdatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IHandlerService handlerService = (IHandlerService)DashboardExtensionsPage.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("org.eclipse.equinox.p2.ui.sdk.update", new Event());
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Find updates failed with an unexpected error.", (Throwable)e), 3);
                }
            }
        });
        Hyperlink configureLink = toolkit.createHyperlink(body, "Configure Extensions...", 0);
        configureLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)DashboardExtensionsPage.this.getSite().getShell(), (String)DashboardExtensionsPage.ID_PREFERENCE_PAGE, (String[])new String[]{DashboardExtensionsPage.ID_PREFERENCE_PAGE}, null);
                dialog.open();
            }
        });
        this.progressMonitorPart = new ProgressMonitorPart(body, null);
        this.monitor.attach((IProgressMonitor)this.progressMonitorPart);
        this.progressMonitorPart.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DashboardExtensionsPage.this.monitor.setCanceled(true);
                DashboardExtensionsPage.this.monitor.detach((IProgressMonitor)DashboardExtensionsPage.this.progressMonitorPart);
            }
        });
        this.adaptRecursively((Control)this.progressMonitorPart, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.progressMonitorPart);
        this.cancelButton = toolkit.createButton(body, "&Cancel", 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardExtensionsPage.this.cancelButton.setEnabled(false);
                DashboardExtensionsPage.this.progressMonitorPart.setCanceled(true);
            }
        });
        this.installButton = toolkit.createButton(body, "&Install", 0);
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStatus uninstallResult;
                List selection = DashboardExtensionsPage.this.discoveryViewer.getInstallableConnectors();
                MultiStatus conflictStatus = new MultiStatus("org.springsource.ide.eclipse.dashboard.ui", -1, new IStatus[]{this.checkForConflicts(SVN_FEATURES, " Please select only one SVN team provider.", selection), this.checkForConflicts(M2E_EXTENSION_IDS, " Please select only one m2e version to install.", selection)}, "Could not perform install due to conflicts.", null);
                if (!conflictStatus.isOK()) {
                    StatusManager.getManager().handle((IStatus)conflictStatus, 6);
                    return;
                }
                Set<String> featuresToUninstall = this.chooseUnwantedFeatures(selection);
                if (!featuresToUninstall.isEmpty() && !(uninstallResult = this.uninstallFeatures(featuresToUninstall)).isOK()) {
                    if (uninstallResult.getSeverity() != 8) {
                        StatusManager.getManager().handle(uninstallResult, 7);
                    }
                    return;
                }
                DiscoveryUi.install((List)DashboardExtensionsPage.this.discoveryViewer.getInstallableConnectors(), (IRunnableContext)DashboardExtensionsPage.this);
            }

            private IStatus uninstallFeatures(final Set<String> featuresToUninstall) {
                String allInstalled = this.findFeaturesToUninstall(featuresToUninstall, DashboardExtensionsPage.this.discoveryViewer.getInstalledFeatures());
                if (allInstalled.length() == 0) {
                    return Status.OK_STATUS;
                }
                boolean res = MessageDialog.openQuestion((Shell)DashboardExtensionsPage.this.getPartControl().getShell(), (String)"Perform uninstall?", (String)("In order to switch versions of m2eclipse, the following features will be uninstalled:\n" + allInstalled + "Do you want to continue?"));
                if (!res) {
                    return Status.CANCEL_STATUS;
                }
                AbstractInstallJob job = DiscoveryUi.createInstallJob();
                try {
                    return job.uninstall(new UninstallRequest(){

                        public boolean select(InstalledItem item) {
                            String featureId = item.getId();
                            return DashboardExtensionsPage.this.isRelatedToM2e(featuresToUninstall, featureId);
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    return new Status(4, "org.springsource.ide.eclipse.dashboard.ui", NLS.bind((String)"Could not uninstall features:\n{0},\n try uninstalling manually.", featuresToUninstall), (Throwable)e);
                }
            }

            private String findFeaturesToUninstall(Set<String> featuresToUninstall, Set<String> installedFeatures) {
                StringBuilder sb = new StringBuilder();
                for (String featureId : installedFeatures) {
                    if (!DashboardExtensionsPage.this.isRelatedToM2e(featuresToUninstall, featureId)) continue;
                    if (featureId.endsWith(".feature.group")) {
                        featureId = featureId.substring(0, featureId.length() - ".feature.group".length());
                    }
                    sb.append("   " + featureId + "\n");
                }
                return sb.toString();
            }

            private Set<String> chooseUnwantedFeatures(List<ConnectorDescriptor> selection) {
                boolean uninstallOld = false;
                boolean uninstallNew = false;
                for (ConnectorDescriptor feature : selection) {
                    if (feature.getId().equals(DashboardExtensionsPage.NEW_M2E_EXTENSION_ID)) {
                        uninstallOld = true;
                        continue;
                    }
                    if (!feature.getId().equals(DashboardExtensionsPage.OLD_M2E_EXTENSION_ID)) continue;
                    uninstallNew = true;
                }
                Set<String> maybeUninstall = uninstallOld ? OLD_M2E_FEATURES : (uninstallNew ? NEW_M2E_FEATURES : Collections.emptySet());
                Set<String> installedFeatures = DashboardExtensionsPage.this.discoveryViewer.getInstalledFeatures();
                HashSet<String> definitelyUninstall = new HashSet<String>();
                for (String feature : maybeUninstall) {
                    if (!installedFeatures.contains(feature)) continue;
                    definitelyUninstall.add(feature);
                }
                if (definitelyUninstall.size() > 0) {
                    IdeUiPlugin.log((IStatus)new Status(1, "org.springsource.ide.eclipse.dashboard.ui", "To make way for a new version of m2eclipse, we will uninstall these features: " + definitelyUninstall));
                }
                return definitelyUninstall;
            }

            public IStatus checkForConflicts(Set<String> featuresToCheck, String prependedMessage, List<ConnectorDescriptor> selection) {
                StringBuilder message = new StringBuilder();
                ArrayList<ConnectorDescriptor> conflicting = new ArrayList<ConnectorDescriptor>();
                for (ConnectorDescriptor descriptor : selection) {
                    if (!featuresToCheck.contains(descriptor.getId())) continue;
                    conflicting.add(descriptor);
                    if (message.length() > 0) {
                        message.append(", ");
                    }
                    message.append(descriptor.getName());
                }
                if (conflicting.size() > 1) {
                    return new Status(2, "org.springsource.ide.eclipse.dashboard.ui", NLS.bind((String)"The following extensions can not be installed at the same time: {0}.", (Object)message.toString()));
                }
                return Status.OK_STATUS;
            }
        });
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!managedForm.getForm().isDisposed()) {
                    DashboardExtensionsPage.this.discoveryViewer.updateDiscovery();
                }
            }
        });
        this.discoveryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DashboardExtensionsPage.this.installButton.setEnabled(DashboardExtensionsPage.this.discoveryViewer.isComplete());
            }
        });
    }

    private final class DashboardDiscoveryViewer
    extends DiscoveryViewer {
        private static final String READ_ONLY_MESSAGE = "Cannot install Groovy-Eclipse because STS installation directory is read-only.  To install Groovy-Eclipse. please make sure that the STS install location is writable by the current user. ";
        private static final String PROGRAM_FILES_MESSAGE = "Cannot install Groovy-Eclipse because STS is located in 'C:\\Program Files'.  To install Groovy-Eclipse, please change the location of STS and try again.";
        private static final String GROOVY_FEATURE_PREFIX = "org.codehaus.groovy";
        private Set<String> installedFeatures;

        private DashboardDiscoveryViewer(IShellProvider shellProvider, IRunnableContext context) {
            super(shellProvider, context);
        }

        public Set<String> getInstalledFeatures() {
            return this.installedFeatures;
        }

        protected Set<String> getInstalledFeatures(IProgressMonitor monitor) throws InterruptedException {
            this.installedFeatures = super.getInstalledFeatures(monitor);
            IConfigurator configurator = Activator.getConfigurator();
            if (configurator != null) {
                this.installedFeatures.addAll(configurator.getInstalledBundles());
            }
            for (Map.Entry<String, List<String>> entry : FEATURE_MAPPING.entrySet()) {
                if (Platform.getBundle((String)entry.getKey()) == null) continue;
                this.installedFeatures.addAll((Collection<String>)entry.getValue());
            }
            return this.installedFeatures;
        }

        protected void postDiscovery(ConnectorDiscovery connectorDiscovery) {
            super.postDiscovery(connectorDiscovery);
            for (DiscoveryConnector connector : connectorDiscovery.getConnectors()) {
                if (connector.getSiteUrl() != null && connector.getSiteUrl().endsWith("-disabled")) {
                    connector.setAvailable(Boolean.FALSE);
                }
                if (connector.getId() == null || !connector.getId().startsWith(GROOVY_FEATURE_PREFIX)) continue;
                File file = this.getInstallLocation();
                boolean readOnly = this.isReadOnly(file);
                boolean inProgramFiles = this.isInProgramFiles(file);
                if (!readOnly && !inProgramFiles) continue;
                connector.setAvailable(Boolean.FALSE);
                connector.setName(String.valueOf(connector.getName()) + " (Cannot install)");
                connector.setDescription(inProgramFiles ? PROGRAM_FILES_MESSAGE : READ_ONLY_MESSAGE + connector.getDescription());
            }
        }

        private File getInstallLocation() {
            URL url = Platform.getInstallLocation().getURL();
            if (url != null) {
                return new File(url.getFile());
            }
            return null;
        }

        private boolean isReadOnly(File installFolder) {
            if (installFolder == null) {
                return false;
            }
            File configurationFolder = new File("configuration");
            return installFolder.exists() && !installFolder.canWrite() || configurationFolder.exists() && !configurationFolder.canWrite();
        }

        private boolean isInProgramFiles(File installFolder) {
            if (installFolder == null) {
                return false;
            }
            String absolutePath = installFolder.getAbsolutePath();
            return installFolder.exists() && (absolutePath.startsWith("C:\\Program Files") || absolutePath.startsWith("C:/Program Files"));
        }
    }
}

