/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooClientManager;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooConstants;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooUtil;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedEvent;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedListener;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClient;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooBuildInfo;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildPlanManager {
    private final Map<TaskRepository, Collection<BambooBuild>> subscribedBuilds = new HashMap<TaskRepository, Collection<BambooBuild>>();
    private final List<BuildsChangedListener> buildChangedListeners = new CopyOnWriteArrayList<BuildsChangedListener>();
    private RefreshBuildsForAllRepositoriesJob scheduledRefreshBuildsForAllRepositoriesJob;
    private IRepositoryManager repositoryManager;
    protected RefreshBuildsForAllRepositoriesJob forcedRefreshBuildsForAllRepositoriesJob;
    private boolean firstScheduledSynchronizationDone;

    public void addBuildsChangedListener(BuildsChangedListener listener) {
        this.buildChangedListeners.add(listener);
    }

    public void removeBuildsChangedListener(BuildsChangedListener listener) {
        this.buildChangedListeners.remove(listener);
    }

    public BambooBuild[] getSubscribedBuilds(TaskRepository repository) {
        if (this.subscribedBuilds.containsKey(repository)) {
            return this.subscribedBuilds.get(repository).toArray(new BambooBuild[this.subscribedBuilds.get(repository).size()]);
        }
        return null;
    }

    public Map<TaskRepository, Collection<BambooBuild>> getSubscribedBuilds() {
        return this.subscribedBuilds;
    }

    public Job buildSubscriptionsChanged(final TaskRepository repository) {
        RefreshBuildsJob job = new RefreshBuildsJob("Refresh builds", repository);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    List<BambooBuild> builds = ((RefreshBuildsJob)event.getJob()).getBuilds();
                    BuildPlanManager.this.processRefreshedBuildsOneRepository(builds, repository);
                }
            }
        });
        job.schedule();
        return job;
    }

    private void getRefreshedBuildsDiff(Collection<BambooBuild> newBuilds, TaskRepository taskRepository, Map<TaskRepository, Collection<BambooBuild>> changedBuilds2, List<String> errorLog) {
        Collection<BambooBuild> currentBuilds = this.subscribedBuilds.get(taskRepository);
        if (currentBuilds == null) {
            currentBuilds = new ArrayList<BambooBuild>();
        }
        ArrayList<BambooBuild> changedBuilds = new ArrayList<BambooBuild>();
        HashSet<BambooBuild> failedToRemove = new HashSet<BambooBuild>();
        HashMap<String, BambooBuild> cachedToAdd = new HashMap<String, BambooBuild>();
        for (BambooBuild newBuild : newBuilds) {
            BambooBuild correspondingOldBuild = null;
            for (BambooBuild oldBuild : currentBuilds) {
                if (!BambooUtil.isSameBuildPlan(newBuild, oldBuild)) continue;
                correspondingOldBuild = oldBuild;
                break;
            }
            if (newBuild.getErrorMessage() != null && newBuild.getStatus() == BuildStatus.UNKNOWN) {
                BambooBuild buildToCache;
                TaskRepository bambooRepo = this.repositoryManager.getRepository("bamboo", newBuild.getServerUrl());
                String repoName = bambooRepo != null ? bambooRepo.getRepositoryLabel() : newBuild.getServer().getUrl();
                errorLog.add(String.valueOf(newBuild.getPlanKey()) + " - " + newBuild.getErrorMessage() + "[" + repoName + "]");
                if (correspondingOldBuild == null || cachedToAdd.containsKey(correspondingOldBuild.getPlanKey()) || (buildToCache = this.createCachedBuild(correspondingOldBuild, newBuild)) == null) continue;
                cachedToAdd.put(correspondingOldBuild.getPlanKey(), buildToCache);
                failedToRemove.add(newBuild);
                continue;
            }
            if (correspondingOldBuild == null || !BambooUtil.isSameBuildPlan(newBuild, correspondingOldBuild) || !newBuild.getPlanKey().equals(correspondingOldBuild.getPlanKey())) continue;
            changedBuilds.add(newBuild);
        }
        newBuilds.removeAll(failedToRemove);
        newBuilds.addAll(cachedToAdd.values());
        this.subscribedBuilds.put(taskRepository, newBuilds);
        changedBuilds2.put(taskRepository, changedBuilds);
    }

    @Nullable
    private BambooBuild createCachedBuild(BambooBuild oldBuild, BambooBuild newBuild) {
        try {
            return new BambooBuildInfo(oldBuild.getPlanKey(), oldBuild.getPlanName(), oldBuild.getMasterPlanKey(), oldBuild.getServer(), oldBuild.getPollingTime(), oldBuild.getProjectName(), oldBuild.getEnabled(), Integer.valueOf(oldBuild.getNumber()), oldBuild.getStatus(), oldBuild.getPlanState(), oldBuild.getReason(), oldBuild.getStartDate(), null, null, oldBuild.getTestsPassed(), oldBuild.getTestsFailed(), oldBuild.getCompletionDate(), newBuild.getErrorMessage(), oldBuild.getException(), oldBuild.getRelativeBuildDate(), oldBuild.getDurationDescription(), (Collection)oldBuild.getCommiters());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefreshedBuildsOneRepository(Collection<BambooBuild> newBuilds, TaskRepository taskRepository) {
        HashMap<TaskRepository, Collection<BambooBuild>> oldBuilds = new HashMap<TaskRepository, Collection<BambooBuild>>(this.subscribedBuilds);
        HashMap<TaskRepository, Collection<BambooBuild>> changedBuilds = new HashMap<TaskRepository, Collection<BambooBuild>>();
        ArrayList<String> errorLog = new ArrayList<String>();
        Map<TaskRepository, Collection<BambooBuild>> map = this.subscribedBuilds;
        synchronized (map) {
            this.getRefreshedBuildsDiff(newBuilds, taskRepository, changedBuilds, errorLog);
        }
        this.notifyListeners(oldBuilds, changedBuilds, errorLog, true, true);
    }

    private void notifyListeners(Map<TaskRepository, Collection<BambooBuild>> oldBuilds, Map<TaskRepository, Collection<BambooBuild>> changedBuilds, List<String> errorLog, boolean forcedRefresh, boolean allUpdated) {
        boolean failed = errorLog != null && errorLog.size() > 0 || !allUpdated;
        BuildsChangedEvent event = new BuildsChangedEvent(changedBuilds, this.subscribedBuilds, oldBuilds, errorLog, forcedRefresh, failed);
        for (BuildsChangedListener listener : this.buildChangedListeners) {
            listener.buildsUpdated(event);
        }
        if (failed && errorLog != null && errorLog.size() > 0 && forcedRefresh) {
            MultiStatus refreshStatus = new MultiStatus("com.atlassian.connector.eclipse.bamboo.core", 0, "Error while refreshing builds", null);
            for (String error : errorLog) {
                refreshStatus.add((IStatus)new Status(2, "com.atlassian.connector.eclipse.bamboo.core", error));
            }
            StatusHandler.log((IStatus)refreshStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repositoryRemoved(TaskRepository repository) {
        HashMap<TaskRepository, Collection<BambooBuild>> oldBuilds = new HashMap<TaskRepository, Collection<BambooBuild>>(this.subscribedBuilds);
        Map<TaskRepository, Collection<BambooBuild>> map = this.subscribedBuilds;
        synchronized (map) {
            Collection<BambooBuild> buildsToRemove = this.subscribedBuilds.get(repository);
            if (buildsToRemove != null) {
                this.subscribedBuilds.remove(repository);
            }
        }
        this.notifyListeners(oldBuilds, null, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefreshedBuildsAllRepositories(Map<TaskRepository, Collection<BambooBuild>> newBuilds, boolean forcedRefresh, boolean allUpdated) {
        HashMap<TaskRepository, Collection<BambooBuild>> oldBuilds = new HashMap<TaskRepository, Collection<BambooBuild>>(this.subscribedBuilds);
        HashMap<TaskRepository, Collection<BambooBuild>> changedBuilds = new HashMap<TaskRepository, Collection<BambooBuild>>();
        ArrayList<String> errorLog = new ArrayList<String>();
        Map<TaskRepository, Collection<BambooBuild>> map = this.subscribedBuilds;
        synchronized (map) {
            for (TaskRepository repository : newBuilds.keySet()) {
                this.getRefreshedBuildsDiff(newBuilds.get(repository), repository, changedBuilds, errorLog);
            }
        }
        this.notifyListeners(oldBuilds, changedBuilds, errorLog, forcedRefresh, allUpdated);
    }

    public Job initializeScheduler(IRepositoryManager manager) {
        this.repositoryManager = manager;
        this.scheduledRefreshBuildsForAllRepositoriesJob = new RefreshBuildsForAllRepositoriesJob(false);
        this.scheduledRefreshBuildsForAllRepositoriesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (BambooCorePlugin.isAutoRefresh() && BambooCorePlugin.getRefreshIntervalMinutes() > 0) {
                    BuildPlanManager.this.scheduledRefreshBuildsForAllRepositoriesJob.schedule(BambooCorePlugin.getRefreshIntervalMinutes() * 60000);
                }
            }
        });
        if (BambooCorePlugin.isAutoRefresh()) {
            this.scheduledRefreshBuildsForAllRepositoriesJob.schedule();
        }
        return this.scheduledRefreshBuildsForAllRepositoriesJob;
    }

    public Job reInitializeScheduler() {
        if (this.repositoryManager != null && !this.scheduledRefreshBuildsForAllRepositoriesJob.isRunning() && this.scheduledRefreshBuildsForAllRepositoriesJob.cancel() && BambooCorePlugin.isAutoRefresh()) {
            this.scheduledRefreshBuildsForAllRepositoriesJob.schedule(BambooCorePlugin.getRefreshIntervalMinutes() * 60000);
        }
        return this.scheduledRefreshBuildsForAllRepositoriesJob;
    }

    public Job refreshAllBuilds() {
        if (this.forcedRefreshBuildsForAllRepositoriesJob == null) {
            this.forcedRefreshBuildsForAllRepositoriesJob = new RefreshBuildsForAllRepositoriesJob(true);
            this.forcedRefreshBuildsForAllRepositoriesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    BuildPlanManager.this.forcedRefreshBuildsForAllRepositoriesJob = null;
                }
            });
            this.forcedRefreshBuildsForAllRepositoriesJob.schedule();
        }
        return this.forcedRefreshBuildsForAllRepositoriesJob;
    }

    public boolean isFirstScheduledSynchronizationDone() {
        return this.firstScheduledSynchronizationDone;
    }

    private class RefreshBuildsForAllRepositoriesJob
    extends Job {
        private final Map<TaskRepository, Collection<BambooBuild>> builds;
        private final boolean manualRefresh;
        private boolean isRunning;

        public RefreshBuildsForAllRepositoriesJob(boolean manualRefresh) {
            super("Refresh Builds");
            this.builds = new HashMap<TaskRepository, Collection<BambooBuild>>();
            this.manualRefresh = manualRefresh;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (BuildPlanManager.this.repositoryManager == null) {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.core", "No repository manager found."));
                return Status.OK_STATUS;
            }
            this.isRunning = true;
            try {
                BambooClientManager clientManager = BambooCorePlugin.getRepositoryConnector().getClientManager();
                Set repositories = BuildPlanManager.this.repositoryManager.getRepositories("bamboo");
                boolean allSuccessful = true;
                for (TaskRepository repository : repositories) {
                    Status status;
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (repository.isOffline()) continue;
                    BambooClient client = clientManager.getClient(repository);
                    try {
                        this.builds.put(repository, client.getBuilds(monitor, repository, this.manualRefresh || !BuildPlanManager.this.firstScheduledSynchronizationDone));
                    }
                    catch (OperationCanceledException e) {
                        status = new Status(4, "com.atlassian.connector.eclipse.bamboo.core", NLS.bind((String)"Update of builds from {0} failed", (Object)repository.getRepositoryLabel()), (Throwable)e);
                        StatusHandler.log((IStatus)status);
                        allSuccessful = false;
                    }
                    catch (CoreException e) {
                        status = new Status(4, "com.atlassian.connector.eclipse.bamboo.core", NLS.bind((String)"Update of builds from {0} failed", (Object)repository.getRepositoryLabel()), (Throwable)e);
                        StatusHandler.log((IStatus)status);
                        allSuccessful = false;
                    }
                }
                BuildPlanManager.this.firstScheduledSynchronizationDone = true;
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                BuildPlanManager.this.processRefreshedBuildsAllRepositories(this.builds, this.manualRefresh, allSuccessful);
            }
            finally {
                this.isRunning = false;
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return this.manualRefresh && family == BambooConstants.FAMILY_REFRESH_OPERATION;
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshBuildsJob
    extends Job {
        private final ArrayList<BambooBuild> builds;
        private final TaskRepository taskRepository;

        public RefreshBuildsJob(String name, TaskRepository repository) {
            super(name);
            this.builds = new ArrayList();
            this.taskRepository = repository;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.taskRepository.isOffline()) {
                BambooClientManager clientManager = BambooCorePlugin.getRepositoryConnector().getClientManager();
                try {
                    this.builds.addAll(clientManager.getClient(this.taskRepository).getBuilds(monitor, this.taskRepository, true));
                }
                catch (CoreException e) {
                    return new Status(4, "com.atlassian.connector.eclipse.bamboo.core", NLS.bind((String)"Update of builds from {0} failed", (Object)this.taskRepository.getRepositoryLabel()), (Throwable)e);
                }
            }
            return new Status(0, "com.atlassian.connector.eclipse.bamboo.core", "Successfully retrieved Builds.");
        }

        public List<BambooBuild> getBuilds() {
            return this.builds;
        }

        public boolean belongsTo(Object family) {
            return family == BambooConstants.FAMILY_REFRESH_OPERATION;
        }
    }
}

