/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.style;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.angularjs.internal.ui.Trace;
import org.eclipse.angularjs.ui.style.AbstractAngularSemanticHighlighting;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class SemanticHighlightingManager {
    private static SemanticHighlightingManager instance;
    private List<AbstractAngularSemanticHighlighting> highlightings = new LinkedList<AbstractAngularSemanticHighlighting>();

    public static synchronized SemanticHighlightingManager getInstance() {
        if (instance == null) {
            instance = new SemanticHighlightingManager();
        }
        return instance;
    }

    private SemanticHighlightingManager() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.sse.ui.semanticHighlighting");
        try {
            this.loadContributor(elements);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while loading angular semantic manager", e);
        }
    }

    private SemanticHighlightingManager loadContributor(IConfigurationElement[] elements) throws Exception {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object o;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String target = element.getAttribute("target");
            if ("org.eclipse.wst.html.core.htmlsource".equals(target) && (o = element.createExecutableExtension("class")) instanceof AbstractAngularSemanticHighlighting) {
                AbstractAngularSemanticHighlighting instance = (AbstractAngularSemanticHighlighting)o;
                this.highlightings.add(instance);
            }
            ++n2;
        }
        return this;
    }

    public List<AbstractAngularSemanticHighlighting> getHighlightings() {
        return this.highlightings;
    }
}

