(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
      return mod(require("tern/lib/infer"), require("tern/lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
      return define([ "tern/lib/infer", "tern/lib/tern" ], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";

  tern.registerPlugin("chrome-extension", function(server, options) {
      return { defs : defs };
  });

  var defs = {"!name":"chrome-extension","!define":{"Alarm":[{"name":{"!type":"string","!doc":"name"}},{"scheduledTime":{"!type":"number","!doc":"scheduledTime"}},{"periodInMinutes":{"!type":"number","!doc":"(optional) periodInMinutes"}}],"BookmarkTreeNodeUnmodifiable":[],"BookmarkTreeNode":[{"id":{"!type":"string","!doc":"id"}},{"parentId":{"!type":"string","!doc":"(optional) parentId"}},{"index":{"!type":"integer","!doc":"(optional) index"}},{"url":{"!type":"string","!doc":"(optional) url"}},{"title":{"!type":"string","!doc":"title"}},{"dateAdded":{"!type":"number","!doc":"(optional) dateAdded"}},{"dateGroupModified":{"!type":"number","!doc":"(optional) dateGroupModified"}},{"unmodifiable":{"!type":"BookmarkTreeNodeUnmodifiable","!doc":"(optional) unmodifiable"}},{"children":{"!type":"[BookmarkTreeNode]","!doc":"(optional) children"}}],"ColorArray":[],"ImageDataType":[],"RemovalOptions":[{"since":{"!type":"number","!doc":"(optional) since"}},{"originTypes":{"!type":"?","!doc":"(optional) originTypes"}}],"DataTypeSet":[{"appcache":{"!type":"boolean","!doc":"(optional) appcache"}},{"cache":{"!type":"boolean","!doc":"(optional) cache"}},{"cookies":{"!type":"boolean","!doc":"(optional) cookies"}},{"downloads":{"!type":"boolean","!doc":"(optional) downloads"}},{"fileSystems":{"!type":"boolean","!doc":"(optional) fileSystems"}},{"formData":{"!type":"boolean","!doc":"(optional) formData"}},{"history":{"!type":"boolean","!doc":"(optional) history"}},{"indexedDB":{"!type":"boolean","!doc":"(optional) indexedDB"}},{"localStorage":{"!type":"boolean","!doc":"(optional) localStorage"}},{"serverBoundCertificates":{"!type":"boolean","!doc":"(optional) serverBoundCertificates"}},{"passwords":{"!type":"boolean","!doc":"(optional) passwords"}},{"pluginData":{"!type":"boolean","!doc":"(optional) pluginData"}},{"serviceWorkers":{"!type":"boolean","!doc":"(optional) serviceWorkers"}},{"webSQL":{"!type":"boolean","!doc":"(optional) webSQL"}}],"Command":[{"name":{"!type":"string","!doc":"(optional) name"}},{"description":{"!type":"string","!doc":"(optional) description"}},{"shortcut":{"!type":"string","!doc":"(optional) shortcut"}}],"ResourceIdentifier":[{"id":{"!type":"string","!doc":"id"}},{"description":{"!type":"string","!doc":"(optional) description"}}],"Scope":[],"ContentSetting":[],"CookiesContentSetting":[],"ImagesContentSetting":[],"JavascriptContentSetting":[],"LocationContentSetting":[],"PluginsContentSetting":[],"PopupsContentSetting":[],"NotificationsContentSetting":[],"FullscreenContentSetting":[],"MouselockContentSetting":[],"PpapiBrokerContentSetting":[],"MultipleAutomaticDownloadsContentSetting":[],"ContextType":[],"ItemType":[],"Cookie":[{"name":{"!type":"string","!doc":"name"}},{"value":{"!type":"string","!doc":"value"}},{"domain":{"!type":"string","!doc":"domain"}},{"hostOnly":{"!type":"boolean","!doc":"hostOnly"}},{"path":{"!type":"string","!doc":"path"}},{"secure":{"!type":"boolean","!doc":"secure"}},{"httpOnly":{"!type":"boolean","!doc":"httpOnly"}},{"session":{"!type":"boolean","!doc":"session"}},{"expirationDate":{"!type":"number","!doc":"(optional) expirationDate"}},{"storeId":{"!type":"string","!doc":"storeId"}}],"CookieStore":[{"id":{"!type":"string","!doc":"id"}},{"tabIds":{"!type":"[integer]","!doc":"tabIds"}}],"OnChangedCause":[],"Debuggee":[{"tabId":{"!type":"integer","!doc":"(optional) tabId"}},{"extensionId":{"!type":"string","!doc":"(optional) extensionId"}},{"targetId":{"!type":"string","!doc":"(optional) targetId"}}],"TargetInfoType":[],"DetachReason":[],"TargetInfo":[{"type":{"!type":"TargetInfoType","!doc":"type"}},{"id":{"!type":"string","!doc":"id"}},{"tabId":{"!type":"integer","!doc":"(optional) tabId"}},{"extensionId":{"!type":"string","!doc":"(optional) extensionId"}},{"attached":{"!type":"boolean","!doc":"attached"}},{"title":{"!type":"string","!doc":"title"}},{"url":{"!type":"string","!doc":"url"}},{"faviconUrl":{"!type":"string","!doc":"(optional) faviconUrl"}}],"PageStateMatcher":[{"pageUrl":{"!type":"?","!doc":"(optional) pageUrl"}},{"css":{"!type":"[string]","!doc":"(optional) css"}}],"ShowPageAction":[],"SetIcon":[{"imageData":{"!type":"?","!doc":"(optional) imageData"}}],"RequestContentScript":[{"css":{"!type":"[string]","!doc":"(optional) css"}},{"js":{"!type":"[string]","!doc":"(optional) js"}},{"allFrames":{"!type":"boolean","!doc":"(optional) allFrames"}},{"matchAboutBlank":{"!type":"boolean","!doc":"(optional) matchAboutBlank"}}],"DesktopCaptureSourceType":[],"Resource":[{"url":{"!type":"string","!doc":"url"}}],"Request":[],"ElementsPanel":[],"SourcesPanel":[],"ExtensionPanel":[],"ExtensionSidebarPane":[],"Button":[],"FilenameConflictAction":[],"InterruptReason":[],"DangerType":[],"State":[],"DownloadItem":[{"id":{"!type":"integer","!doc":"id"}},{"url":{"!type":"string","!doc":"url"}},{"referrer":{"!type":"string","!doc":"referrer"}},{"filename":{"!type":"string","!doc":"filename"}},{"incognito":{"!type":"boolean","!doc":"incognito"}},{"danger":{"!type":"DangerType","!doc":"danger"}},{"mime":{"!type":"string","!doc":"mime"}},{"startTime":{"!type":"string","!doc":"startTime"}},{"endTime":{"!type":"string","!doc":"(optional) endTime"}},{"estimatedEndTime":{"!type":"string","!doc":"(optional) estimatedEndTime"}},{"state":{"!type":"State","!doc":"state"}},{"paused":{"!type":"boolean","!doc":"paused"}},{"canResume":{"!type":"boolean","!doc":"canResume"}},{"error":{"!type":"InterruptReason","!doc":"(optional) error"}},{"bytesReceived":{"!type":"number","!doc":"bytesReceived"}},{"totalBytes":{"!type":"number","!doc":"totalBytes"}},{"fileSize":{"!type":"number","!doc":"fileSize"}},{"exists":{"!type":"boolean","!doc":"exists"}},{"byExtensionId":{"!type":"string","!doc":"(optional) byExtensionId"}},{"byExtensionName":{"!type":"string","!doc":"(optional) byExtensionName"}}],"StringDelta":[{"previous":{"!type":"string","!doc":"(optional) previous"}},{"current":{"!type":"string","!doc":"(optional) current"}}],"DoubleDelta":[{"previous":{"!type":"number","!doc":"(optional) previous"}},{"current":{"!type":"number","!doc":"(optional) current"}}],"BooleanDelta":[{"previous":{"!type":"boolean","!doc":"(optional) previous"}},{"current":{"!type":"boolean","!doc":"(optional) current"}}],"Rule":[{"id":{"!type":"string","!doc":"(optional) id"}},{"tags":{"!type":"[string]","!doc":"(optional) tags"}},{"conditions":{"!type":"[?]","!doc":"conditions"}},{"actions":{"!type":"[?]","!doc":"actions"}},{"priority":{"!type":"integer","!doc":"(optional) priority"}}],"Event":[],"UrlFilter":[{"hostContains":{"!type":"string","!doc":"(optional) hostContains"}},{"hostEquals":{"!type":"string","!doc":"(optional) hostEquals"}},{"hostPrefix":{"!type":"string","!doc":"(optional) hostPrefix"}},{"hostSuffix":{"!type":"string","!doc":"(optional) hostSuffix"}},{"pathContains":{"!type":"string","!doc":"(optional) pathContains"}},{"pathEquals":{"!type":"string","!doc":"(optional) pathEquals"}},{"pathPrefix":{"!type":"string","!doc":"(optional) pathPrefix"}},{"pathSuffix":{"!type":"string","!doc":"(optional) pathSuffix"}},{"queryContains":{"!type":"string","!doc":"(optional) queryContains"}},{"queryEquals":{"!type":"string","!doc":"(optional) queryEquals"}},{"queryPrefix":{"!type":"string","!doc":"(optional) queryPrefix"}},{"querySuffix":{"!type":"string","!doc":"(optional) querySuffix"}},{"urlContains":{"!type":"string","!doc":"(optional) urlContains"}},{"urlEquals":{"!type":"string","!doc":"(optional) urlEquals"}},{"urlMatches":{"!type":"string","!doc":"(optional) urlMatches"}},{"originAndPathMatches":{"!type":"string","!doc":"(optional) originAndPathMatches"}},{"urlPrefix":{"!type":"string","!doc":"(optional) urlPrefix"}},{"urlSuffix":{"!type":"string","!doc":"(optional) urlSuffix"}},{"schemes":{"!type":"[string]","!doc":"(optional) schemes"}},{"ports":{"!type":"?","!doc":"(optional) ports"}}],"ViewType":[],"ImageFormat":[],"ImageDetails":[{"format":{"!type":"?","!doc":"(optional) format"}},{"quality":{"!type":"integer","!doc":"(optional) quality"}}],"RunAt":[],"InjectDetails":[{"code":{"!type":"string","!doc":"(optional) code"}},{"file":{"!type":"string","!doc":"(optional) file"}},{"allFrames":{"!type":"boolean","!doc":"(optional) allFrames"}},{"matchAboutBlank":{"!type":"boolean","!doc":"(optional) matchAboutBlank"}},{"runAt":{"!type":"?","!doc":"(optional) runAt"}}],"FontName":[{"fontId":{"!type":"string","!doc":"fontId"}},{"displayName":{"!type":"string","!doc":"displayName"}}],"ScriptCode":[],"GenericFamily":[],"LevelOfControl":[],"TransitionType":[],"HistoryItem":[{"id":{"!type":"string","!doc":"id"}},{"url":{"!type":"string","!doc":"(optional) url"}},{"title":{"!type":"string","!doc":"(optional) title"}},{"lastVisitTime":{"!type":"number","!doc":"(optional) lastVisitTime"}},{"visitCount":{"!type":"integer","!doc":"(optional) visitCount"}},{"typedCount":{"!type":"integer","!doc":"(optional) typedCount"}}],"VisitItem":[{"id":{"!type":"string","!doc":"id"}},{"visitId":{"!type":"string","!doc":"visitId"}},{"visitTime":{"!type":"number","!doc":"(optional) visitTime"}},{"referringVisitId":{"!type":"string","!doc":"referringVisitId"}},{"transition":{"!type":"TransitionType","!doc":"transition"}}],"AccountInfo":[{"id":{"!type":"string","!doc":"id"}}],"IdleState":[],"KeyboardEventType":[],"KeyboardEvent":[{"type":{"!type":"KeyboardEventType","!doc":"type"}},{"requestId":{"!type":"string","!doc":"requestId"}},{"extensionId":{"!type":"string","!doc":"(optional) extensionId"}},{"key":{"!type":"string","!doc":"key"}},{"code":{"!type":"string","!doc":"code"}},{"keyCode":{"!type":"integer","!doc":"(optional) keyCode"}},{"altKey":{"!type":"boolean","!doc":"(optional) altKey"}},{"ctrlKey":{"!type":"boolean","!doc":"(optional) ctrlKey"}},{"shiftKey":{"!type":"boolean","!doc":"(optional) shiftKey"}},{"capsLock":{"!type":"boolean","!doc":"(optional) capsLock"}}],"InputContextType":[],"InputContext":[{"contextID":{"!type":"integer","!doc":"contextID"}},{"type":{"!type":"InputContextType","!doc":"type"}},{"autoCorrect":{"!type":"boolean","!doc":"autoCorrect"}},{"autoComplete":{"!type":"boolean","!doc":"autoComplete"}},{"spellCheck":{"!type":"boolean","!doc":"spellCheck"}}],"MenuItemStyle":[],"MenuItem":[{"id":{"!type":"string","!doc":"id"}},{"label":{"!type":"string","!doc":"(optional) label"}},{"style":{"!type":"MenuItemStyle","!doc":"(optional) style"}},{"visible":{"!type":"boolean","!doc":"(optional) visible"}},{"checked":{"!type":"boolean","!doc":"(optional) checked"}},{"enabled":{"!type":"boolean","!doc":"(optional) enabled"}}],"UnderlineStyle":[],"WindowPosition":[],"ScreenType":[],"CallbackStyle":[],"MouseButton":[],"IconInfo":[{"size":{"!type":"integer","!doc":"size"}},{"url":{"!type":"string","!doc":"url"}}],"LaunchType":[],"ExtensionDisabledReason":[],"ExtensionType":[],"ExtensionInstallType":[],"ExtensionInfo":[{"id":{"!type":"string","!doc":"id"}},{"name":{"!type":"string","!doc":"name"}},{"shortName":{"!type":"string","!doc":"shortName"}},{"description":{"!type":"string","!doc":"description"}},{"version":{"!type":"string","!doc":"version"}},{"mayDisable":{"!type":"boolean","!doc":"mayDisable"}},{"enabled":{"!type":"boolean","!doc":"enabled"}},{"disabledReason":{"!type":"ExtensionDisabledReason","!doc":"(optional) disabledReason"}},{"isApp":{"!type":"boolean","!doc":"isApp"}},{"type":{"!type":"ExtensionType","!doc":"type"}},{"appLaunchUrl":{"!type":"string","!doc":"(optional) appLaunchUrl"}},{"homepageUrl":{"!type":"string","!doc":"(optional) homepageUrl"}},{"updateUrl":{"!type":"string","!doc":"(optional) updateUrl"}},{"offlineEnabled":{"!type":"boolean","!doc":"offlineEnabled"}},{"optionsUrl":{"!type":"string","!doc":"optionsUrl"}},{"icons":{"!type":"[IconInfo]","!doc":"(optional) icons"}},{"permissions":{"!type":"[string]","!doc":"permissions"}},{"hostPermissions":{"!type":"[string]","!doc":"hostPermissions"}},{"installType":{"!type":"ExtensionInstallType","!doc":"installType"}},{"launchType":{"!type":"LaunchType","!doc":"(optional) launchType"}},{"availableLaunchTypes":{"!type":"[LaunchType]","!doc":"(optional) availableLaunchTypes"}}],"TemplateType":[],"PermissionLevel":[],"NotificationOptions":[{"type":{"!type":"TemplateType","!doc":"(optional) type"}},{"iconUrl":{"!type":"string","!doc":"(optional) iconUrl"}},{"appIconMaskUrl":{"!type":"string","!doc":"(optional) appIconMaskUrl"}},{"title":{"!type":"string","!doc":"(optional) title"}},{"message":{"!type":"string","!doc":"(optional) message"}},{"contextMessage":{"!type":"string","!doc":"(optional) contextMessage"}},{"priority":{"!type":"integer","!doc":"(optional) priority"}},{"eventTime":{"!type":"number","!doc":"(optional) eventTime"}},{"buttons":{"!type":"[?]","!doc":"(optional) buttons"}},{"imageUrl":{"!type":"string","!doc":"(optional) imageUrl"}},{"items":{"!type":"[?]","!doc":"(optional) items"}},{"progress":{"!type":"integer","!doc":"(optional) progress"}},{"isClickable":{"!type":"boolean","!doc":"(optional) isClickable"}}],"DescriptionStyleType":[],"OnInputEnteredDisposition":[],"SuggestResult":[{"content":{"!type":"string","!doc":"content"}},{"description":{"!type":"string","!doc":"description"}}],"Permissions":[{"permissions":{"!type":"[string]","!doc":"(optional) permissions"}},{"origins":{"!type":"[string]","!doc":"(optional) origins"}}],"Level":[],"ProxyServer":[{"scheme":{"!type":"?","!doc":"(optional) scheme"}},{"host":{"!type":"string","!doc":"host"}},{"port":{"!type":"integer","!doc":"(optional) port"}}],"ProxyRules":[{"singleProxy":{"!type":"ProxyServer","!doc":"(optional) singleProxy"}},{"proxyForHttp":{"!type":"ProxyServer","!doc":"(optional) proxyForHttp"}},{"proxyForHttps":{"!type":"ProxyServer","!doc":"(optional) proxyForHttps"}},{"proxyForFtp":{"!type":"ProxyServer","!doc":"(optional) proxyForFtp"}},{"fallbackProxy":{"!type":"ProxyServer","!doc":"(optional) fallbackProxy"}},{"bypassList":{"!type":"[string]","!doc":"(optional) bypassList"}}],"PacScript":[{"url":{"!type":"string","!doc":"(optional) url"}},{"data":{"!type":"string","!doc":"(optional) data"}},{"mandatory":{"!type":"boolean","!doc":"(optional) mandatory"}}],"ProxyConfig":[{"rules":{"!type":"ProxyRules","!doc":"(optional) rules"}},{"pacScript":{"!type":"PacScript","!doc":"(optional) pacScript"}},{"mode":{"!type":"?","!doc":"mode"}}],"Port":[{"name":{"!type":"string","!doc":"name"}},{"disconnect":{"!type":"function","!doc":"disconnect"}},{"onDisconnect":{"!type":"?","!doc":"onDisconnect"}},{"onMessage":{"!type":"?","!doc":"onMessage"}},{"postMessage":{"!type":"function","!doc":"postMessage"}},{"sender":{"!type":"MessageSender","!doc":"(optional) sender"}}],"MessageSender":[{"tab":{"!type":"tabs.Tab","!doc":"(optional) tab"}},{"frameId":{"!type":"integer","!doc":"(optional) frameId"}},{"id":{"!type":"string","!doc":"(optional) id"}},{"url":{"!type":"string","!doc":"(optional) url"}},{"tlsChannelId":{"!type":"string","!doc":"(optional) tlsChannelId"}}],"PlatformOs":[],"PlatformArch":[],"PlatformNaclArch":[],"PlatformInfo":[{"os":{"!type":"PlatformOs","!doc":"os"}},{"arch":{"!type":"PlatformArch","!doc":"arch"}},{"nacl_arch":{"!type":"PlatformNaclArch","!doc":"nacl_arch"}}],"RequestUpdateCheckStatus":[],"OnInstalledReason":[],"OnRestartRequiredReason":[],"Filter":[{"maxResults":{"!type":"integer","!doc":"(optional) maxResults"}}],"Session":[{"lastModified":{"!type":"integer","!doc":"lastModified"}},{"tab":{"!type":"tabs.Tab","!doc":"(optional) tab"}},{"window":{"!type":"windows.Window","!doc":"(optional) window"}}],"Device":[{"deviceName":{"!type":"string","!doc":"deviceName"}},{"sessions":{"!type":"[Session]","!doc":"sessions"}}],"StorageChange":[{"oldValue":{"!type":"?","!doc":"(optional) oldValue"}},{"newValue":{"!type":"?","!doc":"(optional) newValue"}}],"StorageArea":[],"StorageUnitInfo":[{"id":{"!type":"string","!doc":"id"}},{"name":{"!type":"string","!doc":"name"}},{"type":{"!type":"?","!doc":"type"}},{"capacity":{"!type":"number","!doc":"capacity"}}],"CaptureInfo":[{"tabId":{"!type":"integer","!doc":"tabId"}},{"status":{"!type":"?","!doc":"status"}},{"fullscreen":{"!type":"boolean","!doc":"fullscreen"}}],"MediaStreamConstraint":[{"mandatory":{"!type":"?","!doc":"mandatory"}},{"optional":{"!type":"?","!doc":"(optional) optional"}}],"Tab":[{"id":{"!type":"integer","!doc":"(optional) id"}},{"index":{"!type":"integer","!doc":"index"}},{"windowId":{"!type":"integer","!doc":"windowId"}},{"openerTabId":{"!type":"integer","!doc":"(optional) openerTabId"}},{"selected":{"!type":"boolean","!doc":"selected"}},{"highlighted":{"!type":"boolean","!doc":"highlighted"}},{"active":{"!type":"boolean","!doc":"active"}},{"pinned":{"!type":"boolean","!doc":"pinned"}},{"url":{"!type":"string","!doc":"(optional) url"}},{"title":{"!type":"string","!doc":"(optional) title"}},{"favIconUrl":{"!type":"string","!doc":"(optional) favIconUrl"}},{"status":{"!type":"string","!doc":"(optional) status"}},{"incognito":{"!type":"boolean","!doc":"incognito"}},{"width":{"!type":"integer","!doc":"(optional) width"}},{"height":{"!type":"integer","!doc":"(optional) height"}},{"sessionId":{"!type":"string","!doc":"(optional) sessionId"}}],"ZoomSettingsMode":[],"ZoomSettingsScope":[],"ZoomSettings":[{"mode":{"!type":"ZoomSettingsMode","!doc":"(optional) mode"}},{"scope":{"!type":"ZoomSettingsScope","!doc":"(optional) scope"}},{"defaultZoomFactor":{"!type":"number","!doc":"(optional) defaultZoomFactor"}}],"TabStatus":[],"WindowType":[],"MostVisitedURL":[{"url":{"!type":"string","!doc":"url"}},{"title":{"!type":"string","!doc":"title"}}],"TtsEvent":[{"type":{"!type":"?","!doc":"type"}},{"charIndex":{"!type":"number","!doc":"(optional) charIndex"}},{"errorMessage":{"!type":"string","!doc":"(optional) errorMessage"}}],"TtsVoice":[{"voiceName":{"!type":"string","!doc":"(optional) voiceName"}},{"lang":{"!type":"string","!doc":"(optional) lang"}},{"gender":{"!type":"?","!doc":"(optional) gender"}},{"remote":{"!type":"boolean","!doc":"(optional) remote"}},{"extensionId":{"!type":"string","!doc":"(optional) extensionId"}},{"eventTypes":{"!type":"[string]","!doc":"(optional) eventTypes"}}],"ChromeSettingScope":[],"ChromeSetting":[],"TransitionQualifier":[],"ResourceType":[],"OnBeforeRequestOptions":[],"OnBeforeSendHeadersOptions":[],"OnSendHeadersOptions":[],"OnHeadersReceivedOptions":[],"OnAuthRequiredOptions":[],"OnResponseStartedOptions":[],"OnBeforeRedirectOptions":[],"OnCompletedOptions":[],"RequestFilter":[{"urls":{"!type":"[string]","!doc":"urls"}},{"types":{"!type":"[ResourceType]","!doc":"(optional) types"}},{"tabId":{"!type":"integer","!doc":"(optional) tabId"}},{"windowId":{"!type":"integer","!doc":"(optional) windowId"}}],"HttpHeaders":[],"BlockingResponse":[{"cancel":{"!type":"boolean","!doc":"(optional) cancel"}},{"redirectUrl":{"!type":"string","!doc":"(optional) redirectUrl"}},{"requestHeaders":{"!type":"HttpHeaders","!doc":"(optional) requestHeaders"}},{"responseHeaders":{"!type":"HttpHeaders","!doc":"(optional) responseHeaders"}},{"authCredentials":{"!type":"?","!doc":"(optional) authCredentials"}}],"UploadData":[{"bytes":{"!type":"?","!doc":"(optional) bytes"}},{"file":{"!type":"string","!doc":"(optional) file"}}],"InstallStage":[],"ErrorCode":[],"WindowState":[],"Window":[{"id":{"!type":"integer","!doc":"(optional) id"}},{"focused":{"!type":"boolean","!doc":"focused"}},{"top":{"!type":"integer","!doc":"(optional) top"}},{"left":{"!type":"integer","!doc":"(optional) left"}},{"width":{"!type":"integer","!doc":"(optional) width"}},{"height":{"!type":"integer","!doc":"(optional) height"}},{"tabs":{"!type":"[tabs]","!doc":"(optional) tabs"}},{"incognito":{"!type":"boolean","!doc":"incognito"}},{"type":{"!type":"WindowType","!doc":"(optional) type"}},{"state":{"!type":"WindowState","!doc":"(optional) state"}},{"alwaysOnTop":{"!type":"boolean","!doc":"alwaysOnTop"}},{"sessionId":{"!type":"string","!doc":"(optional) sessionId"}}],"CreateType":[]},"chrome":{"alarms":{"create":{"!type":"fn(name?: string, alarmInfo: ?)","!url":"https://developer.chrome.com/extensions/alarms#method-create","!doc":"Creates an alarm."},"get":{"!type":"fn(name?: string, callback: function)","!url":"https://developer.chrome.com/extensions/alarms#method-get","!doc":"Retrieves details about the specified alarm."},"getAll":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/alarms#method-getAll","!doc":"Gets an array of all the alarms."},"clear":{"!type":"fn(name?: string, callback?: function)","!url":"https://developer.chrome.com/extensions/alarms#method-clear","!doc":"Clears the alarm with the given name."},"clearAll":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/alarms#method-clearAll","!doc":"Clears all alarms."},"onAlarm":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/alarms#event-onAlarm"}}},"bookmarks":{"get":{"!type":"fn(idOrIdList: ?, callback: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-get","!doc":"Retrieves the specified BookmarkTreeNode(s)."},"getChildren":{"!type":"fn(id: string, callback: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-getChildren","!doc":"Retrieves the children of the specified BookmarkTreeNode id."},"getRecent":{"!type":"fn(numberOfItems: integer, callback: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-getRecent","!doc":"Retrieves the recently added bookmarks."},"getTree":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-getTree","!doc":"Retrieves the entire Bookmarks hierarchy."},"getSubTree":{"!type":"fn(id: string, callback: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-getSubTree","!doc":"Since Chrome 14."},"search":{"!type":"fn(query: ?, callback: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-search","!doc":"Searches for BookmarkTreeNodes matching the given query."},"create":{"!type":"fn(bookmark: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-create","!doc":"Creates a bookmark or folder under the specified parentId."},"move":{"!type":"fn(id: string, destination: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-move","!doc":"Moves the specified BookmarkTreeNode to the provided location."},"update":{"!type":"fn(id: string, changes: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-update","!doc":"Updates the properties of a bookmark or folder."},"remove":{"!type":"fn(id: string, callback?: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-remove","!doc":"Removes a bookmark or an empty bookmark folder."},"removeTree":{"!type":"fn(id: string, callback?: function)","!url":"https://developer.chrome.com/extensions/bookmarks#method-removeTree","!doc":"Recursively removes a bookmark folder."},"onCreated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/bookmarks#event-onCreated"}},"onRemoved":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/bookmarks#event-onRemoved"}},"onChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/bookmarks#event-onChanged"}},"onMoved":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/bookmarks#event-onMoved"}},"onChildrenReordered":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/bookmarks#event-onChildrenReordered"}},"onImportBegan":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/bookmarks#event-onImportBegan"}},"onImportEnded":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/bookmarks#event-onImportEnded"}}},"browserAction":{"setTitle":{"!type":"fn(details: ?)","!url":"https://developer.chrome.com/extensions/browserAction#method-setTitle","!doc":"Sets the title of the browser action."},"getTitle":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/browserAction#method-getTitle","!doc":"Since Chrome 19."},"setIcon":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/browserAction#method-setIcon","!doc":"Sets the icon for the browser action."},"setPopup":{"!type":"fn(details: ?)","!url":"https://developer.chrome.com/extensions/browserAction#method-setPopup","!doc":"Sets the html document to be opened as a popup when the user clicks on the browser action's icon."},"getPopup":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/browserAction#method-getPopup","!doc":"Since Chrome 19."},"setBadgeText":{"!type":"fn(details: ?)","!url":"https://developer.chrome.com/extensions/browserAction#method-setBadgeText","!doc":"Sets the badge text for the browser action."},"getBadgeText":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/browserAction#method-getBadgeText","!doc":"Since Chrome 19."},"setBadgeBackgroundColor":{"!type":"fn(details: ?)","!url":"https://developer.chrome.com/extensions/browserAction#method-setBadgeBackgroundColor","!doc":"Sets the background color for the badge."},"getBadgeBackgroundColor":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/browserAction#method-getBadgeBackgroundColor","!doc":"Since Chrome 19."},"enable":{"!type":"fn(tabId?: integer)","!url":"https://developer.chrome.com/extensions/browserAction#method-enable","!doc":"Since Chrome 22."},"disable":{"!type":"fn(tabId?: integer)","!url":"https://developer.chrome.com/extensions/browserAction#method-disable","!doc":"Since Chrome 22."},"onClicked":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/browserAction#event-onClicked"}}},"browsingData":{"settings":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-settings","!doc":"Since Chrome 26."},"remove":{"!type":"fn(options: RemovalOptions, dataToRemove: DataTypeSet, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-remove","!doc":"Clears various types of browsing data stored in a user's profile."},"removeAppcache":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeAppcache","!doc":"Clears websites' appcache data."},"removeCache":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeCache","!doc":"Clears the browser's cache."},"removeCookies":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeCookies","!doc":"Clears the browser's cookies and server-bound certificates modified within a particular timeframe."},"removeDownloads":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeDownloads","!doc":"Clears the browser's list of downloaded files (not the downloaded files themselves)."},"removeFileSystems":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeFileSystems","!doc":"Clears websites' file system data."},"removeFormData":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeFormData","!doc":"Clears the browser's stored form data (autofill)."},"removeHistory":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeHistory","!doc":"Clears the browser's history."},"removeIndexedDB":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeIndexedDB","!doc":"Clears websites' IndexedDB data."},"removeLocalStorage":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeLocalStorage","!doc":"Clears websites' local storage data."},"removePluginData":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removePluginData","!doc":"Clears plugins' data."},"removePasswords":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removePasswords","!doc":"Clears the browser's stored passwords."},"removeWebSQL":{"!type":"fn(options: RemovalOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/browsingData#method-removeWebSQL","!doc":"Clears websites' WebSQL data."}},"commands":{"getAll":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/commands#method-getAll","!doc":"Returns all the registered extension commands for this extension and their shortcut (if active)."},"onCommand":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/commands#event-onCommand"}}},"contextMenus":{"create":{"!type":"fn(createProperties: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/contextMenus#method-create","!doc":"Creates a new context menu item."},"update":{"!type":"fn(id: ?, updateProperties: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/contextMenus#method-update","!doc":"Updates a previously created context menu item."},"remove":{"!type":"fn(menuItemId: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/contextMenus#method-remove","!doc":"Removes a context menu item."},"removeAll":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/contextMenus#method-removeAll","!doc":"Removes all context menu items added by this extension."},"onClicked":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/contextMenus#event-onClicked"}}},"cookies":{"get":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/cookies#method-get","!doc":"Retrieves information about a single cookie."},"getAll":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/cookies#method-getAll","!doc":"Retrieves all cookies from a single cookie store that match the given information."},"set":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/cookies#method-set","!doc":"Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist."},"remove":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/cookies#method-remove","!doc":"Deletes a cookie by name."},"getAllCookieStores":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/cookies#method-getAllCookieStores","!doc":"Lists all existing cookie stores."},"onChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/cookies#event-onChanged"}}},"debugger":{"attach":{"!type":"fn(target: Debuggee, requiredVersion: string, callback?: function)","!url":"https://developer.chrome.com/extensions/debugger#method-attach","!doc":"Attaches debugger to the given target."},"detach":{"!type":"fn(target: Debuggee, callback?: function)","!url":"https://developer.chrome.com/extensions/debugger#method-detach","!doc":"Detaches debugger from the given target."},"sendCommand":{"!type":"fn(target: Debuggee, method: string, commandParams?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/debugger#method-sendCommand","!doc":"Sends given command to the debugging target."},"getTargets":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/debugger#method-getTargets","!doc":"Since Chrome 28."},"onEvent":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/debugger#event-onEvent"}},"onDetach":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/debugger#event-onDetach"}}},"desktopCapture":{"chooseDesktopMedia":{"!type":"fn(sources: [DesktopCaptureSourceType], targetTab?: tabs., callback: function) -> integer","!url":"https://developer.chrome.com/extensions/desktopCapture#method-chooseDesktopMedia","!doc":"Shows desktop media picker UI with the specified set of sources."},"cancelChooseDesktopMedia":{"!type":"fn(desktopMediaRequestId: integer)","!url":"https://developer.chrome.com/extensions/desktopCapture#method-cancelChooseDesktopMedia","!doc":"Hides desktop media picker dialog shown by chooseDesktopMedia()."}},"devtools":{"inspectedWindow":{"eval":{"!type":"fn(expression: string, options?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/devtools.inspectedWindow#method-eval","!doc":"Evaluates a JavaScript expression in the context of the main frame of the inspected page."},"reload":{"!type":"fn(reloadOptions?: ?)","!url":"https://developer.chrome.com/extensions/devtools.inspectedWindow#method-reload","!doc":"Reloads the inspected page."},"getResources":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/devtools.inspectedWindow#method-getResources","!doc":"Retrieves the list of resources from the inspected page."},"onResourceAdded":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/devtools.inspectedWindow#event-onResourceAdded"}},"onResourceContentCommitted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/devtools.inspectedWindow#event-onResourceContentCommitted"}}},"network":{"getHAR":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/devtools.network#method-getHAR","!doc":"Returns HAR log that contains all known network requests."},"onRequestFinished":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/devtools.network#event-onRequestFinished"}},"onNavigated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/devtools.network#event-onNavigated"}}},"panels":{"create":{"!type":"fn(title: string, iconPath: string, pagePath: string, callback?: function)","!url":"https://developer.chrome.com/extensions/devtools.panels#method-create","!doc":"Creates an extension panel."},"setOpenResourceHandler":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/devtools.panels#method-setOpenResourceHandler","!doc":"Specifies the function to be called when the user clicks a resource link in the Developer Tools window."},"openResource":{"!type":"fn(url: string, lineNumber: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/devtools.panels#method-openResource","!doc":"Since Chrome 38."}}},"downloads":{"download":{"!type":"fn(options: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/downloads#method-download","!doc":"Download a URL."},"search":{"!type":"fn(query: ?, callback: function)","!url":"https://developer.chrome.com/extensions/downloads#method-search","!doc":"Find DownloadItem."},"pause":{"!type":"fn(downloadId: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/downloads#method-pause","!doc":"Pause the download."},"resume":{"!type":"fn(downloadId: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/downloads#method-resume","!doc":"Resume a paused download."},"cancel":{"!type":"fn(downloadId: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/downloads#method-cancel","!doc":"Cancel a download."},"getFileIcon":{"!type":"fn(downloadId: integer, options?: ?, callback: function)","!url":"https://developer.chrome.com/extensions/downloads#method-getFileIcon","!doc":"Retrieve an icon for the specified download."},"open":{"!type":"fn(downloadId: integer)","!url":"https://developer.chrome.com/extensions/downloads#method-open","!doc":"Open the downloaded file now if the DownloadItem is complete; otherwise returns an error through runtime."},"show":{"!type":"fn(downloadId: integer)","!url":"https://developer.chrome.com/extensions/downloads#method-show","!doc":"Show the downloaded file in its folder in a file manager."},"showDefaultFolder":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/downloads#method-showDefaultFolder","!doc":"Show the default Downloads folder in a file manager."},"erase":{"!type":"fn(query: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/downloads#method-erase","!doc":"Erase matching DownloadItem from history without deleting the downloaded file."},"removeFile":{"!type":"fn(downloadId: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/downloads#method-removeFile","!doc":"Remove the downloaded file if it exists and the DownloadItem is complete; otherwise return an error through runtime."},"acceptDanger":{"!type":"fn(downloadId: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/downloads#method-acceptDanger","!doc":"Prompt the user to accept a dangerous download."},"drag":{"!type":"fn(downloadId: integer)","!url":"https://developer.chrome.com/extensions/downloads#method-drag","!doc":"Initiate dragging the downloaded file to another application."},"setShelfEnabled":{"!type":"fn(enabled: boolean)","!url":"https://developer.chrome.com/extensions/downloads#method-setShelfEnabled","!doc":"Enable or disable the gray shelf at the bottom of every window associated with the current browser profile."},"onCreated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/downloads#event-onCreated"}},"onErased":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/downloads#event-onErased"}},"onChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/downloads#event-onChanged"}},"onDeterminingFilename":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/downloads#event-onDeterminingFilename"}}},"extension":{"sendRequest":{"!type":"fn(extensionId?: string, request: ?, responseCallback?: function)","!url":"https://developer.chrome.com/extensions/extension#method-sendRequest","!doc":"Deprecated since Chrome 33."},"getURL":{"!type":"fn(path: string) -> string","!url":"https://developer.chrome.com/extensions/extension#method-getURL","!doc":"Converts a relative path within an extension install directory to a fully-qualified URL."},"getViews":{"!type":"fn(fetchProperties?: ?)","!url":"https://developer.chrome.com/extensions/extension#method-getViews","!doc":"Returns an array of the JavaScript 'window' objects for each of the pages running inside the current extension."},"getBackgroundPage":{"!type":"fn() -> window","!url":"https://developer.chrome.com/extensions/extension#method-getBackgroundPage","!doc":"Returns the JavaScript 'window' object for the background page running inside the current extension."},"getExtensionTabs":{"!type":"fn(windowId?: integer)","!url":"https://developer.chrome.com/extensions/extension#method-getExtensionTabs","!doc":"Deprecated since Chrome 33."},"isAllowedIncognitoAccess":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/extension#method-isAllowedIncognitoAccess","!doc":"Since Chrome 12."},"isAllowedFileSchemeAccess":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/extension#method-isAllowedFileSchemeAccess","!doc":"Since Chrome 12."},"setUpdateUrlData":{"!type":"fn(data: string)","!url":"https://developer.chrome.com/extensions/extension#method-setUpdateUrlData","!doc":"Since Chrome 9."},"onRequest":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/extension#event-onRequest"}},"onRequestExternal":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/extension#event-onRequestExternal"}}},"fontSettings":{"clearFont":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-clearFont","!doc":"Clears the font set by this extension, if any."},"getFont":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-getFont","!doc":"Gets the font for a given script and generic font family."},"setFont":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-setFont","!doc":"Sets the font for a given script and generic font family."},"getFontList":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-getFontList","!doc":"Gets a list of fonts on the system."},"clearDefaultFontSize":{"!type":"fn(details?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-clearDefaultFontSize","!doc":"Clears the default font size set by this extension, if any."},"getDefaultFontSize":{"!type":"fn(details?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-getDefaultFontSize","!doc":"Gets the default font size."},"setDefaultFontSize":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-setDefaultFontSize","!doc":"Sets the default font size."},"clearDefaultFixedFontSize":{"!type":"fn(details?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-clearDefaultFixedFontSize","!doc":"Clears the default fixed font size set by this extension, if any."},"getDefaultFixedFontSize":{"!type":"fn(details?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-getDefaultFixedFontSize","!doc":"Gets the default size for fixed width fonts."},"setDefaultFixedFontSize":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-setDefaultFixedFontSize","!doc":"Sets the default size for fixed width fonts."},"clearMinimumFontSize":{"!type":"fn(details?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-clearMinimumFontSize","!doc":"Clears the minimum font size set by this extension, if any."},"getMinimumFontSize":{"!type":"fn(details?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-getMinimumFontSize","!doc":"Gets the minimum font size."},"setMinimumFontSize":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/fontSettings#method-setMinimumFontSize","!doc":"Sets the minimum font size."},"onFontChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/fontSettings#event-onFontChanged"}},"onDefaultFontSizeChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/fontSettings#event-onDefaultFontSizeChanged"}},"onDefaultFixedFontSizeChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/fontSettings#event-onDefaultFixedFontSizeChanged"}},"onMinimumFontSizeChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/fontSettings#event-onMinimumFontSizeChanged"}}},"gcm":{"register":{"!type":"fn(senderIds: [string], callback: function)","!url":"https://developer.chrome.com/extensions/gcm#method-register","!doc":"Registers the application with GCM."},"unregister":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/gcm#method-unregister","!doc":"Unregisters the application from GCM."},"send":{"!type":"fn(message: ?, callback: function)","!url":"https://developer.chrome.com/extensions/gcm#method-send","!doc":"Sends a message according to its contents."},"onMessage":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/gcm#event-onMessage"}},"onMessagesDeleted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/gcm#event-onMessagesDeleted"}},"onSendError":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/gcm#event-onSendError"}}},"history":{"search":{"!type":"fn(query: ?, callback: function)","!url":"https://developer.chrome.com/extensions/history#method-search","!doc":"Searches the history for the last visit time of each page matching the query."},"getVisits":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/history#method-getVisits","!doc":"Retrieves information about visits to a URL."},"addUrl":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/history#method-addUrl","!doc":"Adds a URL to the history at the current time with a transition type of \"link\"."},"deleteUrl":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/history#method-deleteUrl","!doc":"Removes all occurrences of the given URL from the history."},"deleteRange":{"!type":"fn(range: ?, callback: function)","!url":"https://developer.chrome.com/extensions/history#method-deleteRange","!doc":"Removes all items within the specified date range from the history."},"deleteAll":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/history#method-deleteAll","!doc":"Deletes all items from the history."},"onVisited":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/history#event-onVisited"}},"onVisitRemoved":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/history#event-onVisitRemoved"}}},"i18n":{"getAcceptLanguages":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/i18n#method-getAcceptLanguages","!doc":"Gets the accept-languages of the browser."},"getMessage":{"!type":"fn(messageName: string, substitutions?: ?) -> string","!url":"https://developer.chrome.com/extensions/i18n#method-getMessage","!doc":"Gets the localized string for the specified message."},"getUILanguage":{"!type":"fn() -> string","!url":"https://developer.chrome.com/extensions/i18n#method-getUILanguage","!doc":"Since Chrome 35."}},"identity":{"getAccounts":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/identity#method-getAccounts","!doc":"Dev channel only."},"getAuthToken":{"!type":"fn(details?: ?, callback: function)","!url":"https://developer.chrome.com/extensions/identity#method-getAuthToken","!doc":"Gets an OAuth2 access token using the client ID and scopes specified in the oauth2 section of manifest."},"getProfileUserInfo":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/identity#method-getProfileUserInfo","!doc":"Since Chrome 37."},"removeCachedAuthToken":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/identity#method-removeCachedAuthToken","!doc":"Removes an OAuth2 access token from the Identity API's token cache."},"launchWebAuthFlow":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/identity#method-launchWebAuthFlow","!doc":"Starts an auth flow at the specified URL."},"getRedirectURL":{"!type":"fn(path?: string) -> string","!url":"https://developer.chrome.com/extensions/identity#method-getRedirectURL","!doc":"Since Chrome 33."},"onSignInChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/identity#event-onSignInChanged"}}},"idle":{"queryState":{"!type":"fn(detectionIntervalInSeconds: integer, callback: function)","!url":"https://developer.chrome.com/extensions/idle#method-queryState","!doc":"Returns \"locked\" if the system is locked, \"idle\" if the user has not generated any input for a specified number of seconds, or \"active\" otherwise."},"setDetectionInterval":{"!type":"fn(intervalInSeconds: integer)","!url":"https://developer.chrome.com/extensions/idle#method-setDetectionInterval","!doc":"Since Chrome 25."},"onStateChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/idle#event-onStateChanged"}}},"input":{"ime":{"setComposition":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-setComposition","!doc":"Set the current composition."},"clearComposition":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-clearComposition","!doc":"Clear the current composition."},"commitText":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-commitText","!doc":"Commits the provided text to the current input."},"sendKeyEvents":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-sendKeyEvents","!doc":"Since Chrome 33."},"hideInputView":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/input.ime#method-hideInputView","!doc":"Since Chrome 34."},"setCandidateWindowProperties":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-setCandidateWindowProperties","!doc":"Sets the properties of the candidate window."},"setCandidates":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-setCandidates","!doc":"Sets the current candidate list."},"setCursorPosition":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-setCursorPosition","!doc":"Set the position of the cursor in the candidate window."},"setMenuItems":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-setMenuItems","!doc":"Adds the provided menu items to the language menu when this IME is active."},"updateMenuItems":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-updateMenuItems","!doc":"Updates the state of the MenuItems specified"},"deleteSurroundingText":{"!type":"fn(parameters: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/input.ime#method-deleteSurroundingText","!doc":"Since Chrome 27."},"keyEventHandled":{"!type":"fn(requestId: string, response: boolean)","!url":"https://developer.chrome.com/extensions/input.ime#method-keyEventHandled","!doc":"Since Chrome 25."},"onActivate":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onActivate"}},"onDeactivated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onDeactivated"}},"onFocus":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onFocus"}},"onBlur":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onBlur"}},"onInputContextUpdate":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onInputContextUpdate"}},"onKeyEvent":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onKeyEvent"}},"onCandidateClicked":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onCandidateClicked"}},"onMenuItemActivated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onMenuItemActivated"}},"onSurroundingTextChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onSurroundingTextChanged"}},"onReset":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/input.ime#event-onReset"}}}},"management":{"getAll":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-getAll","!doc":"Returns a list of information about installed extensions and apps."},"get":{"!type":"fn(id: string, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-get","!doc":"Since Chrome 9."},"getSelf":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-getSelf","!doc":"Since Chrome 39."},"getPermissionWarningsById":{"!type":"fn(id: string, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-getPermissionWarningsById","!doc":"Since Chrome 15."},"getPermissionWarningsByManifest":{"!type":"fn(manifestStr: string, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-getPermissionWarningsByManifest","!doc":"Since Chrome 15."},"setEnabled":{"!type":"fn(id: string, enabled: boolean, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-setEnabled","!doc":"Enables or disables an app or extension."},"uninstall":{"!type":"fn(id: string, options?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-uninstall","!doc":"Uninstalls a currently installed app or extension."},"uninstallSelf":{"!type":"fn(options?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-uninstallSelf","!doc":"Since Chrome 26."},"launchApp":{"!type":"fn(id: string, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-launchApp","!doc":"Launches an application."},"createAppShortcut":{"!type":"fn(id: string, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-createAppShortcut","!doc":"Since Chrome 37."},"setLaunchType":{"!type":"fn(id: string, launchType: LaunchType, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-setLaunchType","!doc":"Since Chrome 37."},"generateAppForLink":{"!type":"fn(url: string, title: string, callback?: function)","!url":"https://developer.chrome.com/extensions/management#method-generateAppForLink","!doc":"Since Chrome 37."},"onInstalled":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/management#event-onInstalled"}},"onUninstalled":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/management#event-onUninstalled"}},"onEnabled":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/management#event-onEnabled"}},"onDisabled":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/management#event-onDisabled"}}},"notifications":{"create":{"!type":"fn(notificationId?: string, options: NotificationOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/notifications#method-create","!doc":"Creates and displays a notification."},"update":{"!type":"fn(notificationId: string, options: NotificationOptions, callback?: function)","!url":"https://developer.chrome.com/extensions/notifications#method-update","!doc":"Updates an existing notification."},"clear":{"!type":"fn(notificationId: string, callback?: function)","!url":"https://developer.chrome.com/extensions/notifications#method-clear","!doc":"Clears the specified notification."},"getAll":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/notifications#method-getAll","!doc":"Since Chrome 29."},"getPermissionLevel":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/notifications#method-getPermissionLevel","!doc":"Since Chrome 32."},"onClosed":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/notifications#event-onClosed"}},"onClicked":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/notifications#event-onClicked"}},"onButtonClicked":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/notifications#event-onButtonClicked"}},"onPermissionLevelChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/notifications#event-onPermissionLevelChanged"}},"onShowSettings":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/notifications#event-onShowSettings"}}},"omnibox":{"setDefaultSuggestion":{"!type":"fn(suggestion: ?)","!url":"https://developer.chrome.com/extensions/omnibox#method-setDefaultSuggestion","!doc":"Sets the description and styling for the default suggestion."},"onInputStarted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/omnibox#event-onInputStarted"}},"onInputChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/omnibox#event-onInputChanged"}},"onInputEntered":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/omnibox#event-onInputEntered"}},"onInputCancelled":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/omnibox#event-onInputCancelled"}}},"pageAction":{"show":{"!type":"fn(tabId: integer)","!url":"https://developer.chrome.com/extensions/pageAction#method-show","!doc":"Shows the page action."},"hide":{"!type":"fn(tabId: integer)","!url":"https://developer.chrome.com/extensions/pageAction#method-hide","!doc":"Hides the page action."},"setTitle":{"!type":"fn(details: ?)","!url":"https://developer.chrome.com/extensions/pageAction#method-setTitle","!doc":"Sets the title of the page action."},"getTitle":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/pageAction#method-getTitle","!doc":"Since Chrome 19."},"setIcon":{"!type":"fn(details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/pageAction#method-setIcon","!doc":"Sets the icon for the page action."},"setPopup":{"!type":"fn(details: ?)","!url":"https://developer.chrome.com/extensions/pageAction#method-setPopup","!doc":"Sets the html document to be opened as a popup when the user clicks on the page action's icon."},"getPopup":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/pageAction#method-getPopup","!doc":"Since Chrome 19."},"onClicked":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/pageAction#event-onClicked"}}},"pageCapture":{"saveAsMHTML":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/pageCapture#method-saveAsMHTML","!doc":"Saves the content of the tab with given id as MHTML."}},"permissions":{"getAll":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/permissions#method-getAll","!doc":"Gets the extension's current set of permissions."},"contains":{"!type":"fn(permissions: Permissions, callback: function)","!url":"https://developer.chrome.com/extensions/permissions#method-contains","!doc":"Checks if the extension has the specified permissions."},"request":{"!type":"fn(permissions: Permissions, callback?: function)","!url":"https://developer.chrome.com/extensions/permissions#method-request","!doc":"Requests access to the specified permissions."},"remove":{"!type":"fn(permissions: Permissions, callback?: function)","!url":"https://developer.chrome.com/extensions/permissions#method-remove","!doc":"Removes access to the specified permissions."},"onAdded":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/permissions#event-onAdded"}},"onRemoved":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/permissions#event-onRemoved"}}},"power":{"requestKeepAwake":{"!type":"fn(level: Level)","!url":"https://developer.chrome.com/extensions/power#method-requestKeepAwake","!doc":"Requests that power management be temporarily disabled."},"releaseKeepAwake":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/power#method-releaseKeepAwake","!doc":"Releases a request previously made via requestKeepAwake()."}},"runtime":{"getBackgroundPage":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/runtime#method-getBackgroundPage","!doc":"Retrieves the JavaScript 'window' object for the background page running inside the current extension/app."},"openOptionsPage":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/runtime#method-openOptionsPage","!doc":"Since Chrome 42."},"getManifest":{"!type":"fn() -> ?","!url":"https://developer.chrome.com/extensions/runtime#method-getManifest","!doc":"Returns details about the app or extension from the manifest."},"getURL":{"!type":"fn(path: string) -> string","!url":"https://developer.chrome.com/extensions/runtime#method-getURL","!doc":"Converts a relative path within an app/extension install directory to a fully-qualified URL."},"setUninstallURL":{"!type":"fn(url: string)","!url":"https://developer.chrome.com/extensions/runtime#method-setUninstallURL","!doc":"Since Chrome 41."},"reload":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/runtime#method-reload","!doc":"Since Chrome 25."},"requestUpdateCheck":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/runtime#method-requestUpdateCheck","!doc":"Since Chrome 25."},"restart":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/runtime#method-restart","!doc":"Since Chrome 32."},"connect":{"!type":"fn(extensionId?: string, connectInfo?: ?) -> Port","!url":"https://developer.chrome.com/extensions/runtime#method-connect","!doc":"Since Chrome 26."},"connectNative":{"!type":"fn(application: string) -> Port","!url":"https://developer.chrome.com/extensions/runtime#method-connectNative","!doc":"Since Chrome 28."},"sendMessage":{"!type":"fn(extensionId?: string, message: ?, options?: ?, responseCallback?: function)","!url":"https://developer.chrome.com/extensions/runtime#method-sendMessage","!doc":"Since Chrome 26."},"sendNativeMessage":{"!type":"fn(application: string, message: ?, responseCallback?: function)","!url":"https://developer.chrome.com/extensions/runtime#method-sendNativeMessage","!doc":"Since Chrome 28."},"getPlatformInfo":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/runtime#method-getPlatformInfo","!doc":"Since Chrome 29."},"getPackageDirectoryEntry":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/runtime#method-getPackageDirectoryEntry","!doc":"Since Chrome 29."},"onStartup":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onStartup"}},"onInstalled":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onInstalled"}},"onSuspend":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onSuspend"}},"onSuspendCanceled":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onSuspendCanceled"}},"onUpdateAvailable":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onUpdateAvailable"}},"onBrowserUpdateAvailable":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onBrowserUpdateAvailable"}},"onConnect":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onConnect"}},"onConnectExternal":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onConnectExternal"}},"onMessage":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onMessage"}},"onMessageExternal":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onMessageExternal"}},"onRestartRequired":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/runtime#event-onRestartRequired"}}},"sessions":{"getRecentlyClosed":{"!type":"fn(filter?: Filter, callback: function)","!url":"https://developer.chrome.com/extensions/sessions#method-getRecentlyClosed","!doc":"Gets the list of recently closed tabs and/or windows."},"getDevices":{"!type":"fn(filter?: Filter, callback: function)","!url":"https://developer.chrome.com/extensions/sessions#method-getDevices","!doc":"Retrieves all devices with synced sessions."},"restore":{"!type":"fn(sessionId?: string, callback?: function)","!url":"https://developer.chrome.com/extensions/sessions#method-restore","!doc":"Reopens a windows."},"onChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/sessions#event-onChanged"}}},"system":{"cpu":{"getInfo":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/system.cpu#method-getInfo","!doc":"Queries basic CPU information of the system."}},"memory":{"getInfo":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/system.memory#method-getInfo","!doc":"Get physical memory information."}},"storage":{"getInfo":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/system.storage#method-getInfo","!doc":"Get the storage information from the system."},"ejectDevice":{"!type":"fn(id: string, callback: function)","!url":"https://developer.chrome.com/extensions/system.storage#method-ejectDevice","!doc":"Ejects a removable storage device."},"getAvailableCapacity":{"!type":"fn(id: string, callback: function)","!url":"https://developer.chrome.com/extensions/system.storage#method-getAvailableCapacity","!doc":"Dev channel only."},"onAttached":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/system.storage#event-onAttached"}},"onDetached":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/system.storage#event-onDetached"}}}},"tabCapture":{"capture":{"!type":"fn(options: ?, callback: function)","!url":"https://developer.chrome.com/extensions/tabCapture#method-capture","!doc":"Captures the visible area of the currently active tab."},"getCapturedTabs":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/tabCapture#method-getCapturedTabs","!doc":"Returns a list of tabs that have requested capture or are being captured, i."},"onStatusChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabCapture#event-onStatusChanged"}}},"tabs":{"get":{"!type":"fn(tabId: integer, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-get","!doc":"Retrieves details about the specified tab."},"getCurrent":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-getCurrent","!doc":"Gets the tab that this script call is being made from."},"connect":{"!type":"fn(tabId: integer, connectInfo?: ?) -> runtime.Port","!url":"https://developer.chrome.com/extensions/tabs#method-connect","!doc":"Connects to the content script(s) in the specified tab."},"sendRequest":{"!type":"fn(tabId: integer, request: ?, responseCallback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-sendRequest","!doc":"Deprecated since Chrome 33."},"sendMessage":{"!type":"fn(tabId: integer, message: ?, options?: ?, responseCallback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-sendMessage","!doc":"Since Chrome 20."},"getSelected":{"!type":"fn(windowId?: integer, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-getSelected","!doc":"Deprecated since Chrome 33."},"getAllInWindow":{"!type":"fn(windowId?: integer, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-getAllInWindow","!doc":"Deprecated since Chrome 33."},"create":{"!type":"fn(createProperties: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-create","!doc":"Creates a new tab."},"duplicate":{"!type":"fn(tabId: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-duplicate","!doc":"Since Chrome 23."},"query":{"!type":"fn(queryInfo: ?, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-query","!doc":"Since Chrome 16."},"highlight":{"!type":"fn(highlightInfo: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-highlight","!doc":"Since Chrome 16."},"update":{"!type":"fn(tabId?: integer, updateProperties: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-update","!doc":"Modifies the properties of a tab."},"move":{"!type":"fn(tabIds: ?, moveProperties: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-move","!doc":"Moves one or more tabs to a new position within its window, or to a new window."},"reload":{"!type":"fn(tabId?: integer, reloadProperties?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-reload","!doc":"Since Chrome 16."},"remove":{"!type":"fn(tabIds: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-remove","!doc":"Closes one or more tabs."},"detectLanguage":{"!type":"fn(tabId?: integer, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-detectLanguage","!doc":"Detects the primary language of the content in a tab."},"captureVisibleTab":{"!type":"fn(windowId?: integer, options?: ?, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-captureVisibleTab","!doc":"Captures the visible area of the currently active tab in the specified window."},"executeScript":{"!type":"fn(tabId?: integer, details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-executeScript","!doc":"Injects JavaScript code into a page."},"insertCSS":{"!type":"fn(tabId?: integer, details: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-insertCSS","!doc":"Injects CSS into a page."},"setZoom":{"!type":"fn(tabId?: integer, zoomFactor: number, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-setZoom","!doc":"Since Chrome 42."},"getZoom":{"!type":"fn(tabId?: integer, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-getZoom","!doc":"Since Chrome 42."},"setZoomSettings":{"!type":"fn(tabId?: integer, zoomSettings: ZoomSettings, callback?: function)","!url":"https://developer.chrome.com/extensions/tabs#method-setZoomSettings","!doc":"Since Chrome 42."},"getZoomSettings":{"!type":"fn(tabId?: integer, callback: function)","!url":"https://developer.chrome.com/extensions/tabs#method-getZoomSettings","!doc":"Since Chrome 42."},"onCreated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onCreated"}},"onUpdated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onUpdated"}},"onMoved":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onMoved"}},"onSelectionChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onSelectionChanged"}},"onActiveChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onActiveChanged"}},"onActivated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onActivated"}},"onHighlightChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onHighlightChanged"}},"onHighlighted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onHighlighted"}},"onDetached":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onDetached"}},"onAttached":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onAttached"}},"onRemoved":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onRemoved"}},"onReplaced":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onReplaced"}},"onZoomChange":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/tabs#event-onZoomChange"}}},"topSites":{"get":{"!type":"fn(callback: function)","!url":"https://developer.chrome.com/extensions/topSites#method-get","!doc":"Gets a list of top sites."}},"tts":{"speak":{"!type":"fn(utterance: string, options?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/tts#method-speak","!doc":"Speaks text using a text-to-speech engine."},"stop":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/tts#method-stop","!doc":"Stops any current speech and flushes the queue of any pending utterances."},"pause":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/tts#method-pause","!doc":"Since Chrome 29."},"resume":{"!type":"fn()","!url":"https://developer.chrome.com/extensions/tts#method-resume","!doc":"Since Chrome 29."},"isSpeaking":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/tts#method-isSpeaking","!doc":"Checks whether the engine is currently speaking."},"getVoices":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/tts#method-getVoices","!doc":"Gets an array of all available voices."}},"webNavigation":{"getFrame":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/webNavigation#method-getFrame","!doc":"Retrieves information about the given frame."},"getAllFrames":{"!type":"fn(details: ?, callback: function)","!url":"https://developer.chrome.com/extensions/webNavigation#method-getAllFrames","!doc":"Retrieves information about all frames of a given tab."},"onBeforeNavigate":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onBeforeNavigate"}},"onCommitted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onCommitted"}},"onDOMContentLoaded":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onDOMContentLoaded"}},"onCompleted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onCompleted"}},"onErrorOccurred":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onErrorOccurred"}},"onCreatedNavigationTarget":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onCreatedNavigationTarget"}},"onReferenceFragmentUpdated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onReferenceFragmentUpdated"}},"onTabReplaced":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onTabReplaced"}},"onHistoryStateUpdated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webNavigation#event-onHistoryStateUpdated"}}},"webRequest":{"handlerBehaviorChanged":{"!type":"fn(callback?: function)","!url":"https://developer.chrome.com/extensions/webRequest#method-handlerBehaviorChanged","!doc":"Needs to be called when the behavior of the webRequest handlers has changed to prevent incorrect handling due to caching."},"onBeforeRequest":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onBeforeRequest"}},"onBeforeSendHeaders":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onBeforeSendHeaders"}},"onSendHeaders":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onSendHeaders"}},"onHeadersReceived":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onHeadersReceived"}},"onAuthRequired":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onAuthRequired"}},"onResponseStarted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onResponseStarted"}},"onBeforeRedirect":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onBeforeRedirect"}},"onCompleted":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onCompleted"}},"onErrorOccurred":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webRequest#event-onErrorOccurred"}}},"webstore":{"install":{"!type":"fn(url?: string, successCallback?: function, failureCallback?: function)","!url":"https://developer.chrome.com/extensions/webstore#method-install","!doc":""},"onInstallStageChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webstore#event-onInstallStageChanged"}},"onDownloadProgress":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/webstore#event-onDownloadProgress"}}},"windows":{"get":{"!type":"fn(windowId: integer, getInfo?: ?, callback: function)","!url":"https://developer.chrome.com/extensions/windows#method-get","!doc":"Gets details about a window."},"getCurrent":{"!type":"fn(getInfo?: ?, callback: function)","!url":"https://developer.chrome.com/extensions/windows#method-getCurrent","!doc":"Gets the current window."},"getLastFocused":{"!type":"fn(getInfo?: ?, callback: function)","!url":"https://developer.chrome.com/extensions/windows#method-getLastFocused","!doc":"Gets the window that was most recently focused — typically the window 'on top'."},"getAll":{"!type":"fn(getInfo?: ?, callback: function)","!url":"https://developer.chrome.com/extensions/windows#method-getAll","!doc":"Gets all windows."},"create":{"!type":"fn(createData?: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/windows#method-create","!doc":"Creates (opens) a new browser with any optional sizing, position or default URL provided."},"update":{"!type":"fn(windowId: integer, updateInfo: ?, callback?: function)","!url":"https://developer.chrome.com/extensions/windows#method-update","!doc":"Updates the properties of a window."},"remove":{"!type":"fn(windowId: integer, callback?: function)","!url":"https://developer.chrome.com/extensions/windows#method-remove","!doc":"Removes (closes) a window, and all the tabs inside it."},"onCreated":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/windows#event-onCreated"}},"onRemoved":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/windows#event-onRemoved"}},"onFocusChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/windows#event-onFocusChanged"}}},"declarativeContent":{"onPageChanged":{"addRules\n                  \n                  \n                  chrome":{"declarativeContent":{"onPageChanged":{"removeRules(array of string ruleIdentifiers, function callback)\n                  \n                  \n                  chrome":{"declarativeContent":{"onPageChanged":{"getRules(array of string ruleIdentifiers, function callback)":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/declarativeContent#event-onPageChanged"}}}}}}}}},"proxy":{"onProxyError":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/proxy#event-onProxyError"}}},"storage":{"onChanged":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/storage#event-onChanged"}}},"ttsEngine":{"onSpeak":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/ttsEngine#event-onSpeak"}},"onStop":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/ttsEngine#event-onStop"}},"onPause":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/ttsEngine#event-onPause"}},"onResume":{"addListener":{"!type":"fn(callback: ?)","!url":"https://developer.chrome.com/extensions/ttsEngine#event-onResume"}}}}};
});