/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.ui.preferences;

import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.wp.internal.ui.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WPPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.thym.wp.ui.WPPreferencePages";

    public WPPreferencePage() {
        super(1);
        this.setPreferenceStore(HybridUI.getDefault().getPreferenceStore());
        this.setDescription(Messages.WPPreferencePage_Description);
    }

    public void createFieldEditors() {
        WindowsPhoneSDKDirectoryFieldEditor editor = new WindowsPhoneSDKDirectoryFieldEditor("windowsPhoneSDKLocation", Messages.WPPreferencePage_LocationLabel, this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
    }

    public void init(IWorkbench workbench) {
    }

    private static class WindowsPhoneSDKDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public WindowsPhoneSDKDirectoryFieldEditor(String key, String label, Composite fieldEditorParent) {
            super(key, label, fieldEditorParent);
            this.setEmptyStringAllowed(true);
        }

        protected boolean doCheckState() {
            File file;
            String filename = this.getTextControl().getText();
            if ((filename = filename.trim()).isEmpty()) {
                this.setMessage(Messages.WPPreferencePage_NotSpecifiedWarning, 2);
                return true;
            }
            this.setMessage(null, 0);
            if (!filename.endsWith(File.separator)) {
                filename = String.valueOf(filename) + File.separator;
            }
            if (!(file = new File(filename)).isDirectory()) {
                this.setErrorMessage(Messages.WPPreferencePage_NotDirectoryError);
                return false;
            }
            File fileToValidate = new File(file, "Libraries");
            if (!this.validateFile(fileToValidate)) {
                return false;
            }
            if (!this.validateFile(fileToValidate = new File(fileToValidate, "Microsoft.Phone.Controls.dll"))) {
                return false;
            }
            fileToValidate = new File(file, "Tools");
            return this.validateFile(fileToValidate);
        }

        public void setValidateStrategy(int value) {
            super.setValidateStrategy(0);
        }

        private boolean validateFile(File file) {
            if (!file.exists()) {
                this.setErrorMessage(Messages.WPPreferencePage_NotValidError);
                return false;
            }
            return true;
        }

        private void setMessage(String message, int status) {
            if (message != null) {
                this.getPage().setMessage(message, status);
            } else {
                this.getPage().setMessage(null);
            }
        }
    }
}

