/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.transform;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.tools.vpe.preview.core.mapping.NodeData;
import org.jboss.tools.vpe.preview.core.mapping.VpeElementData;
import org.jboss.tools.vpe.preview.core.template.VpeChildrenInfo;
import org.jboss.tools.vpe.preview.core.template.VpeCreationData;
import org.jboss.tools.vpe.preview.core.template.VpeTemplate;
import org.jboss.tools.vpe.preview.core.transform.VpvTemplateProvider;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpvDomBuilder {
    public static final String ATTR_VPV_ID = "data-vpvid";
    private static long markerId = 0L;
    private VpvTemplateProvider templateProvider;

    public VpvDomBuilder(VpvTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
    }

    public VpvVisualModel buildVisualModel(Document sourceDocument) throws ParserConfigurationException {
        Node visualRoot;
        Document visualDocument = this.createDocument();
        HashMap<Node, Node> sourceVisualMapping = new HashMap<Node, Node>();
        Element documentElement = sourceDocument.getDocumentElement();
        Node node = visualRoot = documentElement != null ? this.convertNode(sourceDocument, documentElement, visualDocument, sourceVisualMapping) : null;
        if (visualRoot != null) {
            this.markSubtree(visualRoot);
            visualDocument.appendChild(visualRoot);
        }
        VpvVisualModel visualModel = new VpvVisualModel(visualDocument, sourceVisualMapping);
        return visualModel;
    }

    private long markSubtree(Node visualParent) {
        if (visualParent.getNodeType() == 1) {
            Element visualParentElement = (Element)visualParent;
            NodeList children = visualParentElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                this.markSubtree(children.item(i));
                ++i;
            }
            long markerId = VpvDomBuilder.getNextMarkerId();
            visualParentElement.setAttribute(ATTR_VPV_ID, Long.toString(markerId));
            return markerId;
        }
        return -1L;
    }

    private Node convertNode(Document sourceDocument, Node sourceNode, Document visualDocument, Map<Node, Node> sourceVisualMapping) {
        List<VpeChildrenInfo> childrenInfos;
        List<NodeData> nodesData;
        VpeElementData elementData;
        VpeTemplate vpeTemplate = this.templateProvider.getTemplate(sourceDocument, sourceNode);
        VpeCreationData creationData = vpeTemplate.create(sourceNode, visualDocument);
        Node visualNode = creationData.getVisualNode();
        if (visualNode != null) {
            sourceVisualMapping.put(sourceNode, visualNode);
        }
        if ((elementData = creationData.getElementData()) != null && (nodesData = elementData.getNodesData()) != null) {
            for (NodeData nodeData : nodesData) {
                if (nodeData.getSourceNode() == null || nodeData.getVisualNode() == null) continue;
                sourceVisualMapping.put(nodeData.getSourceNode(), nodeData.getVisualNode());
            }
        }
        if ((childrenInfos = creationData.getChildrenInfoList()) != null) {
            for (VpeChildrenInfo childrenInfo : childrenInfos) {
                List<Node> sourceChildren = childrenInfo.getSourceChildren();
                Element visualParent = childrenInfo.getVisualParent();
                for (Node sourceChild : sourceChildren) {
                    Node visualChild = this.convertNode(sourceDocument, sourceChild, visualDocument, sourceVisualMapping);
                    if (visualChild == null) continue;
                    visualParent.appendChild(visualChild);
                }
            }
        } else {
            NodeList sourceChildren = sourceNode.getChildNodes();
            int i = 0;
            while (i < sourceChildren.getLength()) {
                Node sourceChild = sourceChildren.item(i);
                Node visualChild = this.convertNode(sourceDocument, sourceChild, visualDocument, sourceVisualMapping);
                if (visualChild != null) {
                    visualNode.appendChild(visualChild);
                }
                ++i;
            }
        }
        return visualNode;
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        return document;
    }

    private static long getNextMarkerId() {
        return markerId++;
    }
}

