/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormColors;

public abstract class Popup
extends Window {
    private FormColors colors;
    private Shell shell;
    private Region lastUsedRegion;
    private Image lastUsedBgImage;
    private boolean listenToDeactivate;
    private boolean listenToParentDeactivate;
    private Listener parentDeactivateListener;
    private Control contentArea;
    private final Point position;

    public Popup(Shell shell, Point position) {
        this(shell, position, 540684);
    }

    public Popup(Shell shell, Point position, int style) {
        super(shell);
        this.setShellStyle(style);
        this.position = position;
        this.colors = new FormColors(shell.getDisplay());
    }

    protected Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(1, 1).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
        newShell.setBackground(this.colors.getBorderColor());
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (Popup.this.listenToDeactivate && event.widget == Popup.this.getShell() && Popup.this.getShell().getShells().length == 0) {
                    Popup.this.asyncClose();
                } else {
                    Popup.this.listenToDeactivate = true;
                }
            }
        });
        this.shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == Popup.this.getShell() && Popup.this.getShell().getShells().length == 0) {
                    Popup.this.listenToDeactivate = true;
                    Popup.this.listenToParentDeactivate = !Util.isMac();
                }
            }
        });
        if ((this.getShellStyle() & 0x4000) != 0 && this.shell.getParent() != null) {
            this.parentDeactivateListener = new Listener(){

                public void handleEvent(Event event) {
                    if (Popup.this.listenToParentDeactivate) {
                        Popup.this.asyncClose();
                    } else {
                        Popup.this.listenToParentDeactivate = Popup.this.listenToDeactivate;
                    }
                }
            };
            this.shell.getParent().addListener(27, this.parentDeactivateListener);
        }
    }

    private void asyncClose() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Popup.this.close();
            }
        });
    }

    public void create() {
        super.create();
        this.addRegion(this.shell);
    }

    private void addRegion(Shell shell) {
        Region region = new Region();
        Point s = shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, 0, 1, 1);
        region.subtract(s.x - 1, 0, 1, 1);
        region.subtract(0, s.y - 1, 1, 1);
        region.subtract(s.x - 1, s.y - 1, 1, 1);
        if (shell.getRegion() != null) {
            shell.getRegion().dispose();
        }
        shell.setRegion(region);
        this.lastUsedRegion = region;
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
            this.shell = this.getShell();
        }
        this.constrainShellSize();
        this.listenToDeactivate = false;
        this.listenToParentDeactivate = false;
        Control initialFocusControl = this.getFocusControl();
        if (initialFocusControl == null) {
            this.shell.setVisible(true);
        } else {
            this.shell.open();
            initialFocusControl.setFocus();
        }
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
        return 0;
    }

    protected Point getInitialLocation(Point size) {
        if (this.position == null) {
            return this.shell.getLocation();
        }
        return this.position;
    }

    protected Control getFocusControl() {
        return this.contentArea;
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 1;
        ((GridLayout)parent.getLayout()).marginHeight = 1;
        final Composite outerCircle = new Composite(parent, 524288);
        outerCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerCircle.setBackgroundMode(2);
        outerCircle.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clArea = outerCircle.getClientArea();
                Popup.this.lastUsedBgImage = new Image((Device)outerCircle.getDisplay(), clArea.width, clArea.height);
                GC gc = new GC((Drawable)Popup.this.lastUsedBgImage);
                this.drawGradient(gc, clArea);
                gc.dispose();
                Image oldBGImage = outerCircle.getBackgroundImage();
                outerCircle.setBackgroundImage(Popup.this.lastUsedBgImage);
                if (oldBGImage != null) {
                    oldBGImage.dispose();
                }
            }

            private void drawGradient(GC gc, Rectangle clArea) {
                gc.setForeground(Popup.this.colors.getBackground());
                gc.setBackground(Popup.this.colors.getColor("org.eclipse.ui.forms.TB_BG"));
                gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        outerCircle.setLayout((Layout)layout);
        Composite outerContentCircle = new Composite(outerCircle, 0);
        outerContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outerContentCircle.setLayout((Layout)layout);
        outerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerContentCircle.setBackground(outerCircle.getBackground());
        Composite middleContentCircle = new Composite(outerContentCircle, 524288);
        middleContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 1;
        middleContentCircle.setLayout((Layout)layout);
        middleContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        middleContentCircle.setBackground(this.colors.getBorderColor());
        Composite innerContent = new Composite(middleContentCircle, 524288);
        innerContent.setLayoutData((Object)new GridData(4, 4, true, true));
        innerContent.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        innerContent.setLayout((Layout)layout);
        innerContent.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.contentArea = this.createContentArea(innerContent);
        this.setNullBackground(outerCircle);
        return outerCircle;
    }

    private void setNullBackground(Composite outerCircle) {
        Control[] controlArray = outerCircle.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(null);
            if (c instanceof Composite) {
                this.setNullBackground((Composite)c);
            }
            ++n2;
        }
    }

    public boolean close() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return true;
        }
        if (this.lastUsedRegion != null) {
            this.lastUsedRegion.dispose();
        }
        if (this.lastUsedBgImage != null && !this.lastUsedBgImage.isDisposed()) {
            this.lastUsedBgImage.dispose();
        }
        if (this.parentDeactivateListener != null) {
            this.getShell().getParent().removeListener(27, this.parentDeactivateListener);
            this.parentDeactivateListener = null;
        }
        return super.close();
    }
}

