/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.ToolPaletteImageDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeMoveEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.util.CollectionsUtil;

public final class DiagramNodeTemplate
extends SapphirePart {
    private SapphireDiagramEditorPagePart diagramEditor;
    private IDiagramNodeDef definition;
    private Element modelElement;
    private String propertyName;
    private ListProperty modelProperty;
    private JavaType modelElementType;
    private String toolPaletteLabel;
    private String toolPaletteDesc;
    private List<FunctionResult> toolPaletteImageFunctionResults;
    private DiagramEmbeddedConnectionTemplate embeddedConnTemplate;
    private Listener modelPropertyListener;
    private Listener nodePartListener;
    private Set<DiagramNodeTemplateListener> listeners;
    private List<DiagramNodePart> diagramNodes;

    @Override
    public void init() {
        this.diagramEditor = (SapphireDiagramEditorPagePart)this.parent();
        this.modelElement = this.getModelElement();
        this.definition = (IDiagramNodeDef)((SapphirePart)this).definition;
        if (this.definition.getToolPaletteLabel().content() != null) {
            ValueProperty tpLabelProperty = IDiagramNodeDef.PROP_TOOL_PALETTE_LABEL;
            this.toolPaletteLabel = tpLabelProperty.getLocalizationService().text((String)this.definition.getToolPaletteLabel().content(), CapitalizationType.TITLE_STYLE, false);
        }
        this.toolPaletteDesc = (String)this.definition.getToolPaletteDescription().content();
        this.diagramNodes = new ArrayList<DiagramNodePart>();
        this.listeners = new CopyOnWriteArraySet<DiagramNodeTemplateListener>();
        this.propertyName = (String)this.definition.getProperty().content();
        this.modelProperty = (ListProperty)this.resolve(this.modelElement, this.propertyName);
        this.modelElementType = (JavaType)this.definition.getElementType().target();
        this.initNodePartListener();
        ElementList list = this.modelElement.property(this.modelProperty);
        for (Element listEntryModelElement : list) {
            if (this.modelElementType == null) {
                this.createNewNodePart(listEntryModelElement);
                continue;
            }
            Class cl = (Class)this.modelElementType.artifact();
            if (cl != null && !cl.isAssignableFrom(listEntryModelElement.getClass())) continue;
            this.createNewNodePart(listEntryModelElement);
        }
        this.toolPaletteImageFunctionResults = new ArrayList<FunctionResult>();
        ElementList<ToolPaletteImageDef> imageDefs = this.definition.getToolPaletteImages();
        for (ToolPaletteImageDef imageDef : imageDefs) {
            FunctionResult fr = this.initExpression((Function)imageDef.getToolPaletteImage().content(), ImageData.class, null, new Runnable(){

                @Override
                public void run() {
                    DiagramNodeTemplate.this.broadcast(new SapphirePart.ImageChangedEvent(DiagramNodeTemplate.this));
                }
            });
            this.toolPaletteImageFunctionResults.add(fr);
        }
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramNodeTemplate.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
    }

    private void initNodePartListener() {
        this.nodePartListener = new FilteredListener<DiagramNodeMoveEvent>(){

            public void handleTypedEvent(DiagramNodeMoveEvent event) {
                DiagramNodeTemplate.this.notifyNodeMoveEvent(event);
            }
        };
    }

    public void initEmbeddedConnections() {
        if (!this.definition.getEmbeddedConnections().isEmpty()) {
            IDiagramExplicitConnectionBindingDef embeddedConnDef = (IDiagramExplicitConnectionBindingDef)this.definition.getEmbeddedConnections().get(0);
            this.embeddedConnTemplate = new DiagramEmbeddedConnectionTemplate(embeddedConnDef);
            IDiagramConnectionDef connDef = this.diagramEditor.getDiagramConnectionDef((String)embeddedConnDef.getConnectionId().content());
            this.embeddedConnTemplate.init(this, this.modelElement, connDef, Collections.emptyMap());
            this.embeddedConnTemplate.initialize();
        }
    }

    @Override
    public IDiagramNodeDef definition() {
        return this.definition;
    }

    public List<DiagramNodePart> getDiagramNodes() {
        return this.diagramNodes;
    }

    public String getToolPaletteLabel() {
        return this.toolPaletteLabel;
    }

    public String getToolPaletteDesc() {
        return this.toolPaletteDesc;
    }

    public List<ImageData> getToolPaletteImages() {
        ArrayList<ImageData> imageDatas = new ArrayList<ImageData>();
        for (FunctionResult fr : this.toolPaletteImageFunctionResults) {
            imageDatas.add((ImageData)fr.value());
        }
        return imageDatas;
    }

    public String getNodeTypeId() {
        return (String)this.definition.getId().content();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("Sapphire.Diagram.Node");
        ret.add("Sapphire.Diagram");
        return ret;
    }

    public DiagramNodePart createNewDiagramNode() {
        Class cl;
        Element newElement = null;
        ElementList list = this.modelElement.property(this.modelProperty);
        newElement = this.modelElementType == null ? list.insert() : ((cl = (Class)this.modelElementType.artifact()) != null ? list.insert(cl) : list.insert());
        DiagramNodePart newNodePart = this.getNodePart(newElement);
        return newNodePart;
    }

    public void deleteNode(DiagramNodePart nodePart) {
        this.notifyNodeAboutToBeDeleted(nodePart);
        Element nodeModel = nodePart.getLocalModelElement();
        ElementList list = (ElementList)nodeModel.parent();
        list.remove((Object)nodeModel);
    }

    public PropertyDef getModelProperty() {
        return this.modelProperty;
    }

    public ElementType getNodeType() {
        if (this.modelElementType == null) {
            return this.modelProperty.getType();
        }
        Class cl = (Class)this.modelElementType.artifact();
        return ElementType.read((Class)cl);
    }

    public DiagramEmbeddedConnectionTemplate getEmbeddedConnectionTemplate() {
        return this.embeddedConnTemplate;
    }

    public void addModelListener() {
        this.modelElement.attach(this.modelPropertyListener, this.propertyName);
    }

    public void removeModelLister() {
        this.modelElement.detach(this.modelPropertyListener, this.propertyName);
    }

    public void addTemplateListener(DiagramNodeTemplateListener listener) {
        this.listeners.add(listener);
    }

    public void removeTemplateListener(DiagramNodeTemplateListener listener) {
        this.listeners.remove(listener);
    }

    private void handleModelPropertyChange(PropertyEvent event) {
        DiagramNodePart nodePart;
        ElementList tempList = (ElementList)event.property();
        ArrayList<Element> newList = new ArrayList<Element>();
        for (Element ele : tempList) {
            if (this.modelElementType == null) {
                newList.add(ele);
                continue;
            }
            Class cl = (Class)this.modelElementType.artifact();
            if (cl != null && !cl.isAssignableFrom(ele.getClass())) continue;
            newList.add(ele);
        }
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        ArrayList<Element> oldList = new ArrayList<Element>(nodeParts.size());
        for (DiagramNodePart nodePart2 : nodeParts) {
            oldList.add(nodePart2.getLocalModelElement());
        }
        List deletedNodes = CollectionsUtil.removedBasedOnEntryIdentity(oldList, newList);
        List newNodes = CollectionsUtil.removedBasedOnEntryIdentity(newList, oldList);
        for (Element deletedNode : deletedNodes) {
            nodePart = this.getNodePart(deletedNode);
            if (nodePart == null) continue;
            this.notifyNodeDelete(nodePart);
            nodePart.dispose();
            nodePart.detach(this.nodePartListener);
            this.diagramNodes.remove(nodePart);
            if (this.embeddedConnTemplate == null) continue;
            this.embeddedConnTemplate.removeConnectionParts(deletedNode);
        }
        for (Element newNode : newNodes) {
            nodePart = this.createNewNodePart(newNode);
            if (this.visible()) {
                this.notifyNodeAdd(nodePart);
            }
            if (this.embeddedConnTemplate != null) {
                this.embeddedConnTemplate.refreshConnections(newNode);
            }
            if (!this.visible()) continue;
            this.notifyNodeAdded(nodePart);
        }
    }

    public DiagramNodePart getNodePart(Element element) {
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            if (nodePart.getLocalModelElement() != element) continue;
            return nodePart;
        }
        return null;
    }

    private DiagramNodePart createNewNodePart(Element element) {
        DiagramNodePart newNode = new DiagramNodePart();
        newNode.init(this, element, this.definition, Collections.emptyMap());
        newNode.initialize();
        newNode.attach(this.nodePartListener);
        this.diagramNodes.add(newNode);
        if (this.embeddedConnTemplate != null) {
            this.embeddedConnTemplate.addModelListener(element);
        }
        return newNode;
    }

    public void hideAllNodeParts() {
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            this.notifyNodeDelete(nodePart);
        }
    }

    public void showAllNodeParts() {
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            this.notifyNodeAdd(nodePart);
        }
    }

    @Override
    public void dispose() {
        this.removeModelLister();
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            this.notifyNodeDelete(nodePart);
            nodePart.dispose();
        }
        this.diagramNodes.clear();
        if (this.embeddedConnTemplate != null) {
            this.embeddedConnTemplate.dispose();
        }
        for (FunctionResult fr : this.toolPaletteImageFunctionResults) {
            fr.dispose();
        }
    }

    public SapphireDiagramEditorPagePart getDiagramEditorPart() {
        return this.diagramEditor;
    }

    private void notifyNodeAdd(DiagramNodePart nodePart) {
        for (DiagramNodeTemplateListener listener : this.listeners) {
            listener.handleNodeAdd(nodePart);
        }
    }

    private void notifyNodeAdded(DiagramNodePart nodePart) {
        for (DiagramNodeTemplateListener listener : this.listeners) {
            listener.handlePostNodeAdd(nodePart);
        }
    }

    private void notifyNodeAboutToBeDeleted(DiagramNodePart nodePart) {
        for (DiagramNodeTemplateListener listener : this.listeners) {
            listener.handlePreNodeDelete(nodePart);
        }
    }

    private void notifyNodeDelete(DiagramNodePart nodePart) {
        for (DiagramNodeTemplateListener listener : this.listeners) {
            listener.handleNodeDelete(nodePart);
        }
    }

    private void notifyNodeMoveEvent(DiagramNodeMoveEvent event) {
        for (DiagramNodeTemplateListener listener : this.listeners) {
            listener.handleNodeMove(event);
        }
    }

    public static abstract class DiagramNodeTemplateListener {
        public void handleNodeAdd(DiagramNodePart nodePart) {
        }

        public void handlePostNodeAdd(DiagramNodePart nodePart) {
        }

        public void handleNodeDelete(DiagramNodePart nodePart) {
        }

        public void handlePreNodeDelete(DiagramNodePart nodePart) {
        }

        public void handleNodeMove(DiagramNodeMoveEvent event) {
        }
    }
}

