/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.servlet.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.tools.browsersim.eclipse.Activator;

public class CordovaJsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final String MIME_TYPE = "application/javascript";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String DEFAULT_CORDOVA_JS = "/ripple/cordova/cordova-3.5.0.js";
    private String cordovaJsLocation;

    public CordovaJsServlet(String cordovaJsLocation) {
        this.cordovaJsLocation = cordovaJsLocation;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.cordovaJsLocation == null) {
            response.sendRedirect(DEFAULT_CORDOVA_JS);
            return;
        }
        File cordovaJsFile = new File(this.cordovaJsLocation);
        if (!cordovaJsFile.exists()) {
            response.sendRedirect(DEFAULT_CORDOVA_JS);
            return;
        }
        response.reset();
        response.setBufferSize(10240);
        response.setContentType(MIME_TYPE);
        response.setHeader(CONTENT_LENGTH, String.valueOf(cordovaJsFile.length()));
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(new FileInputStream(cordovaJsFile), 10240);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 10240);
            byte[] buffer = new byte[10240];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            CordovaJsServlet.close(output);
            CordovaJsServlet.close(input);
            throw throwable;
        }
        CordovaJsServlet.close(output);
        CordovaJsServlet.close(input);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
    }
}

