/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.internal.util;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.StringTokenizer;

public class HttpUtils {
    private HttpUtils() {
    }

    public static boolean isHtmlContentType(String acceptedContentTypes) {
        if (acceptedContentTypes == null) {
            return false;
        }
        int location = acceptedContentTypes.indexOf(";");
        String contentTypes = location != -1 ? acceptedContentTypes.substring(0, location) : acceptedContentTypes;
        StringTokenizer tokenizer = new StringTokenizer(contentTypes, ",");
        while (tokenizer.hasMoreElements()) {
            String acceptedContentType = tokenizer.nextToken();
            if (!"text/html".equals(acceptedContentType) && !"application/xhtml+xml".equals(acceptedContentType) && !"application/xml".equals(acceptedContentType)) continue;
            return true;
        }
        return false;
    }

    public static Charset getContentCharSet(String contentType, String defaultCharsetName) {
        if (contentType != null) {
            StringTokenizer stk = new StringTokenizer(contentType, ";");
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken().toLowerCase().replace(" ", "");
                if (!token.startsWith("charset=")) continue;
                StringTokenizer tokenSplitter = new StringTokenizer(token, "=");
                tokenSplitter.nextToken();
                String value = tokenSplitter.hasMoreTokens() ? tokenSplitter.nextToken() : null;
                return Charset.forName(value.toUpperCase());
            }
        }
        try {
            return Charset.forName(defaultCharsetName);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return Charset.forName("UTF-8");
        }
    }
}

