/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.IType;
import org.jboss.tools.hibernate.runtime.spi.ITypeFactory;

public abstract class AbstractTypeFactoryFacade
extends AbstractFacade
implements ITypeFactory {
    protected Map<IType, String> typeFormats = null;
    protected Object typeRegistry = null;

    public AbstractTypeFactoryFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public IType getBooleanType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BOOLEAN", null));
    }

    public IType getByteType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BYTE", null));
    }

    public IType getBigIntegerType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BIG_INTEGER", null));
    }

    public IType getShortType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "SHORT", null));
    }

    public IType getCalendarType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CALENDAR", null));
    }

    public IType getCalendarDateType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CALENDAR_DATE", null));
    }

    public IType getIntegerType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "INTEGER", null));
    }

    public IType getBigDecimalType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BIG_DECIMAL", null));
    }

    public IType getCharacterType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CHARACTER", null));
    }

    public IType getClassType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CLASS", null));
    }

    public IType getCurrencyType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CURRENCY", null));
    }

    public IType getDateType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "DATE", null));
    }

    public IType getDoubleType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "DOUBLE", null));
    }

    public IType getFloatType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "FLOAT", null));
    }

    public IType getLocaleType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "LOCALE", null));
    }

    public IType getLongType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "LONG", null));
    }

    public IType getStringType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "STRING", null));
    }

    public IType getTextType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TEXT", null));
    }

    public IType getTimeType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TIME", null));
    }

    public IType getTimestampType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TIMESTAMP", null));
    }

    public IType getTimezoneType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TIMEZONE", null));
    }

    public IType getTrueFalseType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TRUE_FALSE", null));
    }

    public IType getYesNoType() {
        return this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "YES_NO", null));
    }

    public Map<IType, String> getTypeFormats() {
        if (this.typeFormats == null) {
            this.initializeTypeFormats();
        }
        return this.typeFormats;
    }

    public IType getNamedType(String typeName) {
        Object typeTarget = Util.invokeMethod(this.getTypeRegistry(), "getRegisteredType", new Class[]{String.class}, new Object[]{typeName});
        return this.getFacadeFactory().createType(typeTarget);
    }

    public IType getBasicType(String typeName) {
        return this.getNamedType(typeName);
    }

    protected Class<?> getStandardBasicTypesClass() {
        return Util.getClass(this.getStandardBasicTypesClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getStandardBasicTypesClassName() {
        return "org.hibernate.type.StandardBasicTypes";
    }

    protected void initializeTypeFormats() {
        this.typeFormats = new HashMap<IType, String>();
        this.addTypeFormat(this.getBooleanType(), Boolean.TRUE);
        this.addTypeFormat(this.getByteType(), (byte)42);
        this.addTypeFormat(this.getBigIntegerType(), BigInteger.valueOf(42L));
        this.addTypeFormat(this.getShortType(), (short)42);
        this.addTypeFormat(this.getCalendarType(), new GregorianCalendar());
        this.addTypeFormat(this.getCalendarDateType(), new GregorianCalendar());
        this.addTypeFormat(this.getIntegerType(), 42);
        this.addTypeFormat(this.getBigDecimalType(), new BigDecimal(42.0));
        this.addTypeFormat(this.getCharacterType(), Character.valueOf('h'));
        this.addTypeFormat(this.getClassType(), ITable.class);
        this.addTypeFormat(this.getCurrencyType(), Currency.getInstance(Locale.getDefault()));
        this.addTypeFormat(this.getDateType(), new Date());
        this.addTypeFormat(this.getDoubleType(), 42.42);
        this.addTypeFormat(this.getFloatType(), Float.valueOf(42.42f));
        this.addTypeFormat(this.getLocaleType(), Locale.getDefault());
        this.addTypeFormat(this.getLongType(), 42L);
        this.addTypeFormat(this.getStringType(), "a string");
        this.addTypeFormat(this.getTextType(), "a text");
        this.addTypeFormat(this.getTimeType(), new Date());
        this.addTypeFormat(this.getTimestampType(), new Date());
        this.addTypeFormat(this.getTimezoneType(), TimeZone.getDefault());
        this.addTypeFormat(this.getTrueFalseType(), Boolean.TRUE);
        this.addTypeFormat(this.getYesNoType(), Boolean.TRUE);
    }

    protected void addTypeFormat(IType type, Object value) {
        this.typeFormats.put(type, type.toString(value));
    }

    protected Object getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = Util.getInstance(this.getTypeRegistryClassName(), this.getFacadeFactoryClassLoader());
        }
        return this.typeRegistry;
    }

    protected String getTypeRegistryClassName() {
        return "org.hibernate.type.BasicTypeRegistry";
    }
}

