/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.HashSet;
import java.util.Iterator;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IForeignKey;
import org.jboss.tools.hibernate.runtime.spi.IPrimaryKey;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.IValue;

public abstract class AbstractTableFacade
extends AbstractFacade
implements ITable {
    protected HashSet<IColumn> columns = null;
    protected IPrimaryKey primaryKey = null;
    protected HashSet<IForeignKey> foreignKeys = null;
    protected IValue identifierValue = null;

    public AbstractTableFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public String getName() {
        return (String)Util.invokeMethod(this.getTarget(), "getName", new Class[0], new Object[0]);
    }

    public void addColumn(IColumn column) {
        assert (column instanceof IFacade);
        Object columnTarget = Util.invokeMethod(column, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "addColumn", new Class[]{this.getColumnClass()}, new Object[]{columnTarget});
        this.columns = null;
    }

    public void setPrimaryKey(IPrimaryKey pk) {
        assert (pk instanceof IFacade);
        Object pkTarget = Util.invokeMethod(pk, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setPrimaryKey", new Class[]{this.getPrimaryKeyClass()}, new Object[]{pkTarget});
        this.primaryKey = pk;
    }

    public String getCatalog() {
        return (String)Util.invokeMethod(this.getTarget(), "getCatalog", new Class[0], new Object[0]);
    }

    public String getSchema() {
        return (String)Util.invokeMethod(this.getTarget(), "getSchema", new Class[0], new Object[0]);
    }

    public IPrimaryKey getPrimaryKey() {
        Object targetPrimaryKey;
        if (this.primaryKey == null && (targetPrimaryKey = Util.invokeMethod(this.getTarget(), "getPrimaryKey", new Class[0], new Object[0])) != null) {
            this.primaryKey = this.getFacadeFactory().createPrimaryKey(targetPrimaryKey);
        }
        return this.primaryKey;
    }

    public Iterator<IColumn> getColumnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    public Iterator<IForeignKey> getForeignKeyIterator() {
        if (this.foreignKeys == null) {
            this.initializeForeignKeys();
        }
        return this.foreignKeys.iterator();
    }

    public String getComment() {
        return (String)Util.invokeMethod(this.getTarget(), "getComment", new Class[0], new Object[0]);
    }

    public String getRowId() {
        return (String)Util.invokeMethod(this.getTarget(), "getRowId", new Class[0], new Object[0]);
    }

    public String getSubselect() {
        return (String)Util.invokeMethod(this.getTarget(), "getSubselect", new Class[0], new Object[0]);
    }

    public boolean hasDenormalizedTables() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "hasDenormalizedTables", new Class[0], new Object[0]);
    }

    public boolean isAbstract() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isAbstract", new Class[0], new Object[0]);
    }

    public boolean isAbstractUnionTable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isAbstractUnionTable", new Class[0], new Object[0]);
    }

    public boolean isPhysicalTable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isPhysicalTable", new Class[0], new Object[0]);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o != null & o.getClass() == this.getClass()) {
            result = ((AbstractTableFacade)o).getTarget().equals(this.getTarget());
        }
        return result;
    }

    public IValue getIdentifierValue() {
        Object targetIdentifierValue;
        if (this.identifierValue == null && (targetIdentifierValue = Util.invokeMethod(this.getTarget(), "getIdentifierValue", new Class[0], new Object[0])) != null) {
            this.identifierValue = this.getFacadeFactory().createValue(targetIdentifierValue);
        }
        return this.identifierValue;
    }

    protected Class<?> getColumnClass() {
        return Util.getClass(this.getColumnClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getPrimaryKeyClass() {
        return Util.getClass(this.getPrimaryKeyClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getColumnClassName() {
        return "org.hibernate.mapping.Column";
    }

    protected String getPrimaryKeyClassName() {
        return "org.hibernate.mapping.PrimaryKey";
    }

    protected void initializeColumns() {
        this.columns = new HashSet();
        Iterator targetColumnIterator = (Iterator)Util.invokeMethod(this.getTarget(), "getColumnIterator", new Class[0], new Object[0]);
        while (targetColumnIterator.hasNext()) {
            this.columns.add(this.getFacadeFactory().createColumn(targetColumnIterator.next()));
        }
    }

    protected void initializeForeignKeys() {
        this.foreignKeys = new HashSet();
        Iterator targetForeignKeyIterator = (Iterator)Util.invokeMethod(this.getTarget(), "getForeignKeyIterator", new Class[0], new Object[0]);
        while (targetForeignKeyIterator.hasNext()) {
            this.foreignKeys.add(this.getFacadeFactory().createForeignKey(targetForeignKeyIterator.next()));
        }
    }
}

