/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.Iterator;
import org.jboss.tools.hibernate.runtime.common.AbstractPersistentClassFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.IValue;

public abstract class AbstractSpecialRootClassFacade
extends AbstractPersistentClassFacade {
    protected IProperty property;
    protected IProperty parentProperty;

    public AbstractSpecialRootClassFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    protected void generate() {
        if (this.property == null) {
            return;
        }
        IValue propVal = this.property.getValue();
        IValue component = null;
        if (propVal != null && propVal.isCollection()) {
            IValue collection = propVal;
            component = collection.getElement();
        } else if (propVal.isComponent()) {
            component = propVal;
        }
        if (component != null) {
            this.setClassName(component.getComponentClassName());
            this.setEntityName(component.getComponentClassName());
            IPersistentClass ownerClass = component.getOwner();
            if (component.getParentProperty() != null) {
                Object newProperty = Util.getInstance(this.getPropertyClassName(), this.getFacadeFactoryClassLoader());
                this.parentProperty = this.getFacadeFactory().createProperty(newProperty);
                this.parentProperty.setName(component.getParentProperty());
                this.parentProperty.setPersistentClass(ownerClass);
            }
            Iterator iterator = component.getPropertyIterator();
            while (iterator.hasNext()) {
                IProperty property = (IProperty)iterator.next();
                if (property == null) continue;
                this.addProperty(property);
            }
        }
    }

    @Override
    public IProperty getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public IProperty getProperty() {
        return this.property;
    }

    @Override
    public boolean isInstanceOfSpecialRootClass() {
        return true;
    }

    @Override
    protected String getPropertyClassName() {
        return "org.hibernate.mapping.Property";
    }
}

