/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.IType;
import org.jboss.tools.hibernate.runtime.spi.IValue;

public abstract class AbstractPropertyFacade
extends AbstractFacade
implements IProperty {
    protected IValue value = null;
    protected IPersistentClass persistentClass = null;
    protected IType type = null;

    public AbstractPropertyFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public IValue getValue() {
        Object targetValue;
        if (this.value == null && (targetValue = Util.invokeMethod(this.getTarget(), "getValue", new Class[0], new Object[0])) != null) {
            this.value = this.getFacadeFactory().createValue(targetValue);
        }
        return this.value;
    }

    public void setName(String name) {
        Util.invokeMethod(this.getTarget(), "setName", new Class[]{String.class}, new Object[]{name});
    }

    public void setPersistentClass(IPersistentClass persistentClass) {
        Object persistentClassTarget = Util.invokeMethod(persistentClass, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setPersistentClass", new Class[]{this.getPersistentClassClass()}, new Object[]{persistentClassTarget});
        this.persistentClass = persistentClass;
    }

    public IPersistentClass getPersistentClass() {
        Object targetPersistentClass;
        if (this.persistentClass == null && (targetPersistentClass = Util.invokeMethod(this.getTarget(), "getPersistentClass", new Class[0], new Object[0])) != null) {
            this.persistentClass = this.getFacadeFactory().createPersistentClass(targetPersistentClass);
        }
        return this.persistentClass;
    }

    public boolean isComposite() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isComposite", new Class[0], new Object[0]);
    }

    public String getPropertyAccessorName() {
        return (String)Util.invokeMethod(this.getTarget(), "getPropertyAccessorName", new Class[0], new Object[0]);
    }

    public String getName() {
        return (String)Util.invokeMethod(this.getTarget(), "getName", new Class[0], new Object[0]);
    }

    public String getNodeName() {
        return (String)Util.invokeMethod(this.getTarget(), "getNodeName", new Class[0], new Object[0]);
    }

    public boolean classIsPropertyClass() {
        return this.getTarget().getClass() == this.getPropertyClass();
    }

    public IType getType() {
        Object targetType;
        if (this.type == null && (targetType = Util.invokeMethod(this.getTarget(), "getType", new Class[0], new Object[0])) != null) {
            this.type = this.getFacadeFactory().createType(targetType);
        }
        return this.type;
    }

    public void setValue(IValue value) {
        Object valueTarget = Util.invokeMethod(value, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setValue", new Class[]{this.getValueClass()}, new Object[]{valueTarget});
        this.value = value;
    }

    public void setPropertyAccessorName(String string) {
        Util.invokeMethod(this.getTarget(), "setPropertyAccessorName", new Class[]{String.class}, new Object[]{string});
    }

    public void setCascade(String string) {
        Util.invokeMethod(this.getTarget(), "setCascade", new Class[]{String.class}, new Object[]{string});
    }

    public boolean isBackRef() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isBackRef", new Class[0], new Object[0]);
    }

    public boolean isSelectable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isSelectable", new Class[0], new Object[0]);
    }

    public boolean isInsertable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isInsertable", new Class[0], new Object[0]);
    }

    public boolean isUpdateable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isUpdateable", new Class[0], new Object[0]);
    }

    public String getCascade() {
        return (String)Util.invokeMethod(this.getTarget(), "getCascade", new Class[0], new Object[0]);
    }

    public boolean isLazy() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isLazy", new Class[0], new Object[0]);
    }

    public boolean isOptional() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isOptional", new Class[0], new Object[0]);
    }

    public boolean isNaturalIdentifier() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isNaturalIdentifier", new Class[0], new Object[0]);
    }

    public boolean isOptimisticLocked() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isOptimisticLocked", new Class[0], new Object[0]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractPropertyFacade)) {
            return false;
        }
        return this.getTarget().equals(((AbstractPropertyFacade)o).getTarget());
    }

    protected Class<?> getPersistentClassClass() {
        return Util.getClass(this.getPersistentClassClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getPropertyClass() {
        return Util.getClass(this.getPropertyClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getValueClass() {
        return Util.getClass(this.getValueClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getPersistentClassClassName() {
        return "org.hibernate.mapping.PersistentClass";
    }

    protected String getPropertyClassName() {
        return "org.hibernate.mapping.Property";
    }

    protected String getValueClassName() {
        return "org.hibernate.mapping.Value";
    }
}

