/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IPrimaryKey;
import org.jboss.tools.hibernate.runtime.spi.ITable;

public abstract class AbstractPrimaryKeyFacade
extends AbstractFacade
implements IPrimaryKey {
    protected List<IColumn> columns = null;
    protected ITable table = null;

    public AbstractPrimaryKeyFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public void addColumn(IColumn column) {
        assert (column instanceof IFacade);
        Object columnTarget = Util.invokeMethod(column, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "addColumn", new Class[]{this.getColumnClass()}, new Object[]{columnTarget});
        this.columns = null;
    }

    public int getColumnSpan() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getColumnSpan", new Class[0], new Object[0]);
    }

    public List<IColumn> getColumns() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns;
    }

    public IColumn getColumn(int i) {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.get(i);
    }

    public Iterator<IColumn> columnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    public boolean containsColumn(IColumn column) {
        assert (column instanceof IFacade);
        Object columnTarget = Util.invokeMethod(column, "getTarget", new Class[0], new Object[0]);
        return (Boolean)Util.invokeMethod(this.getTarget(), "containsColumn", new Class[]{this.getColumnClass()}, new Object[]{columnTarget});
    }

    public String getName() {
        return (String)Util.invokeMethod(this.getTarget(), "getName", new Class[0], new Object[0]);
    }

    public ITable getTable() {
        Object targetTable;
        if (this.table == null && (targetTable = Util.invokeMethod(this.getTarget(), "getTable", new Class[0], new Object[0])) != null) {
            this.table = this.getFacadeFactory().createTable(targetTable);
        }
        return this.table;
    }

    protected Class<?> getColumnClass() {
        return Util.getClass(this.getColumnClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getColumnClassName() {
        return "org.hibernate.mapping.Column";
    }

    protected void initializeColumns() {
        this.columns = new ArrayList<IColumn>();
        List targetColumns = (List)Util.invokeMethod(this.getTarget(), "getColumns", new Class[0], new Object[0]);
        Iterator origin = targetColumns.iterator();
        while (origin.hasNext()) {
            this.columns.add(this.getFacadeFactory().createColumn(origin.next()));
        }
    }
}

