/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IJoin;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.IValue;

public abstract class AbstractPersistentClassFacade
extends AbstractFacade
implements IPersistentClass {
    protected IProperty identifierProperty = null;
    protected IPersistentClass rootClass = null;
    protected HashSet<IProperty> propertyClosures = null;
    protected IPersistentClass superClass = null;
    protected HashMap<String, IProperty> properties = null;
    protected ITable table = null;
    protected IValue discriminator = null;
    protected IValue identifier = null;
    protected HashSet<IJoin> joins = null;
    protected IProperty version = null;
    protected HashSet<IPersistentClass> subclasses = null;
    protected ITable rootTable = null;

    public AbstractPersistentClassFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public String getClassName() {
        return (String)Util.invokeMethod(this.getTarget(), "getClassName", new Class[0], new Object[0]);
    }

    public String getEntityName() {
        return (String)Util.invokeMethod(this.getTarget(), "getEntityName", new Class[0], new Object[0]);
    }

    public boolean isAssignableToRootClass() {
        return this.getRootClassClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isRootClass() {
        return this.getTarget().getClass() == this.getRootClassClass();
    }

    public IProperty getIdentifierProperty() {
        Object targetIdentifierProperty;
        if (this.identifierProperty == null && (targetIdentifierProperty = Util.invokeMethod(this.getTarget(), "getIdentifierProperty", new Class[0], new Object[0])) != null) {
            this.identifierProperty = this.getFacadeFactory().createProperty(targetIdentifierProperty);
        }
        return this.identifierProperty;
    }

    public boolean hasIdentifierProperty() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "hasIdentifierProperty", new Class[0], new Object[0]);
    }

    public boolean isInstanceOfRootClass() {
        return this.getRootClassClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isInstanceOfSubclass() {
        return this.getSubclassClass().isAssignableFrom(this.getTarget().getClass());
    }

    public String getNodeName() {
        return (String)Util.invokeMethod(this.getTarget(), "getNodeName", new Class[0], new Object[0]);
    }

    public IPersistentClass getRootClass() {
        Object targetRootClass;
        if (this.rootClass == null && (targetRootClass = Util.invokeMethod(this.getTarget(), "getRootClass", new Class[0], new Object[0])) != null) {
            this.rootClass = this.getFacadeFactory().createPersistentClass(targetRootClass);
        }
        return this.rootClass;
    }

    public Iterator<IProperty> getPropertyClosureIterator() {
        if (this.propertyClosures == null) {
            this.initializePropertyClosures();
        }
        return this.propertyClosures.iterator();
    }

    public IPersistentClass getSuperclass() {
        Object targetSuperclass;
        if (this.superClass != null && (targetSuperclass = Util.invokeMethod(this.getTarget(), "getSuperclass", new Class[0], new Object[0])) != null) {
            this.superClass = this.getFacadeFactory().createPersistentClass(targetSuperclass);
        }
        return this.superClass;
    }

    public Iterator<IProperty> getPropertyIterator() {
        if (this.properties == null) {
            this.initializeProperties();
        }
        return this.properties.values().iterator();
    }

    public IProperty getProperty(String string) {
        if (this.properties == null) {
            this.initializeProperties();
        }
        return this.properties.get(string);
    }

    public ITable getTable() {
        Object targetTable;
        if (this.table == null && (targetTable = Util.invokeMethod(this.getTarget(), "getTable", new Class[0], new Object[0])) != null) {
            this.table = this.getFacadeFactory().createTable(targetTable);
        }
        return this.table;
    }

    public Boolean isAbstract() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isAbstract", new Class[0], new Object[0]);
    }

    public IValue getDiscriminator() {
        if (this.discriminator == null) {
            Object targetDiscriminator = Util.invokeMethod(this.getTarget(), "getDiscriminator", new Class[0], new Object[0]);
            if (this.discriminator != null) {
                this.discriminator = this.getFacadeFactory().createValue(targetDiscriminator);
            }
        }
        return this.discriminator;
    }

    public IValue getIdentifier() {
        Object targetIdentifier;
        if (this.identifier == null && (targetIdentifier = Util.invokeMethod(this.getTarget(), "getIdentifier", new Class[0], new Object[0])) != null) {
            this.identifier = this.getFacadeFactory().createValue(targetIdentifier);
        }
        return this.identifier;
    }

    public Iterator<IJoin> getJoinIterator() {
        if (this.joins == null) {
            this.initializeJoins();
        }
        return this.joins.iterator();
    }

    public IProperty getVersion() {
        if (this.version == null) {
            Object targetVersion = Util.invokeMethod(this.getTarget(), "getVersion", new Class[0], new Object[0]);
            if (this.version != null) {
                this.version = this.getFacadeFactory().createProperty(targetVersion);
            }
        }
        return this.version;
    }

    public void setClassName(String className) {
        Util.invokeMethod(this.getTarget(), "setClassName", new Class[]{String.class}, new Object[]{className});
    }

    public void setEntityName(String entityName) {
        Util.invokeMethod(this.getTarget(), "setEntityName", new Class[]{String.class}, new Object[]{entityName});
    }

    public void setDiscriminatorValue(String value) {
        Util.invokeMethod(this.getTarget(), "setDiscriminatorValue", new Class[]{String.class}, new Object[]{value});
    }

    public void setAbstract(Boolean b) {
        Util.invokeMethod(this.getTarget(), "setAbstract", new Class[]{Boolean.class}, new Object[]{b});
    }

    public void addProperty(IProperty property) {
        Object propertyTarget = Util.invokeMethod(property, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "addProperty", new Class[]{this.getPropertyClass()}, new Object[]{propertyTarget});
        this.properties = null;
        this.propertyClosures = null;
    }

    public boolean isInstanceOfJoinedSubclass() {
        return this.getJoinedSubclassClass().isAssignableFrom(this.getTarget().getClass());
    }

    public void setTable(ITable table) {
        if (this.isInstanceOfRootClass() || this.isInstanceOfJoinedSubclass()) {
            Object tableTarget = Util.invokeMethod(table, "getTarget", new Class[0], new Object[0]);
            Util.invokeMethod(this.getTarget(), "setTable", new Class[]{this.getTableClass()}, new Object[]{tableTarget});
        }
    }

    public void setKey(IValue value) {
        Object valueTarget = Util.invokeMethod(value, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setKey", new Class[]{this.getKeyValueClass()}, new Object[]{valueTarget});
    }

    public boolean isInstanceOfSpecialRootClass() {
        return false;
    }

    public IProperty getProperty() {
        throw new RuntimeException("getProperty() is only allowed on SpecialRootClass");
    }

    public IProperty getParentProperty() {
        throw new RuntimeException("getProperty() is only allowed on SpecialRootClass");
    }

    public void setIdentifierProperty(IProperty property) {
        Object propertyTarget = Util.invokeMethod(property, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setIdentifierProperty", new Class[]{this.getPropertyClass()}, new Object[]{propertyTarget});
        this.identifierProperty = property;
    }

    public void setIdentifier(IValue value) {
        Object valueTarget = Util.invokeMethod(value, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setIdentifier", new Class[]{this.getKeyValueClass()}, new Object[]{valueTarget});
        this.identifier = value;
    }

    public void setDiscriminator(IValue discr) {
        Object discrTarget = Util.invokeMethod(discr, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setDiscriminator", new Class[]{this.getValueClass()}, new Object[]{discrTarget});
        this.discriminator = discr;
    }

    public void setProxyInterfaceName(String name) {
        Util.invokeMethod(this.getTarget(), "setProxyInterfaceName", new Class[]{String.class}, new Object[]{name});
    }

    public void setLazy(boolean b) {
        Util.invokeMethod(this.getTarget(), "setLazy", new Class[]{Boolean.TYPE}, new Object[]{b});
    }

    public Iterator<IPersistentClass> getSubclassIterator() {
        if (this.subclasses == null) {
            this.initializeSubclasses();
        }
        return this.subclasses.iterator();
    }

    public ITable getRootTable() {
        Object targetRootTable;
        if (this.rootTable == null && (targetRootTable = Util.invokeMethod(this.getTarget(), "getRootTable", new Class[0], new Object[0])) != null) {
            this.rootTable = this.getFacadeFactory().createTable(targetRootTable);
        }
        return this.rootTable;
    }

    public boolean isCustomDeleteCallable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isCustomDeleteCallable", new Class[0], new Object[0]);
    }

    public boolean isCustomInsertCallable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isCustomInsertCallable", new Class[0], new Object[0]);
    }

    public boolean isCustomUpdateCallable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isCustomUpdateCallable", new Class[0], new Object[0]);
    }

    public boolean isDiscriminatorInsertable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isDiscriminatorInsertable", new Class[0], new Object[0]);
    }

    public boolean isDiscriminatorValueNotNull() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isDiscriminatorValueNotNull", new Class[0], new Object[0]);
    }

    public boolean isDiscriminatorValueNull() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isDiscriminatorValueNull", new Class[0], new Object[0]);
    }

    public boolean isExplicitPolymorphism() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isExplicitPolymorphism", new Class[0], new Object[0]);
    }

    public boolean isForceDiscriminator() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isForceDiscriminator", new Class[0], new Object[0]);
    }

    public boolean isInherited() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isInherited", new Class[0], new Object[0]);
    }

    public boolean isJoinedSubclass() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isJoinedSubclass", new Class[0], new Object[0]);
    }

    public boolean isLazy() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isLazy", new Class[0], new Object[0]);
    }

    public boolean isLazyPropertiesCacheable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isLazyPropertiesCacheable", new Class[0], new Object[0]);
    }

    public boolean isMutable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isMutable", new Class[0], new Object[0]);
    }

    public boolean isPolymorphic() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isPolymorphic", new Class[0], new Object[0]);
    }

    public boolean isVersioned() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isVersioned", new Class[0], new Object[0]);
    }

    public int getBatchSize() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getBatchSize", new Class[0], new Object[0]);
    }

    public String getCacheConcurrencyStrategy() {
        return (String)Util.invokeMethod(this.getTarget(), "getCacheConcurrencyStrategy", new Class[0], new Object[0]);
    }

    public String getCustomSQLDelete() {
        return (String)Util.invokeMethod(this.getTarget(), "getCustomSQLDelete", new Class[0], new Object[0]);
    }

    public String getCustomSQLInsert() {
        return (String)Util.invokeMethod(this.getTarget(), "getCustomSQLInsert", new Class[0], new Object[0]);
    }

    public String getCustomSQLUpdate() {
        return (String)Util.invokeMethod(this.getTarget(), "getCustomSQLUpdate", new Class[0], new Object[0]);
    }

    public String getDiscriminatorValue() {
        return (String)Util.invokeMethod(this.getTarget(), "getDiscriminatorValue", new Class[0], new Object[0]);
    }

    public String getLoaderName() {
        return (String)Util.invokeMethod(this.getTarget(), "getLoaderName", new Class[0], new Object[0]);
    }

    public String getTemporaryIdTableDDL() {
        return (String)Util.invokeMethod(this.getTarget(), "getTemporaryIdTableDDL", new Class[0], new Object[0]);
    }

    public String getTemporaryIdTableName() {
        return (String)Util.invokeMethod(this.getTarget(), "getTemporaryIdTableName", new Class[0], new Object[0]);
    }

    public String getWhere() {
        return (String)Util.invokeMethod(this.getTarget(), "getWhere", new Class[0], new Object[0]);
    }

    public int getOptimisticLockMode() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getOptimisticLockMode", new Class[0], new Object[0]);
    }

    protected Class<?> getRootClassClass() {
        return Util.getClass(this.getRootClassClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getSubclassClass() {
        return Util.getClass(this.getSubclassClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getPropertyClass() {
        return Util.getClass(this.getPropertyClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getJoinedSubclassClass() {
        return Util.getClass(this.getJoinedSubclassClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getTableClass() {
        return Util.getClass(this.getTableClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getKeyValueClass() {
        return Util.getClass(this.getKeyValueClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getValueClass() {
        return Util.getClass(this.getValueClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getRootClassClassName() {
        return "org.hibernate.mapping.RootClass";
    }

    protected String getSubclassClassName() {
        return "org.hibernate.mapping.Subclass";
    }

    protected String getPropertyClassName() {
        return "org.hibernate.mapping.Property";
    }

    protected String getJoinedSubclassClassName() {
        return "org.hibernate.mapping.JoinedSubclass";
    }

    protected String getTableClassName() {
        return "org.hibernate.mapping.Table";
    }

    protected String getKeyValueClassName() {
        return "org.hibernate.mapping.KeyValue";
    }

    protected String getValueClassName() {
        return "org.hibernate.mapping.Value";
    }

    protected void initializePropertyClosures() {
        this.propertyClosures = new HashSet();
        Iterator targetPropertyClosures = (Iterator)Util.invokeMethod(this.getTarget(), "getPropertyClosureIterator", new Class[0], new Object[0]);
        while (targetPropertyClosures.hasNext()) {
            this.propertyClosures.add(this.getFacadeFactory().createProperty(targetPropertyClosures.next()));
        }
    }

    protected void initializeProperties() {
        this.properties = new HashMap();
        Iterator targetPropertyIterator = (Iterator)Util.invokeMethod(this.getTarget(), "getPropertyIterator", new Class[0], new Object[0]);
        while (targetPropertyIterator.hasNext()) {
            Object property = targetPropertyIterator.next();
            String propertyName = (String)Util.invokeMethod(property, "getName", new Class[0], new Object[0]);
            this.properties.put(propertyName, this.getFacadeFactory().createProperty(property));
        }
    }

    protected void initializeJoins() {
        this.joins = new HashSet();
        Iterator targetJoinIterator = (Iterator)Util.invokeMethod(this.getTarget(), "getJoinIterator", new Class[0], new Object[0]);
        while (targetJoinIterator.hasNext()) {
            this.joins.add(this.getFacadeFactory().createJoin(targetJoinIterator.next()));
        }
    }

    protected void initializeSubclasses() {
        this.subclasses = new HashSet();
        Iterator targetSubclassIterator = (Iterator)Util.invokeMethod(this.getTarget(), "getSubclassIterator", new Class[0], new Object[0]);
        while (targetSubclassIterator.hasNext()) {
            this.subclasses.add(this.getFacadeFactory().createPersistentClass(targetSubclassIterator.next()));
        }
    }
}

