/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.creation.core.JBossWSCreationCorePlugin;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class ServiceSampleCreationCommand
extends AbstractDataModelOperation {
    private ServiceModel model;
    private IResource resource;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public ServiceSampleCreationCommand(ServiceModel model) {
        this.model = model;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IJavaProject project = this.model.getJavaProject();
        ICompilationUnit createdClass = this.createJavaClass(this.model.getCustomPackage(), JBossWSCreationUtils.classNameFromQualifiedName(this.model.getServiceClasses().get(0)), project);
        if (createdClass != null) {
            this.resource = createdClass.getResource();
        }
        return null;
    }

    private ICompilationUnit createJavaClass(String packageName, String className, IJavaProject project) {
        try {
            Path srcPath = new Path(JBossWSCreationUtils.getJavaProjectSrcLocation(project.getProject()));
            srcPath = project.getPath().append(srcPath.makeRelativeTo(project.getProject().getLocation()));
            IPackageFragmentRoot root = project.findPackageFragmentRoot((IPath)srcPath);
            if (packageName == null) {
                packageName = "";
            }
            IPackageFragment pkg = root.createPackageFragment(packageName, false, null);
            ICompilationUnit wrapperCls = pkg.createCompilationUnit(String.valueOf(className) + ".java", "", true, null);
            if (!packageName.equals("")) {
                wrapperCls.createPackageDeclaration(packageName, null);
            }
            StringBuffer clsContent = new StringBuffer();
            clsContent.append("@WebService()").append(LINE_SEPARATOR);
            clsContent.append("public class ").append(className).append(" {" + LINE_SEPARATOR);
            clsContent.append("}").append(LINE_SEPARATOR);
            wrapperCls.createType(clsContent.toString(), null, true, null);
            wrapperCls.createImport("javax.jws.WebMethod", null, null);
            wrapperCls.createImport("javax.jws.WebService", null, null);
            IType serviceClsType = wrapperCls.findPrimaryType();
            clsContent = new StringBuffer();
            clsContent.append("@WebMethod()");
            clsContent.append(LINE_SEPARATOR);
            clsContent.append("public String sayHello(String name) {");
            clsContent.append(LINE_SEPARATOR);
            clsContent.append("    System.out.println(\"Hello: \" + name);");
            clsContent.append(LINE_SEPARATOR);
            clsContent.append("    return \"Hello \" + name + \"!\";");
            clsContent.append(LINE_SEPARATOR);
            clsContent.append("}");
            serviceClsType.createMethod(clsContent.toString(), null, true, null);
            wrapperCls.save(null, true);
            return wrapperCls;
        }
        catch (Exception e) {
            JBossWSCreationCorePlugin.getDefault().logError(e);
            return null;
        }
    }
}

