/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeClassPathInitializer;
import org.jboss.tools.ws.creation.core.JBossWSCreationCorePlugin;
import org.jboss.tools.ws.creation.core.data.ServiceModel;

public class RemoveClientJarsCommand
extends AbstractDataModelOperation {
    private ServiceModel model;

    public RemoveClientJarsCommand(ServiceModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeOverride(monitor);
    }

    public IStatus executeOverride(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        IJavaProject project = this.model.getJavaProject();
        status = this.removeClassPath(project);
        return status;
    }

    private IStatus removeClassPath(IJavaProject project) {
        IStatus status = Status.OK_STATUS;
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = project.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                if (container instanceof JBossWSRuntimeClassPathInitializer.JBossWSRuntimeClasspathContainer) {
                    ((JBossWSRuntimeClassPathInitializer.JBossWSRuntimeClasspathContainer)container).removeEntry("jaxws-rt.jar");
                    ((JBossWSRuntimeClassPathInitializer.JBossWSRuntimeClasspathContainer)container).removeEntry("jaxws-tools.jar");
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JBossWSCreationCorePlugin.getDefault().logError(e);
        }
        return status;
    }
}

