/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class InitialClientCommand
extends AbstractDataModelOperation {
    private ServiceModel model;
    private IWebServiceClient wsClient;
    private int scenario;

    public InitialClientCommand(ServiceModel model, IWebServiceClient wsClient, int scenario) {
        this.model = model;
        this.wsClient = wsClient;
        this.scenario = scenario;
        model.setWsScenario(scenario);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IJavaProject project = null;
        try {
            project = JavaCore.create((IProject)JBossWSCreationUtils.getProjectByName(this.model.getWebProjectName()));
            this.model.setJavaProject(project);
            String location = JBossWSCreationUtils.getJBossWSRuntimeLocation(project.getProject());
            if (location.equals("")) {
                return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_WS_Location);
            }
            if (!new Path(location).append(JBossWSCreationCoreMessages.Bin).append(JBossWSCreationCoreMessages.Command).toFile().exists()) {
                return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_WS_Location);
            }
        }
        catch (CoreException coreException) {
            return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_WS_Location);
        }
        this.model.setTarget(JBossWSCreationCoreMessages.Value_Target_0);
        try {
            List<String> list = JBossWSCreationUtils.getJavaProjectSrcFolder(project.getProject());
            if (list == null || list.size() <= 0) {
                return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_No_SourceFolder);
            }
            this.model.setSrcList(list);
            this.model.setJavaSourceFolder(list.get(0));
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        if (this.scenario == 2) {
            this.model.setWsdlURI(this.wsClient.getWebServiceClientInfo().getWsdlURL());
            Definition definition = null;
            try {
                definition = JBossWSCreationUtils.readWSDL(this.model.getWsdlURI());
            }
            catch (WSDLException wSDLException) {
                return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Read_WSDL);
            }
            this.model.setWsdlDefinition(definition);
            this.model.setCustomPackage("");
        }
        return Status.OK_STATUS;
    }

    public ServiceModel getWebServiceDataModel() {
        return this.model;
    }
}

