/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCorePlugin;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class ClientSampleCreationCommand
extends AbstractDataModelOperation {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String PACAKAGE = ".*";
    private ServiceModel model;
    private int serviceNum = 1;
    private int portNum = 1;
    private int argsNum = 0;

    public ClientSampleCreationCommand(ServiceModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.argsNum = 0;
        IStatus status = Status.OK_STATUS;
        IJavaProject project = this.model.getJavaProject();
        List<ICompilationUnit> clientUnits = JBossWSCreationUtils.findJavaUnitsByAnnotation(project, JBossWSCreationCoreMessages.WebserviceClient_Annotation, this.model.getCustomPackage());
        List<ICompilationUnit> serviceUnits = JBossWSCreationUtils.findJavaUnitsByAnnotation(project, JBossWSCreationCoreMessages.Webservice_Annotation, this.model.getCustomPackage());
        if (clientUnits.size() == 0) {
            return status;
        }
        LinkedList<String> packageList = new LinkedList<String>();
        for (ICompilationUnit unit : clientUnits) {
            if (packageList.contains(unit.getParent().getElementName())) continue;
            packageList.add(unit.getParent().getElementName());
        }
        int j = 0;
        while (j < packageList.size()) {
            status = this.createImplClass((String)packageList.get(j), project, clientUnits, serviceUnits);
            if (!status.isOK()) break;
            ++j;
        }
        return status;
    }

    private IStatus createImplClass(String packageName, IJavaProject project, List<ICompilationUnit> clientUnits, List<ICompilationUnit> serviceUnits) {
        ICompilationUnit clientCls = this.createJavaClass(String.valueOf(packageName) + JBossWSCreationCoreMessages.Client_Sample_Package_Name, JBossWSCreationCoreMessages.Client_Sample_Class_Name, false, null, project);
        if (clientCls == null) {
            return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Create_Client_Sample);
        }
        try {
            clientCls.createImport(String.valueOf(packageName) + PACAKAGE, null, null);
            clientCls.save(null, true);
        }
        catch (Exception e1) {
            JBossWSCreationCorePlugin.getDefault().logError(e1);
            return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Create_Client_Sample);
        }
        IType clientClsType = clientCls.findPrimaryType();
        StringBuffer sb = new StringBuffer();
        sb.append("public static void main(String[] args) {");
        sb.append(LINE_SEPARATOR);
        sb.append("        System.out.println(\"***********************\");");
        sb.append(LINE_SEPARATOR);
        this.createWebServiceClient(clientUnits, serviceUnits, sb, packageName);
        sb.append("        System.out.println(\"***********************\");");
        sb.append(LINE_SEPARATOR);
        sb.append("        System.out.println(\"").append(JBossWSCreationCoreMessages.Client_Sample_Run_Over).append("\");");
        sb.append(LINE_SEPARATOR);
        sb.append("}");
        try {
            clientClsType.createMethod(sb.toString(), null, true, null);
            clientCls.save(null, true);
        }
        catch (JavaModelException e) {
            JBossWSCreationCorePlugin.getDefault().logError(e);
            return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Create_Client_Sample);
        }
        return Status.OK_STATUS;
    }

    public ICompilationUnit createJavaClass(String packageName, String className, boolean isInterface, String interfaceName, IJavaProject javaProject) {
        try {
            IPackageFragmentRoot root = JBossWSCreationUtils.getPackageFragmentRoot(javaProject, this.model.getJavaSourceFolder());
            if (packageName == null) {
                packageName = "";
            }
            IPackageFragment pkg = root.createPackageFragment(packageName, false, null);
            ICompilationUnit wrapperCls = pkg.createCompilationUnit(String.valueOf(className) + ".java", "", true, null);
            if (!packageName.equals("")) {
                wrapperCls.createPackageDeclaration(packageName, null);
            }
            String clsContent = "";
            if (isInterface) {
                clsContent = "public interface " + className + " {" + LINE_SEPARATOR;
                clsContent = String.valueOf(clsContent) + "}" + LINE_SEPARATOR;
            } else {
                clsContent = "public class " + className;
                if (interfaceName != null) {
                    clsContent = String.valueOf(clsContent) + " implements " + interfaceName;
                }
                clsContent = String.valueOf(clsContent) + " {" + LINE_SEPARATOR;
                clsContent = String.valueOf(clsContent) + "}" + LINE_SEPARATOR;
            }
            wrapperCls.createType(clsContent, null, true, null);
            wrapperCls.save(null, true);
            return wrapperCls;
        }
        catch (Exception e) {
            JBossWSCreationCorePlugin.getDefault().logError(e);
            return null;
        }
    }

    private void createWebServiceClient(List<ICompilationUnit> clientUnits, List<ICompilationUnit> serviceUnits, StringBuffer sb, String packageName) {
        sb.append("        System.out.println(\"Create Web Service Client...\");");
        sb.append(LINE_SEPARATOR);
        for (ICompilationUnit unit : clientUnits) {
            MethodDeclaration[] methodDec;
            if (!packageName.equals(unit.getParent().getElementName())) continue;
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(unit);
            parser.setResolveBindings(false);
            parser.setFocalPosition(0);
            CompilationUnit result = (CompilationUnit)parser.createAST(null);
            List types = result.types();
            TypeDeclaration typeDec = (TypeDeclaration)types.get(0);
            sb.append("        " + typeDec.getName());
            sb.append(" service").append(this.serviceNum).append(" = new ");
            sb.append(typeDec.getName());
            sb.append("();");
            sb.append(LINE_SEPARATOR);
            MethodDeclaration[] methodDeclarationArray = methodDec = typeDec.getMethods();
            int n = methodDec.length;
            int n2 = 0;
            while (n2 < n) {
                NormalAnnotation anno;
                MethodDeclaration method = methodDeclarationArray[n2];
                if (method.modifiers().get(0) instanceof NormalAnnotation && (anno = (NormalAnnotation)method.modifiers().get(0)).getTypeName().getFullyQualifiedName().equals(JBossWSCreationCoreMessages.WebEndpoint)) {
                    this.createWebService(serviceUnits, method, sb);
                    ++this.portNum;
                }
                ++n2;
            }
            ++this.serviceNum;
        }
    }

    private void createWebService(List<ICompilationUnit> serviceUnits, MethodDeclaration method, StringBuffer sb) {
        sb.append("        System.out.println(\"Create Web Service...\");");
        sb.append(LINE_SEPARATOR);
        sb.append("        " + method.getReturnType2().toString());
        sb.append(" port").append(this.portNum).append(" = ");
        sb.append("service").append(this.serviceNum).append(".");
        sb.append(method.getName()).append("();");
        sb.append(LINE_SEPARATOR);
        for (ICompilationUnit unit : serviceUnits) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(unit);
            parser.setResolveBindings(false);
            parser.setFocalPosition(0);
            CompilationUnit result = (CompilationUnit)parser.createAST(null);
            List types = result.types();
            TypeDeclaration typeDec1 = (TypeDeclaration)types.get(0);
            if (!typeDec1.getName().toString().equals(method.getReturnType2().toString())) continue;
            this.callWebServiceOperation(typeDec1, sb);
        }
    }

    private void callWebServiceOperation(TypeDeclaration typeDec, StringBuffer sb) {
        MethodDeclaration[] methodDec;
        sb.append("        System.out.println(\"Call Web Service Operation...\");");
        sb.append(LINE_SEPARATOR);
        MethodDeclaration[] methodDeclarationArray = methodDec = typeDec.getMethods();
        int n = methodDec.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (method.getReturnType2().toString().equals("void")) {
                sb.append("        System.out.println(\"Server said: ");
                sb.append("port").append(this.portNum).append(".");
                sb.append(method.getName()).append("() is a void method!\");");
                sb.append(LINE_SEPARATOR);
            } else {
                sb.append("        System.out.println(\"Server said: \" + ");
                sb.append("port").append(this.portNum).append(".");
                sb.append(method.getName()).append("(");
                boolean noNull = true;
                int j = 0;
                while (j < method.parameters().size()) {
                    noNull = this.createWebServiceOperationParameters(method.parameters(), sb, j) && noNull;
                    ++j;
                }
                sb.append("));");
                sb.append(LINE_SEPARATOR);
                if (!noNull) {
                    sb.append("        //Please input the parameters instead of 'null' for the upper method!");
                    sb.append(LINE_SEPARATOR);
                    sb.append(LINE_SEPARATOR);
                }
            }
            ++n2;
        }
    }

    private boolean createWebServiceOperationParameters(List list, StringBuffer sb, int j) {
        SingleVariableDeclaration para = (SingleVariableDeclaration)list.get(j);
        if (para.getType().isPrimitiveType()) {
            PrimitiveType type = (PrimitiveType)para.getType();
            PrimitiveType.Code code = type.getPrimitiveTypeCode();
            if (PrimitiveType.INT.equals(code)) {
                sb.append("Integer.parseInt(args[");
            } else if (PrimitiveType.BOOLEAN.equals(code)) {
                sb.append("Boolean.parseBoolean(args[");
            } else if (PrimitiveType.BYTE.equals(code)) {
                sb.append("Byte.parseByte(args[");
            } else if (PrimitiveType.SHORT.equals(code)) {
                sb.append("Short.parseShort((args[");
            } else if (PrimitiveType.LONG.equals(code)) {
                sb.append("Long.parseLong(args[");
            } else if (PrimitiveType.FLOAT.equals(code)) {
                sb.append("Float.parseFloat(args[");
            } else if (PrimitiveType.DOUBLE.equals(code)) {
                sb.append("Double.parseDouble(args[");
            } else {
                if (PrimitiveType.CHAR.equals(code)) {
                    sb.append("args[").append(this.argsNum).append("]");
                    this.countArgs(j, sb, list);
                    ++this.argsNum;
                }
                return true;
            }
            sb.append(this.argsNum).append("])");
            this.countArgs(j, sb, list);
            ++this.argsNum;
            return true;
        }
        if ("String".equals(para.getType().toString())) {
            sb.append("args[").append(this.argsNum).append("]");
            this.countArgs(j, sb, list);
            ++this.argsNum;
            return true;
        }
        if (list.get(j) instanceof Object) {
            sb.append("null");
            this.countArgs(j, sb, list);
            return false;
        }
        return true;
    }

    private void countArgs(int j, StringBuffer sb, List list) {
        if (j != list.size() - 1) {
            sb.append(",");
        }
    }
}

