/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.xml;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.internal.core.SeamPropertiesDeclaration;
import org.jboss.tools.seam.internal.core.SeamProperty;
import org.jboss.tools.seam.internal.core.SeamValueString;
import org.jboss.tools.seam.internal.core.scanner.IFileScanner;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;

public class PropertiesScanner
implements IFileScanner {
    @Override
    public boolean isRelevant(IFile resource) {
        return resource.getName().equals("seam.properties");
    }

    @Override
    public boolean isLikelyComponentSource(IFile f) {
        return f.isSynchronized(0) && f.exists() && f.getName().equals("seam.properties");
    }

    @Override
    public LoadedDeclarations parse(IFile f, ISeamProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        return this.parse(o, f.getFullPath());
    }

    public LoadedDeclarations parse(XModelObject o, IPath source) {
        LoadedDeclarations ds = null;
        if (o != null) {
            IFile f;
            if (o.getParent() instanceof FolderImpl && (f = ResourcesPlugin.getWorkspace().getRoot().getFile(source)) != null && f.exists()) {
                try {
                    ((FolderImpl)o.getParent()).updateChildFile(o, f.getLocation().toFile());
                }
                catch (XModelException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ds = new LoadedDeclarations();
            XModelObject[] properties = o.getChildren();
            HashMap<String, SeamPropertiesDeclaration> ds1 = new HashMap<String, SeamPropertiesDeclaration>();
            int i = 0;
            while (i < properties.length) {
                String name = properties[i].getAttributeValue("name");
                int q = name.lastIndexOf(46);
                if (q >= 0) {
                    String componentName = name.substring(0, q);
                    String propertyName = name.substring(q + 1);
                    SeamPropertiesDeclaration d = (SeamPropertiesDeclaration)ds1.get(componentName);
                    if (d == null) {
                        d = new SeamPropertiesDeclaration();
                        d.setId(properties[i]);
                        d.setSourcePath(source);
                        d.setName(componentName);
                        ds1.put(componentName, d);
                    }
                    SeamProperty p = new SeamProperty();
                    p.setId(properties[i]);
                    p.setName((IValueInfo)new XMLValueInfo(properties[i], "name"));
                    p.setName(propertyName);
                    SeamValueString v = new SeamValueString();
                    v.setValue((IValueInfo)new XMLValueInfo(properties[i], "value"));
                    p.setValue(v);
                    d.addProperty(p);
                }
                ++i;
            }
            ds.getComponents().addAll(ds1.values());
        }
        return ds;
    }
}

