/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamContextShortVariable;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.internal.core.refactoring.SeamRenameProcessor;

public class RenameSeamContextVariableProcessor
extends SeamRenameProcessor {
    IFile file;

    public RenameSeamContextVariableProcessor(IFile file, String oldName) {
        this.file = file;
        this.setOldName(oldName);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.status = new RefactoringStatus();
        this.rootChange = new CompositeChange(SeamCoreMessages.RENAME_SEAM_CONTEXT_VARIABLE_PROCESSOR_TITLE);
        if (this.component != null) {
            this.checkDeclarations(this.component);
            if (this.status.hasFatalError()) {
                return this.status;
            }
            this.renameComponent(pm, this.component);
        } else {
            this.renameSeamContextVariable(pm, this.file);
        }
        return this.status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        boolean status = false;
        this.component = this.checkComponent();
        if (this.component == null) {
            status = this.checkContextVariable();
        } else {
            this.setOldName(this.component.getName());
        }
        if (this.component == null && !status) {
            result.addFatalError(Messages.format((String)SeamCoreMessages.RENAME_SEAM_CONTEXT_VARIABLE_PROCESSOR_CAN_NOT_FIND_CONTEXT_VARIABLE, (Object)this.getOldName()));
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.rootChange;
    }

    private ISeamComponent checkComponent() {
        IProject[] projects;
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(this.file.getProject(), true);
        this.projectsSet = new SeamProjectsSet(this.file.getProject());
        ISeamComponent comp = this.checkComponent(seamProject);
        if (comp != null) {
            return comp;
        }
        IProject[] iProjectArray = projects = this.projectsSet.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ISeamProject sProject = SeamCorePlugin.getSeamProject(project, true);
            if (sProject != null && (comp = this.checkComponent(sProject)) != null) {
                return comp;
            }
            ++n2;
        }
        return null;
    }

    private ISeamComponent checkComponent(ISeamProject seamProject) {
        if (seamProject != null) {
            ISeamComponent component = seamProject.getComponent(this.getOldName());
            if (component != null) {
                return component;
            }
            Set<ISeamContextVariable> variables = seamProject.getVariablesByName(this.getOldName());
            if (variables == null) {
                return null;
            }
            for (ISeamContextVariable variable : variables) {
                ISeamContextVariable original;
                if (!(variable instanceof ISeamContextShortVariable) || !((original = ((ISeamContextShortVariable)variable).getOriginal()) instanceof ISeamComponent)) continue;
                return (ISeamComponent)original;
            }
        }
        return null;
    }

    private boolean checkContextVariable() {
        IProject[] projects;
        boolean status = false;
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(this.file.getProject(), true);
        status = this.checkFactories(seamProject);
        if (status) {
            return status;
        }
        status = this.checkOuts(seamProject);
        if (status) {
            return status;
        }
        status = this.checkDataModels(seamProject);
        if (status) {
            return status;
        }
        IProject[] iProjectArray = projects = this.projectsSet.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ISeamProject sProject = SeamCorePlugin.getSeamProject(project, true);
            if (sProject != null) {
                status = this.checkFactories(sProject);
                if (status) {
                    return status;
                }
                status = this.checkOuts(sProject);
                if (status) {
                    return status;
                }
                status = this.checkDataModels(sProject);
                if (status) {
                    return status;
                }
            }
            ++n2;
        }
        return status;
    }

    private boolean checkFactories(ISeamProject seamProject) {
        if (seamProject != null) {
            Set<ISeamFactory> factories = seamProject.getFactoriesByName(this.getOldName());
            return factories.size() > 0;
        }
        return false;
    }

    private boolean checkOuts(ISeamProject seamProject) {
        if (seamProject != null) {
            Set<IBijectedAttribute> variables = seamProject.getBijectedAttributesByName(this.getOldName(), BijectedAttributeType.OUT);
            return variables.size() > 0;
        }
        return false;
    }

    private boolean checkDataModels(ISeamProject seamProject) {
        if (seamProject != null) {
            Set<IBijectedAttribute> variables = seamProject.getBijectedAttributesByName(this.getOldName(), BijectedAttributeType.DATA_BINDER);
            return variables.size() > 0;
        }
        return false;
    }

    public Object[] getElements() {
        return new String[]{this.getNewName()};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return SeamCoreMessages.RENAME_SEAM_CONTEXT_VARIABLE_PROCESSOR_TITLE;
    }

    public boolean isApplicable() throws CoreException {
        return this.getNewName() != null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REF_PARTICIPANT;
    }
}

