/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.Seam23FacetInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.Seam2ProjectCreator;
import org.jboss.tools.seam.internal.core.project.facet.SeamLibFileSetProvider;

public class Seam23ProjectCreator
extends Seam2ProjectCreator {
    public Seam23ProjectCreator(IDataModel model, IProject seamWebProject, SeamLibFileSetProvider seamLibFileSetProvider) {
        super(model, seamWebProject, seamLibFileSetProvider);
    }

    @Override
    protected void configureJBossAppXml() {
    }

    @Override
    protected void copyJBossApp() {
        FilterSet earFilterSet = new FilterSet();
        earFilterSet.addFilter("projectName", String.valueOf(this.earProjectFolder.getName()) + ".ear");
        earFilterSet.addFilter("earProjectName", this.earProjectName);
        earFilterSet.addFilter("ejbProjectName", this.ejbProjectName);
        earFilterSet.addFilter("testProjectName", this.testProjectName);
        AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "META-INF/jboss-deployment-structure.xml"), new File(this.earContentsFolder, "META-INF"), new FilterSetCollection(earFilterSet), true);
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        super.execute(monitor);
        if ("ear".equals(this.model.getProperty("seam.project.deployment.type"))) {
            IProject earProject = this.seamWebProject.getWorkspace().getRoot().getProject(this.earProjectName);
            File destFolder = new File(this.earProjectFolder, "resources");
            Seam23FacetInstallDelegate.copyDBDriverToProject(earProject, this.model, destFolder);
        }
    }

    @Override
    protected void createComponentsProperties() {
        File seamGenResFolder = new File(this.ejbProjectFolder, "ejbModule");
        String jndiPattern = "java:app/" + this.ejbProjectName + "/#{ejbName}";
        Properties components = new Properties();
        components.put("jndiPattern", jndiPattern);
        components.put("embeddedEjb", "false");
        File componentsProps = new File(seamGenResFolder, "components.properties");
        try {
            componentsProps.createNewFile();
            components.store(new FileOutputStream(componentsProps), "");
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

